/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class LogBuilder {
    private class_2561 title;
    private List<class_2561> entriesCurrent;
    private List<Section> sections = new ArrayList<Section>();
    private class_2561 currentText = null;
    private int duplicateCount = 0;

    private static class_2561 duplicatedText(class_2561 currentText, int duplicateCount) {
        if (duplicateCount < 2) {
            return currentText;
        }
        return class_2561.method_43473().method_10852(currentText).method_10852((class_2561)class_2561.method_43470((String)(" (" + duplicateCount + ")")).method_27692(class_124.field_1078));
    }

    public static String stringify(List<Section> sections) {
        StringBuilder builder = new StringBuilder();
        Iterator<Section> sectionIterator = sections.iterator();
        while (sectionIterator.hasNext()) {
            Section entry = sectionIterator.next();
            builder.append("## " + entry.title().getString());
            if (!entry.entries.isEmpty()) {
                builder.append("\n");
                Iterator<class_2561> entryIteration = entry.entries.iterator();
                while (entryIteration.hasNext()) {
                    builder.append("   " + entryIteration.next().getString());
                    if (!entryIteration.hasNext()) continue;
                    builder.append("\n");
                }
            }
            if (!sectionIterator.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public void pushT(String id, String lang, Object ... args) {
        this.push((class_2561)class_2561.method_48322((String)("frozenlib.core.registry_sync.log." + id), (String)lang, (Object[])args));
    }

    public void push(class_2561 title) {
        if (this.title != null) {
            this.sections.add(new Section(this.title, this.entriesCurrent));
        }
        this.title = title;
        this.entriesCurrent = new ArrayList<class_2561>();
    }

    public void textEntry(class_2561 text) {
        this.text((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43473().method_10852(text)).method_27692(class_124.field_1080));
    }

    public void text(class_2561 text) {
        if (this.currentText != null && !text.equals((Object)this.currentText)) {
            this.entriesCurrent.add(LogBuilder.duplicatedText(this.currentText, this.duplicateCount));
            this.duplicateCount = 1;
        } else {
            ++this.duplicateCount;
        }
        this.currentText = text;
    }

    public List<Section> finish() {
        if (this.title != null) {
            ArrayList<class_2561> entries = new ArrayList<class_2561>(this.entriesCurrent);
            if (this.currentText != null) {
                entries.add(LogBuilder.duplicatedText(this.currentText, this.duplicateCount));
            }
            this.sections.add(new Section(this.title, entries));
        }
        List<Section> sections = this.sections;
        this.clear();
        return sections;
    }

    public void clear() {
        this.sections = new ArrayList<Section>();
        this.title = null;
        this.entriesCurrent = null;
    }

    public String asString() {
        ArrayList<Section> sections = new ArrayList<Section>(this.sections);
        if (this.title != null) {
            sections.add(new Section(this.title, this.entriesCurrent));
        }
        return LogBuilder.stringify(sections);
    }

    public record Section(class_2561 title, List<class_2561> entries) {
    }
}

