/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.structure.api.status.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.worldgen.structure.impl.status.PlayerStructureStatus;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public final class ClientStructureStatuses {
    private static final List<PlayerStructureStatus> STRUCTURE_STATUSES = new ArrayList<PlayerStructureStatus>();

    public static Optional<PlayerStructureStatus> getProminentStructureStatus() {
        PlayerStructureStatus chosenStatus = null;
        for (PlayerStructureStatus structureStatus : STRUCTURE_STATUSES) {
            if (chosenStatus != null && (chosenStatus.isInsidePiece() || !structureStatus.isInsidePiece())) continue;
            chosenStatus = structureStatus;
        }
        return Optional.ofNullable(chosenStatus);
    }

    @ApiStatus.Internal
    public static void setStructureStatuses(List<PlayerStructureStatus> structureStatuses) {
        ClientStructureStatuses.clearStructureStatuses();
        STRUCTURE_STATUSES.addAll(structureStatuses);
    }

    @ApiStatus.Internal
    public static void clearStructureStatuses() {
        STRUCTURE_STATUSES.clear();
    }

    @Generated
    private ClientStructureStatuses() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

