/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.structure.api;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import net.frozenblock.lib.worldgen.structure.impl.StructureSetAndPlacementInterface;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.quiltmc.qsl.frozenblock.core.registry.api.event.RegistryEvents;

public final class StructureGenerationConditionApi {
    private static final Map<class_2960, List<Supplier<Boolean>>> STRUCTURE_SET_TO_SUPPLIER_MAP = new Object2ObjectOpenHashMap();

    public static void init() {
        RegistryEvents.DYNAMIC_REGISTRY_LOADED.register(registryAccess -> registryAccess.method_46759(class_7924.field_41248).ifPresent(structureSetRegistry -> structureSetRegistry.method_29722().forEach(structureSetEntry -> {
            Object patt0$temp = structureSetEntry.getValue();
            if (!(patt0$temp instanceof StructureSetAndPlacementInterface)) {
                return;
            }
            StructureSetAndPlacementInterface setAndPlacementInterface = (StructureSetAndPlacementInterface)patt0$temp;
            setAndPlacementInterface.frozenLib$addGenerationConditions(StructureGenerationConditionApi.getGenerationConditions(((class_5321)structureSetEntry.getKey()).method_29177()));
        })));
    }

    public static void addGenerationCondition(class_2960 structureSet, Supplier<Boolean> generationCondition) {
        List list = STRUCTURE_SET_TO_SUPPLIER_MAP.getOrDefault(structureSet, new ArrayList());
        list.add(generationCondition);
        STRUCTURE_SET_TO_SUPPLIER_MAP.put(structureSet, list);
    }

    public static List<Supplier<Boolean>> getGenerationConditions(class_2960 structureSet) {
        return STRUCTURE_SET_TO_SUPPLIER_MAP.getOrDefault(structureSet, (List<Supplier<Boolean>>)ImmutableList.of());
    }

    @Generated
    private StructureGenerationConditionApi() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

