/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6646;

public class NoiseBandBlockPlacement {
    public static final Codec<NoiseBandBlockPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("state_provider").forGetter(config -> config.blockStateProvider), (App)Codec.doubleRange((double)-1.0, (double)1.0).lenientOptionalFieldOf("minimum_noise_threshold", (Object)1.0).forGetter(config -> config.minNoiseThreshold), (App)Codec.doubleRange((double)-1.0, (double)1.0).lenientOptionalFieldOf("maximum_noise_threshold", (Object)1.0).forGetter(config -> config.maxNoiseThreshold), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("placement_chance", (Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.placementChance)), (App)Codec.BOOL.lenientOptionalFieldOf("schedule_tick_on_placement", (Object)false).forGetter(config -> config.scheduleTickOnPlacement), (App)class_6646.field_35054.fieldOf("replacement_block_predicate").forGetter(config -> config.replacementPredicate), (App)class_6646.field_35054.fieldOf("searching_block_predicate").forGetter(config -> config.searchingPredicate), (App)Codec.INT.lenientOptionalFieldOf("vertical_placement_offset", (Object)0).forGetter(config -> config.verticalPlacementOffset)).apply((Applicative)instance, NoiseBandBlockPlacement::new));
    private final class_4651 blockStateProvider;
    private final double minNoiseThreshold;
    private final double maxNoiseThreshold;
    private final float placementChance;
    private final boolean scheduleTickOnPlacement;
    private final class_6646 replacementPredicate;
    private final class_6646 searchingPredicate;
    private final int verticalPlacementOffset;

    public NoiseBandBlockPlacement(class_4651 stateProvider, double minNoiseThreshold, double maxNoiseThreshold, float placementChance, boolean scheduleTickOnPlacement, class_6646 replacementPredicate, class_6646 searchingPredicate, int verticalPlacementOffset) {
        this.blockStateProvider = stateProvider;
        this.minNoiseThreshold = minNoiseThreshold;
        this.maxNoiseThreshold = maxNoiseThreshold;
        this.placementChance = placementChance;
        this.scheduleTickOnPlacement = scheduleTickOnPlacement;
        this.replacementPredicate = replacementPredicate;
        this.searchingPredicate = searchingPredicate;
        this.verticalPlacementOffset = verticalPlacementOffset;
    }

    public boolean generate(class_5281 level, class_2338.class_2339 pos, class_5819 random, double sampleOutput) {
        if (sampleOutput < this.minNoiseThreshold || sampleOutput > this.maxNoiseThreshold) {
            return false;
        }
        if (random.method_43057() > this.placementChance) {
            return false;
        }
        pos.method_10100(0, this.verticalPlacementOffset, 0);
        if (!this.replacementPredicate.test((Object)level, (Object)pos)) {
            return false;
        }
        if (!this.searchingPredicate.test((Object)level, (Object)pos)) {
            return false;
        }
        class_2680 state = this.blockStateProvider.method_23455(random, (class_2338)pos);
        level.method_8652((class_2338)pos, state, 2);
        if (this.scheduleTickOnPlacement) {
            level.method_64310((class_2338)pos, state.method_26204(), 1);
        }
        return true;
    }

    public static class Builder {
        private final class_4651 stateProvider;
        private double minNoiseThreshold = -1.0;
        private double maxNoiseThreshold = 1.0;
        private float placementChance = 1.0f;
        private boolean scheduleTickOnPlacement = false;
        private class_6646 replacementPredicate;
        private class_6646 searchingPredicate;
        private int verticalPlacementOffset = 0;

        public Builder(class_4651 stateProvider) {
            this.stateProvider = stateProvider;
        }

        public Builder minNoiseThreshold(double minNoiseThreshold) {
            this.minNoiseThreshold = minNoiseThreshold;
            return this;
        }

        public Builder maxNoiseThreshold(double maxNoiseThreshold) {
            this.maxNoiseThreshold = maxNoiseThreshold;
            return this;
        }

        public Builder within(double minNoiseThreshold, double maxNoiseThreshold) {
            this.minNoiseThreshold = minNoiseThreshold;
            this.maxNoiseThreshold = maxNoiseThreshold;
            return this;
        }

        public Builder placementChance(float placementChance) {
            this.placementChance = placementChance;
            return this;
        }

        public Builder scheduleTickOnPlacement() {
            this.scheduleTickOnPlacement = true;
            return this;
        }

        public Builder replacementPredicate(class_6646 replacementPredicate) {
            this.replacementPredicate = replacementPredicate;
            return this;
        }

        public Builder searchingPredicate(class_6646 searchingPredicate) {
            this.searchingPredicate = searchingPredicate;
            return this;
        }

        public Builder verticalPlacementOffset(int verticalPlacementOffset) {
            this.verticalPlacementOffset = verticalPlacementOffset;
            return this;
        }

        public NoiseBandBlockPlacement build() {
            if (this.searchingPredicate == null) {
                throw new IllegalArgumentException("searchingPredicate cannot be null for NoiseBandBlockPlacement!");
            }
            if (this.replacementPredicate == null) {
                throw new IllegalArgumentException("replacementPredicate cannot be null for NoiseBandBlockPlacement!");
            }
            return new NoiseBandBlockPlacement(this.stateProvider, this.minNoiseThreshold, this.maxNoiseThreshold, this.placementChance, this.scheduleTickOnPlacement, this.replacementPredicate, this.searchingPredicate, this.verticalPlacementOffset);
        }
    }
}

