/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature.disk.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6646;

public class BallOuterRingBlockPlacement {
    public static final Codec<BallOuterRingBlockPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("state_provider").forGetter(config -> config.stateProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("placement_chance", (Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.placementChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("outer_ring_start_percentage", (Object)Float.valueOf(0.0f)).forGetter(config -> Float.valueOf(config.outerRingStartPercentage)), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("chance_to_choose_in_inner_ring", (Object)Float.valueOf(0.0f)).forGetter(config -> Float.valueOf(config.chanceToChooseInInnerRing)), (App)class_6646.field_35054.fieldOf("replacement_block_predicate").forGetter(config -> config.replacementPredicate), (App)class_6646.field_35054.fieldOf("searching_block_predicate").forGetter(config -> config.searchingPredicate), (App)Codec.BOOL.lenientOptionalFieldOf("schedule_tick_on_placement", (Object)false).forGetter(config -> config.scheduleTickOnPlacement), (App)Codec.INT.lenientOptionalFieldOf("vertical_placement_offset", (Object)0).forGetter(config -> config.verticalPlacementOffset)).apply((Applicative)instance, BallOuterRingBlockPlacement::new));
    private final class_4651 stateProvider;
    private final float placementChance;
    private final float outerRingStartPercentage;
    private final float chanceToChooseInInnerRing;
    private final class_6646 replacementPredicate;
    private final class_6646 searchingPredicate;
    private final boolean scheduleTickOnPlacement;
    private final int verticalPlacementOffset;

    public BallOuterRingBlockPlacement(class_4651 stateProvider, float placementChance, float outerRingStartPercentage, float chanceToChooseInInnerRing, class_6646 replacementPredicate, class_6646 searchingPredicate, boolean scheduleTickOnPlacement, int verticalPlacementOffset) {
        this.stateProvider = stateProvider;
        this.placementChance = placementChance;
        this.outerRingStartPercentage = outerRingStartPercentage;
        this.chanceToChooseInInnerRing = chanceToChooseInInnerRing;
        this.replacementPredicate = replacementPredicate;
        this.searchingPredicate = searchingPredicate;
        this.scheduleTickOnPlacement = scheduleTickOnPlacement;
        this.verticalPlacementOffset = verticalPlacementOffset;
    }

    public float getPlacementChance() {
        return this.placementChance;
    }

    public OuterRingSelectionType chooseSelectionType(double distance, int placementRadius, float chanceToChooseInnerBlockInOuterRing, class_5819 random) {
        if (distance <= (double)((float)placementRadius * this.outerRingStartPercentage)) {
            return random.method_43057() <= chanceToChooseInnerBlockInOuterRing ? OuterRingSelectionType.FAIL : OuterRingSelectionType.SUCCESS;
        }
        return random.method_43057() <= this.chanceToChooseInInnerRing ? OuterRingSelectionType.OUTER_IN_INNER : OuterRingSelectionType.FAIL;
    }

    public boolean generate(class_5281 level, class_2338.class_2339 pos, class_5819 random, boolean isWithinOppositeRing) {
        if (!isWithinOppositeRing && random.method_43057() > this.placementChance) {
            return false;
        }
        pos.method_10100(0, this.verticalPlacementOffset, 0);
        if (!this.replacementPredicate.test((Object)level, (Object)pos)) {
            return false;
        }
        if (!this.searchingPredicate.test((Object)level, (Object)pos)) {
            return false;
        }
        class_2680 state = this.stateProvider.method_23455(random, (class_2338)pos);
        level.method_8652((class_2338)pos, state, 2);
        if (this.scheduleTickOnPlacement) {
            level.method_64310((class_2338)pos, state.method_26204(), 1);
        }
        return true;
    }

    public static enum OuterRingSelectionType {
        SUCCESS,
        OUTER_IN_INNER,
        FAIL;

    }

    public static class Builder {
        private final class_4651 stateProvider;
        private float placementChance = 1.0f;
        private float outerRingStartPercentage = 0.0f;
        private float chanceToChooseInInnerRing = 0.0f;
        private class_6646 replacementPredicate = class_6646.method_38883();
        private class_6646 searchingPredicate = class_6646.method_39011();
        private boolean scheduleTickOnPlacement = false;
        private int verticalPlacementOffset = 0;

        public Builder(class_4651 stateProvider) {
            this.stateProvider = stateProvider;
        }

        public Builder placementChance(float chance) {
            this.placementChance = chance;
            return this;
        }

        public Builder outerRingStartPercentage(float percentage) {
            this.outerRingStartPercentage = percentage;
            return this;
        }

        public Builder chanceToChooseInInnerRing(float chance) {
            this.chanceToChooseInInnerRing = chance;
            return this;
        }

        public Builder replacementPredicate(class_6646 replacementPredicate) {
            this.replacementPredicate = replacementPredicate;
            return this;
        }

        public Builder searchingPredicate(class_6646 searchingPredicate) {
            this.searchingPredicate = searchingPredicate;
            return this;
        }

        public Builder scheduleTickOnPlacement() {
            this.scheduleTickOnPlacement = true;
            return this;
        }

        public Builder verticalPlacementOffset(int verticalPlacementOffset) {
            this.verticalPlacementOffset = verticalPlacementOffset;
            return this;
        }

        public BallOuterRingBlockPlacement build() {
            return new BallOuterRingBlockPlacement(this.stateProvider, this.placementChance, this.outerRingStartPercentage, this.chanceToChooseInInnerRing, this.replacementPredicate, this.searchingPredicate, this.scheduleTickOnPlacement, this.verticalPlacementOffset);
        }
    }
}

