/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.spotting_icons.impl.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.render.FrozenLibRenderTypes;
import net.frozenblock.lib.spotting_icons.api.SpottingIconManager;
import net.frozenblock.lib.spotting_icons.impl.EntitySpottingIconInterface;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_898;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class SpottingIconRenderState {
    public boolean render;
    public class_2960 texture;
    public int alpha;
    public float renderOffsetY;

    public void extract(class_1297 entity, class_898 entityRenderDispatcher, float partialTick) {
        if (entityRenderDispatcher == null || entityRenderDispatcher.field_4686 == null || entity == null) {
            return;
        }
        SpottingIconManager iconManager = ((EntitySpottingIconInterface)entity).getSpottingIconManager();
        SpottingIconManager.SpottingIcon icon = iconManager.icon;
        if (icon == null) {
            return;
        }
        double dist = Math.sqrt(entityRenderDispatcher.field_4686.method_71156().method_1025(entity.method_5836(partialTick)));
        if (dist <= (double)icon.startFadeDist() || !iconManager.clientHasIconResource) {
            return;
        }
        this.texture = icon.texture();
        float endDist = icon.endFadeDist() - icon.startFadeDist();
        this.alpha = (int)(((dist -= (double)icon.startFadeDist()) > (double)endDist ? 1.0f : (float)Math.min(1.0, dist / (double)endDist)) * 255.0f);
        this.renderOffsetY = entity.method_17682() + 1.0f;
        this.render = true;
    }

    public void submit(class_4587 poseStack, class_10017 renderState, Quaternionf rotation, class_11659 submitNodeCollector) {
        if (!this.render) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.0f, this.renderOffsetY, 0.0f);
        poseStack.method_22907((Quaternionfc)rotation);
        poseStack.method_22905(-1.0f, 1.0f, 1.0f);
        submitNodeCollector.method_73529(0).method_73483(poseStack, FrozenLibRenderTypes.entityTranslucentEmissiveAlwaysRender(this.texture), (pose, vertexConsumer) -> SpottingIconRenderState.renderIcon(pose, vertexConsumer, renderState.field_61820, this.alpha));
        poseStack.method_22909();
    }

    private static void renderIcon(class_4587.class_4665 pose, class_4588 vertexConsumer, int packedLight, int alpha) {
        vertexConsumer.method_56824(pose, -0.5f, -0.5f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.method_56824(pose, 0.5f, -0.5f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.method_56824(pose, 0.5f, 0.5f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.method_56824(pose, -0.5f, 0.5f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
    }
}

