/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.transform;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;

public final class JsonCollectors {
    private JsonCollectors() {
    }

    public static Collector<JsonValue, JsonArray, JsonArray> value() {
        return Collector.of(JsonArray::new, JsonArray::add, (left, right) -> {
            left.addAll((JsonContainer)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static Collector<JsonReference, JsonArray, JsonArray> reference() {
        return Collector.of(JsonArray::new, JsonArray::addReference, (left, right) -> {
            left.addAll((JsonContainer)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static Collector<JsonArray.Element, JsonArray, JsonArray> element() {
        return Collector.of(JsonArray::new, (array, element) -> array.addReference(element.getReference()), (left, right) -> {
            left.addAll((JsonContainer)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static Collector<Object, JsonArray, JsonArray> any() {
        return Collector.of(JsonArray::new, (array, any) -> array.add(Json.any(any)), (left, right) -> {
            left.addAll((JsonContainer)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static Collector<JsonObject.Member, JsonObject, JsonObject> member() {
        return JsonCollectors.toObject(JsonObject.Member::getKey, JsonArray.Element::getOnly);
    }

    public static Collector<Map.Entry<?, ?>, JsonObject, JsonObject> toObject() {
        return Collector.of(JsonObject::new, (object, entry) -> object.add(entry.getKey().toString(), Json.any(entry.getValue())), (left, right) -> {
            left.addAll((JsonObject)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<Map.Entry<String, T>, JsonObject, JsonObject> toObject(Function<T, JsonValue> valueMapper) {
        return Collector.of(JsonObject::new, (object, entry) -> object.add((String)entry.getKey(), (JsonValue)valueMapper.apply(entry.getValue())), (left, right) -> {
            left.addAll((JsonObject)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, JsonObject, JsonObject> toObject(Function<T, String> keyMapper, Function<T, JsonValue> valueMapper) {
        return Collector.of(JsonObject::new, (object, t) -> object.add((String)keyMapper.apply(t), (JsonValue)valueMapper.apply(t)), (left, right) -> {
            left.addAll((JsonObject)right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }
}

