/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.writer;

import java.util.Arrays;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import org.jetbrains.annotations.ApiStatus;

public class JsonWriterOptions {
    private volatile boolean allowCondense = true;
    private volatile boolean bracesSameLine = true;
    private volatile boolean nestedSameLine = false;
    private volatile boolean omitRootBraces = true;
    private volatile boolean outputComments = true;
    private volatile boolean omitQuotes = false;
    private volatile String eol;
    private volatile String indent = "  ";
    private volatile String separator = " ";
    private volatile int minSpacing = 0;
    private volatile int maxSpacing = Integer.MAX_VALUE;
    private volatile int defaultSpacing = 1;
    private volatile boolean smartSpacing = false;
    private volatile boolean nextLineMulti = true;

    public JsonWriterOptions() {
    }

    public JsonWriterOptions(JsonWriterOptions source) {
        this.allowCondense = source.allowCondense;
        this.bracesSameLine = source.bracesSameLine;
        this.nestedSameLine = source.nestedSameLine;
        this.omitRootBraces = source.omitRootBraces;
        this.outputComments = source.outputComments;
        this.omitQuotes = source.omitQuotes;
        this.eol = source.eol;
        this.indent = source.indent;
        this.separator = source.separator;
        this.minSpacing = source.minSpacing;
        this.maxSpacing = source.maxSpacing;
        this.defaultSpacing = source.defaultSpacing;
        this.smartSpacing = source.smartSpacing;
        this.nextLineMulti = source.nextLineMulti;
    }

    public boolean isAllowCondense() {
        return this.allowCondense;
    }

    public JsonWriterOptions setAllowCondense(boolean allowCondense) {
        this.allowCondense = allowCondense;
        return this;
    }

    public boolean isBracesSameLine() {
        return this.bracesSameLine;
    }

    public JsonWriterOptions setBracesSameLine(boolean bracesSameLine) {
        this.bracesSameLine = bracesSameLine;
        return this;
    }

    @ApiStatus.Experimental
    public boolean isNestedSameLine() {
        return this.nestedSameLine;
    }

    @ApiStatus.Experimental
    public JsonWriterOptions setNestedSameLine(boolean nestedSameLine) {
        this.nestedSameLine = nestedSameLine;
        return this;
    }

    public boolean isOmitRootBraces() {
        return this.omitRootBraces;
    }

    public JsonWriterOptions setOmitRootBraces(boolean omitRootBraces) {
        this.omitRootBraces = omitRootBraces;
        return this;
    }

    public boolean isOutputComments() {
        return this.outputComments;
    }

    public JsonWriterOptions setOutputComments(boolean outputComments) {
        this.outputComments = outputComments;
        return this;
    }

    public boolean isOmitQuotes() {
        return this.omitQuotes;
    }

    public JsonWriterOptions setOmitQuotes(boolean omitQuotes) {
        this.omitQuotes = omitQuotes;
        return this;
    }

    public String getEol() {
        if (this.eol == null) {
            return JsonContext.getEol();
        }
        return this.eol;
    }

    public JsonWriterOptions setEol(String eol) {
        this.eol = eol;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public JsonWriterOptions setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public JsonWriterOptions setTabSize(int num) {
        char[] spaces = new char[num];
        Arrays.fill(spaces, ' ');
        this.indent = new String(spaces);
        return this;
    }

    public String getSeparator() {
        return this.separator;
    }

    public JsonWriterOptions setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public int getMinSpacing() {
        return this.minSpacing;
    }

    public JsonWriterOptions setMinSpacing(int minSpacing) {
        this.minSpacing = minSpacing;
        return this;
    }

    public int getMaxSpacing() {
        return this.maxSpacing;
    }

    public JsonWriterOptions setMaxSpacing(int maxSpacing) {
        this.maxSpacing = maxSpacing;
        return this;
    }

    public int getDefaultSpacing() {
        return this.defaultSpacing;
    }

    public JsonWriterOptions setDefaultSpacing(int defaultSpacing) {
        this.defaultSpacing = defaultSpacing;
        return this;
    }

    public boolean isSmartSpacing() {
        return this.smartSpacing;
    }

    public JsonWriterOptions setSmartSpacing(boolean smartSpacing) {
        this.smartSpacing = smartSpacing;
        return this;
    }

    public boolean isNextLineMulti() {
        return this.nextLineMulti;
    }

    public JsonWriterOptions setNextLineMulti(boolean nextLineMulti) {
        this.nextLineMulti = nextLineMulti;
        return this;
    }
}

