/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.writer;

import java.io.IOException;
import java.io.Writer;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.CommentedElementWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import org.jetbrains.annotations.Nullable;

public class DjsWriter
extends CommentedElementWriter {
    public DjsWriter(Writer writer, @Nullable JsonWriterOptions options) {
        super(writer, options);
    }

    @Override
    protected void write() throws IOException {
        JsonValue value = this.current();
        if (this.omitRootBraces && value.isObject() && !value.asObject().isEmpty()) {
            this.writeOpenRoot();
        } else {
            this.writeClosedRoot();
        }
    }

    protected void writeOpenRoot() throws IOException {
        this.level = -1;
        this.writeAbove();
        this.open('\u0000');
        while (this.current != null) {
            this.writeNextMember();
            this.next();
        }
        this.close('\u0000');
        this.writeFooter();
    }

    protected void writeClosedRoot() throws IOException {
        this.writeAbove();
        this.writeValue();
        this.writeAfter();
        this.writeFooter();
    }

    protected void writeValue() throws IOException {
        JsonValue value = this.current();
        switch (value.getType()) {
            case OBJECT: {
                this.writeObject();
                break;
            }
            case ARRAY: {
                this.writeArray();
                break;
            }
            case NUMBER: {
                this.writeNumber(value.asDouble());
                break;
            }
            case STRING: {
                this.writeString(value);
                break;
            }
            default: {
                this.tw.write(value.toString());
            }
        }
    }

    protected void writeObject() throws IOException {
        this.open('{');
        while (this.current != null) {
            this.writeNextMember();
            this.next();
        }
        this.close('}');
    }

    protected void writeNextMember() throws IOException {
        this.writeAbove();
        this.writeKey();
        this.tw.write(58);
        this.writeBetween();
        this.writeValue();
        this.delimit();
        this.writeAfter();
    }

    protected void writeArray() throws IOException {
        this.open('[');
        while (this.current != null) {
            this.writeNextElement();
            this.next();
        }
        this.close(']');
    }

    protected void writeNextElement() throws IOException {
        this.writeAbove();
        this.writeValue();
        this.delimit();
        this.writeAfter();
    }

    @Override
    protected void delimit() throws IOException {
        if (this.peek != null) {
            if (!this.format) {
                this.tw.write(44);
            } else if (this.allowCondense && this.getLinesAbove(this.peek()) == 0) {
                this.tw.write(44);
                this.tw.write(this.separator);
            }
        }
    }

    protected void writeKey() throws IOException {
        String key = this.key();
        this.writeString(key, this.getKeyType(key));
    }

    protected void writeString(JsonValue value) throws IOException {
        this.writeString(value.asString(), this.getStringType(value));
    }

    protected void writeString(String value, StringType type) throws IOException {
        switch (type) {
            case SINGLE: {
                this.writeQuoted(value, '\'');
                break;
            }
            case DOUBLE: {
                this.writeQuoted(value, '\"');
                break;
            }
            case MULTI: {
                this.writeMulti(value);
                break;
            }
            case IMPLICIT: {
                this.tw.write(value);
                break;
            }
            default: {
                throw new IllegalStateException("unreachable");
            }
        }
    }

    protected StringType getKeyType(String key) {
        return StringType.selectKey(key);
    }

    protected StringType getStringType(JsonValue value) {
        StringType type = StringType.fromValue(value);
        return this.isLegalStringType(type) ? type : StringType.selectValue(value.asString());
    }

    protected boolean isLegalStringType(StringType type) {
        return type == StringType.DOUBLE || type == StringType.SINGLE || type == StringType.MULTI;
    }
}

