/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ValueParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

@FunctionalInterface
public interface ParsingFunction {
    public JsonValue parse(PositionTrackingReader var1) throws IOException;

    default public JsonValue parse(String s) {
        try {
            return this.parse(PositionTrackingReader.fromString(s));
        }
        catch (IOException e) {
            throw new IllegalStateException("Parser threw unexpected error", e);
        }
    }

    default public JsonValue parse(Reader reader) throws IOException {
        return this.parse(PositionTrackingReader.fromReader(reader));
    }

    default public JsonValue parse(InputStream is) throws IOException {
        try (PositionTrackingReader reader = PositionTrackingReader.fromIs(is);){
            JsonValue jsonValue = this.parse(reader);
            return jsonValue;
        }
    }

    default public JsonValue parse(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonValue jsonValue = this.parse(reader);
            return jsonValue;
        }
    }

    public static ParsingFunction fromParser(ValueParser.ReaderConstructor c) {
        return reader -> c.construct(reader).parse();
    }
}

