/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.parser;

import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.comments.Comment;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentData;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.TokenParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.CommentToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;

public abstract class CommentedTokenParser
extends TokenParser {
    protected CommentData commentBuffer = new CommentData();

    protected CommentedTokenParser(TokenStream root) {
        super(root);
    }

    @Override
    protected boolean consumeWhitespace(Token t, boolean nl) {
        if (!t.isMetadata()) {
            return false;
        }
        if (t.type() == TokenType.BREAK) {
            if (!nl) {
                return false;
            }
            this.flagLineAsSkipped();
        } else {
            this.appendComment((CommentToken)t);
        }
        return true;
    }

    @Override
    protected void flagLineAsSkipped() {
        if (!this.commentBuffer.isEmpty()) {
            this.commentBuffer.append(1);
        } else {
            ++this.linesSkipped;
        }
    }

    @Override
    protected void setAbove() {
        this.setComment(CommentType.HEADER);
        super.setAbove();
    }

    @Override
    protected void setBetween() {
        this.setComment(CommentType.VALUE);
        super.setBetween();
    }

    @Override
    protected void setTrailing() {
        this.setComment(CommentType.INTERIOR);
        super.setTrailing();
    }

    protected void readAboveOpenRoot(JsonObject root) {
        this.readWhitespace(false);
        this.splitOpenHeader(root);
    }

    @Override
    protected void readAfter() {
        this.readLineWhitespace();
        this.setComment(CommentType.EOL);
    }

    @Override
    protected void readBottom() {
        this.readWhitespace(false);
        this.prependLinesSkippedToComment();
        this.setComment(CommentType.FOOTER);
        this.expectEndOfText();
    }

    protected void appendComment(CommentToken t) {
        this.commentBuffer.append(new Comment(t));
    }

    protected void prependLinesSkippedToComment() {
        if (this.linesSkipped > 1) {
            this.commentBuffer.prepend(this.linesSkipped);
            this.linesSkipped = 0;
        }
    }

    protected void setComment(CommentType type) {
        CommentData data = this.takeComment(type);
        if (!data.isEmpty()) {
            this.formatting.getComments().setData(type, data);
        }
    }

    protected CommentData takeComment(CommentType type) {
        if (this.commentBuffer.isEmpty()) {
            return new CommentData();
        }
        if (this.commentBuffer.endsWithNewline()) {
            if (this.shouldTakeNl(type)) {
                this.trimComment();
                ++this.linesSkipped;
            } else if (this.shouldTrimNl(type)) {
                this.trimComment();
            }
        }
        CommentData taken = this.commentBuffer;
        this.commentBuffer = new CommentData();
        return taken;
    }

    protected final boolean shouldTrimNl(CommentType type) {
        return type == CommentType.HEADER;
    }

    protected final boolean shouldTakeNl(CommentType type) {
        return type == CommentType.EOL;
    }

    protected final void trimComment() {
        this.commentBuffer.trimLastNewline();
    }

    protected void splitOpenHeader(JsonObject root) {
        CommentData header = this.commentBuffer.takeOpenHeader();
        if (header != null) {
            root.getComments().setData(CommentType.HEADER, header);
            root.setLinesAbove(this.linesSkipped);
            this.linesSkipped = header.takeLastLinesSkipped() - 1;
        }
    }
}

