/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.comments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.frozenblock.lib.shadow.xjs.data.comments.Comment;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import org.jetbrains.annotations.Nullable;

public class CommentData {
    private final List<Object> comments;
    private int lines;

    public CommentData() {
        this(new ArrayList<Object>(), 0);
    }

    private CommentData(List<Object> comments, int lines) {
        this.comments = comments;
        this.lines = lines;
    }

    public static CommentData immutable() {
        return new CommentData(Collections.emptyList(), 0);
    }

    public void append(Comment comment) {
        this.comments.add(comment);
        this.appendLines(comment);
    }

    public void append(int lines) {
        if (this.comments.isEmpty()) {
            this.comments.add(lines);
        } else {
            int end = this.comments.size() - 1;
            Object last = this.comments.get(end);
            if (last instanceof Integer) {
                this.comments.set(end, (Integer)last + lines);
            } else {
                this.comments.add(lines);
            }
        }
        this.lines += lines;
    }

    public void append(CommentData data) {
        this.comments.addAll(data.comments);
        this.lines += data.lines;
    }

    public void prepend(Comment comment) {
        this.comments.add(0, comment);
    }

    public void prepend(int lines) {
        if (this.comments.isEmpty()) {
            this.comments.add(lines);
        } else {
            Object first = this.comments.get(0);
            if (first instanceof Integer) {
                this.comments.set(0, (Integer)first + lines);
            } else {
                this.comments.add(0, lines);
            }
        }
        this.lines += lines;
    }

    private void appendLines(Comment comment) {
        String text = comment.text();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++this.lines;
        }
    }

    public void setLinesAfter(int lines) {
        if (this.comments.isEmpty()) {
            this.comments.add(lines);
            return;
        }
        int last = this.comments.size() - 1;
        if (this.comments.get(last) instanceof Integer) {
            this.comments.set(last, lines);
            return;
        }
        this.comments.add(lines);
    }

    public boolean isEmpty() {
        return this.comments.isEmpty();
    }

    public int getLines() {
        return this.lines;
    }

    public boolean endsWithNewline() {
        return !this.comments.isEmpty() && this.comments.get(this.comments.size() - 1) instanceof Integer;
    }

    public void trimLastNewline() {
        int end;
        Object last;
        if (!this.comments.isEmpty() && (last = this.comments.get(end = this.comments.size() - 1)) instanceof Integer) {
            this.comments.set(end, (Integer)last - 1);
        }
    }

    @Nullable
    public CommentData takeOpenHeader() {
        if (this.isEmpty()) {
            return null;
        }
        int end = this.getLastGap();
        if (end < 2) {
            return null;
        }
        return this.takeBefore(end + 1);
    }

    private int getLastGap() {
        for (int i = this.comments.size() - 2; i >= 0; --i) {
            Object o = this.comments.get(i);
            if (!(o instanceof Integer) || (Integer)o <= 1) continue;
            return i;
        }
        return -1;
    }

    private CommentData takeBefore(int index) {
        CommentData taken = new CommentData();
        for (int i = 0; i < index; ++i) {
            Object removed = this.comments.remove(0);
            if (removed instanceof Comment) {
                taken.append((Comment)removed);
                continue;
            }
            taken.append((Integer)removed);
        }
        return taken;
    }

    public int takeLastLinesSkipped() {
        return (Integer)this.comments.remove(this.comments.size() - 1);
    }

    public void writeTo(Appendable out) throws IOException {
        this.writeTo(out, null, "", 0, JsonContext.getEol(), false);
    }

    public void writeTo(Appendable out, CommentStyle style) throws IOException {
        this.writeTo(out, style, "", 0, JsonContext.getEol(), false);
    }

    public void writeTo(Appendable out, String indent, int level, String eol) throws IOException {
        this.writeTo(out, null, indent, level, eol, false);
    }

    public void writeTo(Appendable out, @Nullable CommentStyle style, String indent, int level, String eol, boolean dedentLast) throws IOException {
        for (int i = 0; i < this.comments.size(); ++i) {
            Object o = this.comments.get(i);
            if (o instanceof Comment) {
                Comment comment = (Comment)o;
                CommentStyle styleOut = style != null ? style : comment.style();
                this.append(out, comment.text(), styleOut, indent, level, eol);
                continue;
            }
            if ((Integer)o <= 0) continue;
            for (int j = 0; j < (Integer)o - 1; ++j) {
                out.append(eol);
            }
            if (dedentLast && i == this.comments.size() - 1) {
                --level;
            }
            this.nl(out, indent, level, eol);
        }
    }

    public String toString() {
        if (this.comments.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : this.comments) {
            if (o instanceof Comment) {
                sb.append(((Comment)o).text());
                continue;
            }
            sb.append("\n".repeat(Math.max(0, (Integer)o)));
        }
        return sb.toString();
    }

    public CommentData copy() {
        return new CommentData(new ArrayList<Object>(this.comments), this.lines);
    }

    public int hashCode() {
        return this.lines + 31 * this.comments.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CommentData) {
            CommentData d = (CommentData)o;
            return this.lines == d.lines && this.comments.equals(d.comments);
        }
        return false;
    }

    private void append(Appendable out, String text, CommentStyle style, String separator, int level, String eol) throws IOException {
        if (style.isMultiline()) {
            this.appendMultiline(out, text, style, separator, level, eol);
            return;
        }
        int s = 0;
        for (int i = 0; i < text.length() + 1; ++i) {
            if (i != text.length() && text.charAt(i) != '\n') continue;
            int e = i > 0 && text.charAt(i - 1) == '\r' ? i - 1 : i;
            out.append(style.getPrefix());
            out.append(' ');
            out.append(text, s, e);
            if (i != text.length()) {
                this.nl(out, separator, level, eol);
            }
            s = i + 1;
        }
    }

    private void appendMultiline(Appendable out, String text, CommentStyle style, String separator, int level, String eol) throws IOException {
        if (!text.contains("\n")) {
            out.append(style.getPrefix());
            out.append(' ');
            out.append(text);
            out.append(" */");
            return;
        }
        out.append(style.getPrefix());
        this.nl(out, separator, level, eol);
        int s = 0;
        for (int i = 0; i < text.length() + 1; ++i) {
            int e;
            if (i != text.length() && text.charAt(i) != '\n') continue;
            int n = e = i > 0 && text.charAt(i - 1) == '\r' ? i - 1 : i;
            if (s != 0) {
                this.nl(out, separator, level, eol);
            }
            out.append(" * ");
            out.append(text, s, e);
            s = i + 1;
        }
        this.nl(out, separator, level, eol);
        out.append(" */");
    }

    private void nl(Appendable out, String separator, int level, String eol) throws IOException {
        out.append(eol);
        for (int i = 0; i < level; ++i) {
            out.append(separator);
        }
    }
}

