/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.PathFilter;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonContainer
extends JsonValue {
    protected final List<JsonReference> references;
    protected View<JsonValue> accessor;
    protected View<JsonValue> visitor;
    protected int linesTrailing;

    protected JsonContainer() {
        this(new ArrayList<JsonReference>());
    }

    protected JsonContainer(List<JsonReference> references) {
        this.references = references;
        this.linesTrailing = -1;
    }

    public int getLinesTrailing() {
        return this.linesTrailing;
    }

    public JsonContainer setLinesTrailing(int linesTrailing) {
        this.linesTrailing = linesTrailing;
        return this;
    }

    public JsonContainer setLineLength(int lineLength) {
        for (int i = 0; i < this.references.size(); ++i) {
            int linesAbove = i % lineLength == 0 ? 1 : 0;
            this.references.get(i).getOnly().setLinesAbove(linesAbove).setLinesBetween(0);
        }
        return this;
    }

    public JsonContainer condense() {
        this.references.forEach(ref -> ref.getOnly().setLinesAbove(0).setLinesBetween(0));
        return this;
    }

    @Override
    public JsonContainer setDefaultMetadata(JsonValue other) {
        if (other instanceof JsonContainer) {
            JsonContainer c = (JsonContainer)other;
            if (this.linesTrailing < 0) {
                this.linesTrailing = c.linesTrailing;
            }
        }
        return (JsonContainer)super.setDefaultMetadata(other);
    }

    public Collection<JsonReference> references() {
        return Collections.unmodifiableCollection(this.references);
    }

    public boolean has(int index) {
        return index >= 0 && index < this.references.size();
    }

    public JsonValue get(int index) {
        return this.references.get(index).get();
    }

    public <T> Optional<T> getOptional(int index, Function<JsonValue, T> filter) {
        return this.getOptional(index).flatMap(value -> Optional.ofNullable(JsonContainer.mapSuppressing(value, filter)));
    }

    public Optional<JsonValue> getOptional(int index) {
        return this.has(index) ? Optional.of(this.references.get(index).get()) : Optional.empty();
    }

    public JsonReference getReference(int index) {
        return this.references.get(index);
    }

    public int size() {
        return this.references.size();
    }

    public boolean isEmpty() {
        return this.references.isEmpty();
    }

    public boolean contains(long value) {
        return this.contains(Json.value(value));
    }

    public boolean contains(double value) {
        return this.contains(Json.value(value));
    }

    public boolean contains(boolean value) {
        return this.contains(Json.value(value));
    }

    public boolean contains(@Nullable String value) {
        return this.contains(Json.value(value));
    }

    public boolean contains(JsonValue value) {
        return this.indexOf(value) >= 0;
    }

    public boolean containsAll(Iterable<JsonValue> values) {
        return StreamSupport.stream(values.spliterator(), false).anyMatch(this::contains);
    }

    public View<JsonValue> values() {
        if (this.accessor == null) {
            this.accessor = new AccessingView();
            return this.accessor;
        }
        return this.accessor;
    }

    public View<JsonValue> visitAll() {
        if (this.visitor == null) {
            this.visitor = new VisitingView();
            return this.visitor;
        }
        return this.visitor;
    }

    public JsonContainer forEachRecursive(Consumer<JsonReference> fn) {
        this.references.forEach(ref -> {
            fn.accept((JsonReference)ref);
            if (ref.getOnly().isContainer()) {
                ref.getOnly().asContainer().forEachRecursive(fn);
            }
        });
        return this;
    }

    public JsonContainer clear() {
        this.references.clear();
        return this;
    }

    public JsonContainer remove(JsonValue value) {
        int index = this.indexOf(value);
        if (index >= 0) {
            this.references.remove(index);
        }
        return this;
    }

    public JsonContainer removeAll(Iterable<JsonValue> values) {
        values.forEach(this::remove);
        return this;
    }

    public JsonContainer setAllAccessed(boolean accessed) {
        return this.forEachRecursive(ref -> ref.setAccessed(accessed));
    }

    public int indexOf(JsonValue value) {
        for (int i = 0; i < this.references.size(); ++i) {
            if (!this.references.get(i).getOnly().matches(value)) continue;
            return i;
        }
        return -1;
    }

    public <T> List<T> toList(Function<JsonValue, T> mapper) {
        return this.values().stream().map(mapper).collect(Collectors.toList());
    }

    @Override
    public final boolean isPrimitive() {
        return false;
    }

    @Override
    public final boolean isContainer() {
        return true;
    }

    @Override
    public JsonContainer asContainer() {
        return this;
    }

    @Override
    public double intoDouble() {
        return this.values().stream().mapToDouble(JsonValue::intoDouble).sum();
    }

    @Override
    public boolean intoBoolean() {
        return !this.isEmpty() && this.values().stream().allMatch(JsonValue::intoBoolean);
    }

    @Override
    public JsonContainer intoContainer() {
        return this;
    }

    protected List<JsonReference> copyReferences(int options) {
        return JsonContainer.copyReferences(this.references, options);
    }

    protected static List<JsonReference> copyReferences(List<JsonReference> references, int options) {
        boolean containers;
        boolean tracking = (options & 1) == 1;
        boolean recursive = (options & 4) == 4;
        boolean bl = containers = (options & 2) == 2;
        if (recursive || containers) {
            ArrayList<JsonReference> copy = new ArrayList<JsonReference>(references.size());
            for (JsonReference reference : references) {
                if (recursive || reference.getOnly().isContainer()) {
                    copy.add(reference.copy(tracking).applyOnly(v -> v.copy(options)));
                    continue;
                }
                copy.add(reference);
            }
            return copy;
        }
        return references;
    }

    @Override
    public abstract boolean matches(JsonValue var1);

    public JsonContainer freeze() {
        return this.freeze(false);
    }

    public abstract JsonContainer freeze(boolean var1);

    public List<String> getPaths() {
        return this.getPaths(PathFilter.ALL);
    }

    public abstract List<String> getPaths(PathFilter var1);

    protected List<JsonReference> freezeReferences(boolean recursive) {
        return this.references.stream().map(ref -> {
            JsonReference clone = ref.copy(true);
            if (recursive && ref.getOnly().isContainer()) {
                ref.applyOnly(value -> value.asContainer().freeze(true));
            }
            return clone.freeze();
        }).toList();
    }

    @Nullable
    protected static <T> T mapSuppressing(JsonValue value, Function<JsonValue, T> filter) {
        try {
            return filter.apply(value);
        }
        catch (UnsupportedOperationException | SyntaxException runtimeException) {
            return null;
        }
    }

    public static interface View<T>
    extends Iterable<T> {
        default public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }

    private class AccessingView
    implements View<JsonValue> {
        private AccessingView() {
        }

        @Override
        @NotNull
        public Iterator<JsonValue> iterator() {
            return new AccessingValueIterator();
        }
    }

    private class VisitingView
    implements View<JsonValue> {
        private VisitingView() {
        }

        @Override
        @NotNull
        public Iterator<JsonValue> iterator() {
            return new VisitingValueIterator();
        }
    }

    private class VisitingValueIterator
    implements Iterator<JsonValue> {
        final Iterator<JsonReference> references;

        private VisitingValueIterator() {
            this.references = JsonContainer.this.references.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.references.hasNext();
        }

        @Override
        public JsonValue next() {
            return this.references.next().getOnly();
        }

        @Override
        public void remove() {
            this.references.remove();
        }
    }

    private class AccessingValueIterator
    implements Iterator<JsonValue> {
        final Iterator<JsonReference> references;

        private AccessingValueIterator() {
            this.references = JsonContainer.this.references.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.references.hasNext();
        }

        @Override
        public JsonValue next() {
            return this.references.next().get();
        }

        @Override
        public void remove() {
            this.references.remove();
        }
    }
}

