/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.ValueWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.WritingFunction;

@FunctionalInterface
public interface BinaryWritingFunction
extends WritingFunction {
    @Override
    public void write(OutputStream var1, JsonValue var2, JsonWriterOptions var3) throws IOException;

    @Override
    default public void write(Writer tw, JsonValue value, JsonWriterOptions options) {
        throw new UnsupportedOperationException("Cannot write binary type to writer");
    }

    @Override
    default public void write(Path file, JsonValue value, JsonWriterOptions options) throws IOException {
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            this.write(os, value, options);
        }
    }

    @Override
    default public String stringify(JsonValue value, JsonWriterOptions options) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.write(os, value, options);
        }
        catch (IOException e) {
            throw new IllegalStateException("Writer threw unexpected error", e);
        }
        return os.toString();
    }

    public static BinaryWritingFunction fromWriter(Function<OutputStream, ValueWriter> c) {
        return (os, value, options) -> ((ValueWriter)c.apply(os)).write(value);
    }
}

