/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.parser;

import net.frozenblock.lib.shadow.xjs.compat.serialization.token.HjsonTokenizer;
import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.DjsParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.StringToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

public class HjsonParser
extends DjsParser {
    public HjsonParser(PositionTrackingReader reader) {
        this(new HjsonTokenizer(reader, false).stream());
    }

    protected HjsonParser(TokenStream root) {
        super(root);
    }

    @Override
    protected String readKey() {
        Token token = this.current;
        if (token instanceof StringToken) {
            StringToken t = (StringToken)token;
            switch (t.stringType()) {
                case SINGLE: 
                case DOUBLE: 
                case IMPLICIT: {
                    this.read();
                    return t.parsed();
                }
            }
            throw this.illegalKeyType(t.stringType());
        }
        return super.readKey();
    }

    protected SyntaxException illegalKeyType(StringType t) {
        return this.unexpected("string type in key: " + t + " (must be single, double, unquoted)");
    }
}

