/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ParsingFunction;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ValueParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

@FunctionalInterface
public interface BinaryParsingFunction
extends ParsingFunction {
    @Override
    public JsonValue parse(InputStream var1) throws IOException;

    @Override
    default public JsonValue parse(PositionTrackingReader reader) {
        throw new UnsupportedOperationException("Cannot parse binary type from reader");
    }

    @Override
    default public JsonValue parse(Reader reader) {
        throw new UnsupportedOperationException("Cannot parse binary type from reader");
    }

    @Override
    default public JsonValue parse(String s) {
        try {
            return this.parse(new ByteArrayInputStream(s.getBytes()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    default public JsonValue parse(Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            JsonValue jsonValue = this.parse(is);
            return jsonValue;
        }
    }

    public static BinaryParsingFunction fromParser(Function<InputStream, ValueParser> c) {
        return is -> ((ValueParser)c.apply(is)).parse();
    }
}

