/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.resource_pack.api.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.resource_pack.impl.client.PackDownloadToast;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@Environment(value=EnvType.CLIENT)
public class FrozenLibModResourcePackApi {
    @ApiStatus.Internal
    public static final Path RESOURCE_PACK_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("resourcepacks");
    @ApiStatus.Internal
    public static final Path MOD_RESOURCE_PACK_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_resourcepacks");
    @ApiStatus.Internal
    public static final Path MOD_RESOURCE_PACK_PENDING_EXTRACTION_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_resourcepacks_pending_extraction");
    @ApiStatus.Internal
    public static final Path DOWNLOADED_RESOURCE_PACK_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("downloaded_resourcepacks");
    private static final Path HASH_FILE = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_resource_pack_hashes.txt");
    private static final Path DOWNLOADED_PACK_LOG_FILE = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_downloaded_resource_packs.txt");
    private static final List<String> HIDDEN_PACK_IDS = new ArrayList<String>();
    private static final List<String> MOD_RESOURCE_PACK_IDS = new ArrayList<String>();
    private static final List<ToastInfo> QUEUED_TOASTS = new ArrayList<ToastInfo>();
    private static final boolean SHOW_DEBUG_TOASTS = FrozenLibConstants.UNSTABLE_LOGGING;

    public static void findAndPrepareResourcePack(ModContainer mod, String packName, boolean isDoubleZip, boolean hidePackFromMenu, boolean skipHashCheck) throws IOException {
        Optional resourcePack;
        String zipPackName = packName + ".zip";
        String packId = "frozenlib:mod/file/" + zipPackName;
        String subPath = "frozenlib_resourcepacks/" + zipPackName;
        MOD_RESOURCE_PACK_IDS.add(packId);
        if (hidePackFromMenu) {
            FrozenLibModResourcePackApi.registerHiddenPackId(packId);
        }
        if ((resourcePack = mod.findPath(subPath)).isEmpty()) {
            FrozenLibLogUtils.logWarning("Could not find internal Resource Pack of name " + zipPackName + "!");
            return;
        }
        Path jarPackPath = (Path)resourcePack.get();
        String currentHash = FrozenLibModResourcePackApi.calculateSHA256(jarPackPath);
        boolean hasHashChanged = skipHashCheck || FrozenLibModResourcePackApi.hasHashChanged(packName, currentHash);
        File destFile = new File(MOD_RESOURCE_PACK_DIRECTORY.toString(), zipPackName);
        if (hasHashChanged || !destFile.exists()) {
            if (destFile.exists()) {
                if (!hasHashChanged) {
                    return;
                }
                destFile.delete();
            }
            InputStream inputFromJar = Files.newInputStream(jarPackPath, new OpenOption[0]);
            if (isDoubleZip) {
                File extractionFile = new File(MOD_RESOURCE_PACK_PENDING_EXTRACTION_DIRECTORY.toString(), zipPackName);
                FileUtils.copyInputStreamToFile((InputStream)inputFromJar, (File)extractionFile);
                inputFromJar.close();
                AtomicBoolean extracted = new AtomicBoolean(false);
                ZipFile zipFile = new ZipFile(extractionFile);
                zipFile.entries().asIterator().forEachRemaining(entry -> {
                    if (entry.getName().equals(zipPackName) && !extracted.get()) {
                        try {
                            InputStream zipInputStream = zipFile.getInputStream((ZipEntry)entry);
                            FileUtils.copyInputStreamToFile((InputStream)zipInputStream, (File)destFile);
                            zipInputStream.close();
                            extracted.set(true);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                extractionFile.delete();
                if (!extracted.get()) {
                    FrozenLibLogUtils.logWarning("Could not find internal Resource Pack of name " + zipPackName + "!");
                }
            } else {
                FileUtils.copyInputStreamToFile((InputStream)inputFromJar, (File)destFile);
                inputFromJar.close();
            }
        }
        FrozenLibModResourcePackApi.updateHashRecord(packName, currentHash);
    }

    public static void downloadResourcePacks(PackDownloadGroup downloadGroup, boolean hidePacksFromMenu, boolean skipVersionCheck) {
        downloadGroup.resetPackStatuses();
        downloadGroup.packs().forEach(downloadInfo -> FrozenLibModResourcePackApi.downloadResourcePack(downloadInfo, hidePacksFromMenu, skipVersionCheck));
    }

    public static void downloadResourcePack(PackDownloadInfo downloadInfo, boolean hidePackFromMenu, boolean skipVersionCheck) {
        String packName = downloadInfo.getPackName();
        String zipPackName = packName + ".zip";
        String packId = "frozenlib:mod/downloaded/file/" + zipPackName;
        MOD_RESOURCE_PACK_IDS.add(packId);
        if (hidePackFromMenu) {
            FrozenLibModResourcePackApi.registerHiddenPackId(packId);
        }
        if (FrozenLibConfig.get().packDownloading == PackDownloadSetting.DISABLED) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            Optional failToast = Optional.empty();
            try {
                boolean hasDownloadVersionChanged;
                File destFile = new File(DOWNLOADED_RESOURCE_PACK_DIRECTORY.toString(), zipPackName);
                boolean isPackPresent = destFile.exists();
                failToast = isPackPresent ? (SHOW_DEBUG_TOASTS ? Optional.of(new ToastInfo(downloadInfo, ToastType.FAILURE_PRESENT)) : Optional.empty()) : Optional.of(new ToastInfo(downloadInfo, ToastType.FAILURE));
                URL url = URI.create(downloadInfo.getURL()).toURL();
                URLConnection request = url.openConnection();
                request.connect();
                JsonElement parsedJson = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)request.getContent()));
                JsonObject packDir = parsedJson.getAsJsonObject();
                String packURL = packDir.get("pack").getAsString();
                int packVersion = packDir.get("version").getAsInt();
                boolean bl = hasDownloadVersionChanged = skipVersionCheck || FrozenLibModResourcePackApi.hasDownloadVersionChanged(packName, packVersion);
                if (!hasDownloadVersionChanged && isPackPresent) {
                    return SHOW_DEBUG_TOASTS ? Optional.of(new ToastInfo(downloadInfo, ToastType.PRESENT)) : Optional.empty();
                }
                Optional<File> downloadedPack = FrozenLibModResourcePackApi.downloadPackFromURL(packURL, packName, destFile, packVersion);
                return downloadedPack.isPresent() ? Optional.of(new ToastInfo(downloadInfo, isPackPresent ? ToastType.SUCCESS_UPDATE : ToastType.SUCCESS_DOWNLOAD)) : failToast;
            }
            catch (IOException ignored) {
                return failToast;
            }
        }, Executors.newCachedThreadPool()).whenComplete((value, throwable) -> value.ifPresent(failToast -> ((ToastInfo)failToast).addToast()));
    }

    private static Optional<File> downloadPackFromURL(String urlString, String packName, File destFile, int newVersion) {
        try {
            if (destFile.exists()) {
                destFile.delete();
            }
            URL url = URI.create(urlString).toURL();
            URLConnection request = url.openConnection();
            request.connect();
            InputStream input = (InputStream)request.getContent();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
            input.close();
            FrozenLibModResourcePackApi.updateDownloadRecord(packName, newVersion);
            return Optional.of(destFile);
        }
        catch (IOException ignored) {
            FrozenLibConstants.LOGGER.error("Failed to download pack from URL: {}", (Object)urlString);
            return Optional.empty();
        }
    }

    public static void registerHiddenPackId(String packId) {
        HIDDEN_PACK_IDS.add(packId);
    }

    public static boolean isPackHiddenFromMenu(String packId) {
        return HIDDEN_PACK_IDS.stream().anyMatch(id -> id.equals(packId));
    }

    public static boolean isFrozenLibPackRegisteredByMod(String packId) {
        return MOD_RESOURCE_PACK_IDS.stream().anyMatch(id -> id.equals(packId));
    }

    private static String calculateSHA256(Path path) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = Files.readAllBytes(path);
            byte[] hashBytes = digest.digest(fileBytes);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    private static Map<String, String> readHashRecords() {
        HashMap<String, String> hashes = new HashMap<String, String>();
        if (!Files.exists(HASH_FILE, new LinkOption[0])) {
            return hashes;
        }
        try {
            Files.lines(HASH_FILE).forEach(line -> {
                String[] parts = line.split("=", 2);
                if (parts.length == 2) {
                    hashes.put(parts[0], parts[1]);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashes;
    }

    private static void writeHashRecords(Map<String, String> hashes) {
        try {
            Files.createDirectories(FrozenLibConstants.FROZENLIB_GAME_DIRECTORY, new FileAttribute[0]);
            StringBuilder content = new StringBuilder();
            for (Map.Entry<String, String> entry : hashes.entrySet()) {
                String packName = entry.getKey();
                if (!new File(MOD_RESOURCE_PACK_DIRECTORY.toString(), packName + ".zip").exists()) continue;
                content.append(packName).append("=").append(entry.getValue()).append("\n");
            }
            Files.write(HASH_FILE, content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean hasHashChanged(String packName, String currentHash) {
        Map<String, String> existingHashes = FrozenLibModResourcePackApi.readHashRecords();
        String existingHash = existingHashes.get(packName);
        return existingHash == null || !existingHash.equals(currentHash);
    }

    private static void updateHashRecord(String packName, String newHash) {
        Map<String, String> hashes = FrozenLibModResourcePackApi.readHashRecords();
        hashes.put(packName, newHash);
        FrozenLibModResourcePackApi.writeHashRecords(hashes);
    }

    private static Map<String, Integer> readDownloadRecords() {
        HashMap<String, Integer> hashes = new HashMap<String, Integer>();
        if (!Files.exists(DOWNLOADED_PACK_LOG_FILE, new LinkOption[0])) {
            return hashes;
        }
        try {
            Files.lines(DOWNLOADED_PACK_LOG_FILE).forEach(line -> {
                String[] parts = line.split("=", 2);
                if (parts.length == 2) {
                    hashes.put(parts[0], Integer.valueOf(parts[1]));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashes;
    }

    private static void writeDownloadRecords(Map<String, Integer> versions) {
        try {
            Files.createDirectories(FrozenLibConstants.FROZENLIB_GAME_DIRECTORY, new FileAttribute[0]);
            StringBuilder content = new StringBuilder();
            for (Map.Entry<String, Integer> entry : versions.entrySet()) {
                String packName = entry.getKey();
                if (!new File(DOWNLOADED_RESOURCE_PACK_DIRECTORY.toString(), packName + ".zip").exists()) continue;
                content.append(packName).append("=").append(entry.getValue()).append("\n");
            }
            Files.write(DOWNLOADED_PACK_LOG_FILE, content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean hasDownloadVersionChanged(String packName, int currentVersion) {
        Map<String, Integer> existingDownloads = FrozenLibModResourcePackApi.readDownloadRecords();
        Integer existingVersion = existingDownloads.get(packName);
        return existingVersion == null || !existingVersion.equals(currentVersion);
    }

    private static void updateDownloadRecord(String packName, int newVersion) {
        Map<String, Integer> downloads = FrozenLibModResourcePackApi.readDownloadRecords();
        downloads.put(packName, newVersion);
        FrozenLibModResourcePackApi.writeDownloadRecords(downloads);
    }

    @ApiStatus.Internal
    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> QUEUED_TOASTS.removeIf(ToastInfo::addToast));
    }

    public static class PackDownloadGroup
    implements PackDownloadStatusProvider {
        private final String groupName;
        private final List<PackDownloadInfo> packs = new ArrayList<PackDownloadInfo>();
        private final Map<PackDownloadToast.PackDownloadToastId, List<PackDownloadInfo>> packStatuses = new Object2ObjectLinkedOpenHashMap();

        private PackDownloadGroup(String packGroup) {
            this.groupName = packGroup;
        }

        @Contract(value="_ -> new")
        public static PackDownloadGroup create(String packGroup) {
            return new PackDownloadGroup(packGroup);
        }

        public PackDownloadGroup add(String url, String packName) {
            this.packs.add(PackDownloadInfo.of(url, packName, this));
            return this;
        }

        public void setPackStatus(PackDownloadToast.PackDownloadToastId id, PackDownloadInfo info) {
            for (List<PackDownloadInfo> list : this.packStatuses.values()) {
                list.removeIf(foundInfo -> foundInfo.equals(info));
            }
            this.packStatuses.computeIfAbsent(id, toastId -> new ArrayList()).add(info);
        }

        public void resetPackStatuses() {
            this.packStatuses.clear();
        }

        public int size() {
            return this.packs.size();
        }

        public int getPacksWithStatus(PackDownloadToast.PackDownloadToastId id) {
            return this.packStatuses.getOrDefault(id, List.of()).size();
        }

        public List<PackDownloadInfo> packs() {
            return this.packs;
        }

        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public PackDownloadStatusProvider getDirectProvider() {
            return this;
        }

        @Override
        public class_2561 getComponent(PackDownloadToast.PackDownloadToastId id) {
            return class_2561.method_43469((String)"frozenlib.resourcepack.download.group", (Object[])new Object[]{class_2561.method_43471((String)("frozenlib.resourcepack.group." + this.groupName)), this.getPacksWithStatus(id), this.size()});
        }
    }

    public static class PackDownloadInfo
    implements PackDownloadStatusProvider {
        private final String url;
        private final String packName;
        private final Optional<PackDownloadGroup> packGroup;

        private PackDownloadInfo(String url, String packName, Optional<PackDownloadGroup> packGroup) {
            this.url = url;
            this.packName = packName;
            this.packGroup = packGroup;
        }

        @Contract(value="_, _, _ -> new")
        public static PackDownloadInfo of(String url, String packName, PackDownloadGroup packGroup) {
            return new PackDownloadInfo(url, packName, Optional.ofNullable(packGroup));
        }

        @Contract(value="_, _ -> new")
        public static PackDownloadInfo of(String url, String packName) {
            return new PackDownloadInfo(url, packName, Optional.empty());
        }

        public void setGroupStatus(PackDownloadToast.PackDownloadToastId id) {
            if (this.packGroup.isEmpty()) {
                return;
            }
            this.packGroup.get().setPackStatus(id, this);
        }

        public String getURL() {
            return this.url;
        }

        public String getPackName() {
            return this.packName;
        }

        public Optional<PackDownloadGroup> getPackGroup() {
            return this.packGroup;
        }

        @Override
        public PackDownloadStatusProvider getDirectProvider() {
            if (this.packGroup.isEmpty()) {
                return this;
            }
            return this.packGroup.get();
        }

        @Override
        public class_2561 getComponent(PackDownloadToast.PackDownloadToastId id) {
            return class_2561.method_43471((String)("frozenlib.resourcepack.pack." + this.packName));
        }
    }

    @ApiStatus.Internal
    public static enum PackDownloadSetting implements class_3542
    {
        ENABLED("pack_downloading.enabled"),
        ENABLED_NO_TOASTS("pack_downloading.enabled_no_toasts"),
        DISABLED("pack_downloading.disabled");

        private final String name;

        private PackDownloadSetting(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    @ApiStatus.Internal
    private record ToastInfo(PackDownloadInfo downloadInfo, ToastType toastType) {
        public boolean addToast() {
            if (FrozenLibConfig.get().packDownloading != PackDownloadSetting.ENABLED) {
                return false;
            }
            class_310 minecraft = class_310.method_1551();
            if (minecraft == null || minecraft.method_1566() == null || minecraft.method_1478() == null) {
                if (!QUEUED_TOASTS.contains(this)) {
                    QUEUED_TOASTS.add(this);
                }
                return false;
            }
            this.toastType.displayToast(this.downloadInfo);
            return true;
        }
    }

    @ApiStatus.Internal
    private static enum ToastType {
        SUCCESS_DOWNLOAD(downloadInfo -> ToastType.displayOrUpdateToast(PackDownloadToast.PackDownloadToastId.PACK_DOWNLOAD_SUCCESS, downloadInfo)),
        SUCCESS_UPDATE(downloadInfo -> ToastType.displayOrUpdateToast(PackDownloadToast.PackDownloadToastId.PACK_UPDATE_SUCCESS, downloadInfo)),
        FAILURE(downloadInfo -> ToastType.displayOrUpdateToast(PackDownloadToast.PackDownloadToastId.PACK_DOWNLOAD_FAILURE, downloadInfo)),
        FAILURE_PRESENT(downloadInfo -> ToastType.displayOrUpdateToast(PackDownloadToast.PackDownloadToastId.PACK_DOWNLOAD_FAILURE_PRESENT, downloadInfo)),
        PRESENT(downloadInfo -> ToastType.displayOrUpdateToast(PackDownloadToast.PackDownloadToastId.PACK_DOWNLOAD_PRESENT, downloadInfo));

        private final Consumer<PackDownloadInfo> toastMaker;

        private ToastType(Consumer<PackDownloadInfo> toastMaker) {
            this.toastMaker = toastMaker;
        }

        public void displayToast(PackDownloadInfo downloadInfo) {
            this.toastMaker.accept(downloadInfo);
        }

        private static void displayOrUpdateToast(PackDownloadToast.PackDownloadToastId id, PackDownloadInfo downloadInfo) {
            downloadInfo.setGroupStatus(id);
            PackDownloadToast.addOrAppendIfNotPresent(class_310.method_1551().method_1566(), id, downloadInfo);
        }
    }

    public static interface PackDownloadStatusProvider {
        public PackDownloadStatusProvider getDirectProvider();

        public class_2561 getComponent(PackDownloadToast.PackDownloadToastId var1);
    }
}

