/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.particle.options;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.frozenblock.lib.networking.FrozenByteBufCodecs;
import net.frozenblock.lib.particle.FrozenLibParticleTypes;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Contract;

public record WindParticleOptions(int lifespan, class_243 velocity, ParticleLength length) implements class_2394
{
    public static final MapCodec<WindParticleOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("lifespan").forGetter(WindParticleOptions::lifespan), (App)class_243.field_38277.fieldOf("velocity").forGetter(WindParticleOptions::velocity), (App)ParticleLength.CODEC.fieldOf("length").forGetter(WindParticleOptions::length)).apply((Applicative)instance, WindParticleOptions::new));
    public static final class_9139<class_9129, WindParticleOptions> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48550, WindParticleOptions::lifespan, FrozenByteBufCodecs.VEC3, WindParticleOptions::velocity, ParticleLength.STREAM_CODEC, WindParticleOptions::length, WindParticleOptions::new);

    public WindParticleOptions(int lifespan, class_243 velocity) {
        this(lifespan, velocity, ParticleLength.SMALL);
    }

    public WindParticleOptions(int lifespan, double xVel, double yVel, double zVel, ParticleLength length) {
        this(lifespan, new class_243(xVel, yVel, zVel), length);
    }

    public WindParticleOptions(int lifespan, double xVel, double yVel, double zVel) {
        this(lifespan, new class_243(xVel, yVel, zVel), ParticleLength.SMALL);
    }

    public class_2396<?> method_10295() {
        if (this.length == ParticleLength.MEDIUM) {
            return FrozenLibParticleTypes.WIND_MEDIUM;
        }
        return FrozenLibParticleTypes.WIND_SMALL;
    }

    public static enum ParticleLength implements class_3542
    {
        SMALL("small", 1.0, 0.25f, 1.0f),
        MEDIUM("medium", 1.2, 0.1f, 3.2f);

        public static final Codec<ParticleLength> CODEC;
        public static final class_9139<ByteBuf, ParticleLength> STREAM_CODEC;
        private final String name;
        private final double windMovementScale;
        private final float rotationChangeAmount;
        private final float quadSizeScale;

        private ParticleLength(String name, double windMovementScale, float rotationChangeAmount, float quadSizeScale) {
            this.name = name;
            this.windMovementScale = windMovementScale;
            this.rotationChangeAmount = rotationChangeAmount;
            this.quadSizeScale = quadSizeScale;
        }

        public double getWindMovementScale() {
            return this.windMovementScale;
        }

        public float getRotationChangeAmount() {
            return this.rotationChangeAmount;
        }

        public float getQuadSizeScale() {
            return this.quadSizeScale;
        }

        @Contract(pure=true)
        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(ParticleLength::values);
            STREAM_CODEC = new class_9139<ByteBuf, ParticleLength>(){

                public ParticleLength decode(ByteBuf byteBuf) {
                    return ParticleLength.valueOf((String)class_9135.field_48554.decode((Object)byteBuf));
                }

                public void encode(ByteBuf byteBuf, ParticleLength particleLength) {
                    class_9135.field_48554.encode((Object)byteBuf, (Object)particleLength.name());
                }
            };
        }
    }
}

