/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.networking;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.client.impl.ClientCapeData;
import net.frozenblock.lib.cape.impl.networking.CapeCustomizePacket;
import net.frozenblock.lib.cape.impl.networking.LoadCapeRepoPacket;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.config.impl.network.ConfigSyncModification;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import net.frozenblock.lib.file.transfer.FileTransferFilter;
import net.frozenblock.lib.file.transfer.FileTransferPacket;
import net.frozenblock.lib.file.transfer.FileTransferRebuilder;
import net.frozenblock.lib.item.impl.network.CooldownChangePacket;
import net.frozenblock.lib.item.impl.network.CooldownTickCountPacket;
import net.frozenblock.lib.item.impl.network.ForcedCooldownPacket;
import net.frozenblock.lib.screenshake.api.client.ScreenShaker;
import net.frozenblock.lib.screenshake.impl.network.EntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveEntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.ScreenShakePacket;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.sound.client.api.sounds.RelativeMovingSoundInstance;
import net.frozenblock.lib.sound.client.api.sounds.RestrictedMovingSound;
import net.frozenblock.lib.sound.client.api.sounds.RestrictedMovingSoundLoop;
import net.frozenblock.lib.sound.client.api.sounds.RestrictedStartingSound;
import net.frozenblock.lib.sound.client.api.sounds.distance_based.FadingDistanceSwitchingSound;
import net.frozenblock.lib.sound.client.api.sounds.distance_based.RestrictedMovingFadingDistanceSwitchingSound;
import net.frozenblock.lib.sound.client.api.sounds.distance_based.RestrictedMovingFadingDistanceSwitchingSoundLoop;
import net.frozenblock.lib.sound.client.impl.FlyBySoundHub;
import net.frozenblock.lib.sound.impl.networking.FadingDistanceSwitchingSoundPacket;
import net.frozenblock.lib.sound.impl.networking.FlyBySoundPacket;
import net.frozenblock.lib.sound.impl.networking.LocalPlayerSoundPacket;
import net.frozenblock.lib.sound.impl.networking.LocalSoundPacket;
import net.frozenblock.lib.sound.impl.networking.MovingFadingDistanceSwitchingRestrictionSoundPacket;
import net.frozenblock.lib.sound.impl.networking.MovingRestrictionSoundPacket;
import net.frozenblock.lib.sound.impl.networking.RelativeMovingSoundPacket;
import net.frozenblock.lib.sound.impl.networking.StartingMovingRestrictionSoundLoopPacket;
import net.frozenblock.lib.spotting_icons.impl.EntitySpottingIconInterface;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconRemovePacket;
import net.frozenblock.lib.texture.client.api.ServerTextureDownloader;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.lib.wind.impl.networking.WindAccessPacket;
import net.frozenblock.lib.wind.impl.networking.WindDisturbancePacket;
import net.frozenblock.lib.wind.impl.networking.WindSyncPacket;
import net.frozenblock.lib.worldgen.structure.api.status.client.ClientStructureStatuses;
import net.frozenblock.lib.worldgen.structure.impl.status.networking.PlayerStructureStatusPacket;
import net.minecraft.class_1102;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_1796;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public final class FrozenClientNetworking {
    public static void registerClientReceivers() {
        FrozenClientNetworking.receiveLocalPlayerSoundPacket();
        FrozenClientNetworking.receiveLocalSoundPacket();
        FrozenClientNetworking.receiveRelativeMovingSoundPacket();
        FrozenClientNetworking.receiveStartingMovingRestrictionSoundLoopPacket();
        FrozenClientNetworking.receiveMovingRestrictionSoundPacket();
        FrozenClientNetworking.receiveFadingDistanceSwitchingSoundPacket();
        FrozenClientNetworking.receiveMovingFadingDistanceSwitchingSoundPacket();
        FrozenClientNetworking.onReceiveFlyBySoundPacket();
        FrozenClientNetworking.receiveCooldownChangePacket();
        FrozenClientNetworking.receiveForcedCooldownPacket();
        FrozenClientNetworking.receiveCooldownTickCountPacket();
        FrozenClientNetworking.receiveScreenShakePacket();
        FrozenClientNetworking.receiveScreenShakeFromEntityPacket();
        FrozenClientNetworking.receiveRemoveScreenShakePacket();
        FrozenClientNetworking.receiveRemoveScreenShakeFromEntityPacket();
        FrozenClientNetworking.receiveIconPacket();
        FrozenClientNetworking.receiveIconRemovePacket();
        FrozenClientNetworking.receiveWindSyncPacket();
        FrozenClientNetworking.receiveWindDisturbancePacket();
        FrozenClientNetworking.receiveStructureStatusPacket();
        FrozenClientNetworking.receiveFileTransferPacket();
        FrozenClientNetworking.receiveCapePacket();
        FrozenClientNetworking.receiveCapeRepoPacket();
        ClientPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.PACKET_TYPE, (packet, ctx) -> ConfigSyncPacket.receive(packet, null));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            for (Config<?> config : ConfigRegistry.getAllConfigs()) {
                ConfigSyncModification.clearSyncData(config);
            }
        });
        FrozenClientNetworking.receiveWindDebugPacket();
    }

    @ApiStatus.Internal
    private static void receiveLocalPlayerSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(LocalPlayerSoundPacket.PACKET_TYPE, (packet, ctx) -> {
            class_746 player = ctx.player();
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1106((class_3414)packet.sound().comp_349(), class_3419.field_15248, packet.volume(), packet.pitch(), (class_1297)player, ctx.client().field_1687.field_9229.method_43055()));
        });
    }

    @ApiStatus.Internal
    private static void receiveLocalSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(LocalSoundPacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = ctx.client().field_1687;
            class_243 pos = packet.pos();
            level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)packet.sound().comp_349(), packet.source(), packet.volume(), packet.pitch(), packet.distanceDelay());
        });
    }

    @ApiStatus.Internal
    private static void receiveRelativeMovingSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(RelativeMovingSoundPacket.PACKET_TYPE, (packet, ctx) -> {
            class_746 player = ctx.player();
            if (player == null) {
                return;
            }
            ctx.client().method_1483().method_4873((class_1113)new RelativeMovingSoundInstance((class_3414)packet.sound().comp_349(), packet.source(), packet.volume(), packet.pitch(), (class_1297)player, packet.pos(), ctx.client().field_1687.field_9229.method_43055()));
        });
    }

    @ApiStatus.Internal
    private static <T extends class_1297> void receiveStartingMovingRestrictionSoundLoopPacket() {
        ClientPlayNetworking.registerGlobalReceiver(StartingMovingRestrictionSoundLoopPacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = ctx.client().field_1687;
            class_1297 entity = level.method_8469(packet.id());
            if (entity == null) {
                return;
            }
            SoundPredicate.LoopPredicate predicate = SoundPredicate.getPredicate(packet.predicateId());
            class_310.method_1551().method_1483().method_4873(new RestrictedStartingSound<class_1297>(entity, (class_3414)packet.startingSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath(), (class_1102)new RestrictedMovingSoundLoop<class_1297>(entity, (class_3414)packet.sound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath())));
        });
    }

    @ApiStatus.Internal
    private static <T extends class_1297> void receiveMovingRestrictionSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(MovingRestrictionSoundPacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = ctx.client().field_1687;
            class_1297 entity = level.method_8469(packet.id());
            if (entity == null) {
                return;
            }
            SoundPredicate.LoopPredicate predicate = SoundPredicate.getPredicate(packet.predicateId());
            if (packet.looping()) {
                class_310.method_1551().method_1483().method_4873(new RestrictedMovingSoundLoop<class_1297>(entity, (class_3414)packet.sound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath()));
            } else {
                class_310.method_1551().method_1483().method_4873(new RestrictedMovingSound<class_1297>(entity, (class_3414)packet.sound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath()));
            }
        });
    }

    private static void receiveFadingDistanceSwitchingSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(FadingDistanceSwitchingSoundPacket.PACKET_TYPE, (packet, ctx) -> {
            ctx.client().method_1483().method_4873((class_1113)new FadingDistanceSwitchingSound((class_3414)packet.closeSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), packet.fadeDist(), packet.maxDist(), packet.volume(), false, packet.pos()));
            ctx.client().method_1483().method_4873((class_1113)new FadingDistanceSwitchingSound((class_3414)packet.farSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), packet.fadeDist(), packet.maxDist(), packet.volume(), true, packet.pos()));
        });
    }

    @ApiStatus.Internal
    private static <T extends class_1297> void receiveMovingFadingDistanceSwitchingSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(MovingFadingDistanceSwitchingRestrictionSoundPacket.PACKET_TYPE, (packet, ctx) -> {
            class_1144 soundManager = ctx.client().method_1483();
            class_638 level = ctx.client().field_1687;
            class_1297 entity = level.method_8469(packet.id());
            if (entity == null) {
                return;
            }
            SoundPredicate.LoopPredicate predicate = SoundPredicate.getPredicate(packet.predicateId());
            if (packet.looping()) {
                soundManager.method_4873(new RestrictedMovingFadingDistanceSwitchingSoundLoop<class_1297>(entity, (class_3414)packet.closeSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath(), packet.fadeDist(), packet.maxDist(), packet.volume(), false));
                soundManager.method_4873(new RestrictedMovingFadingDistanceSwitchingSoundLoop<class_1297>(entity, (class_3414)packet.farSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath(), packet.fadeDist(), packet.maxDist(), packet.volume(), true));
            } else {
                soundManager.method_4873(new RestrictedMovingFadingDistanceSwitchingSound<class_1297>(entity, (class_3414)packet.closeSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath(), packet.fadeDist(), packet.maxDist(), packet.volume(), false));
                soundManager.method_4873(new RestrictedMovingFadingDistanceSwitchingSound<class_1297>(entity, (class_3414)packet.farSound().comp_349(), packet.source(), packet.volume(), packet.pitch(), predicate, packet.stopOnDeath(), packet.fadeDist(), packet.maxDist(), packet.volume(), true));
            }
        });
    }

    @ApiStatus.Internal
    public static void onReceiveFlyBySoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver(FlyBySoundPacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = (class_638)ctx.player().method_73183();
            class_1297 entity = level.method_8469(packet.id());
            if (entity == null) {
                return;
            }
            FlyBySoundHub.FlyBySound flyBySound = new FlyBySoundHub.FlyBySound(packet.pitch(), packet.volume(), packet.source(), (class_3414)packet.sound().comp_349());
            FlyBySoundHub.addEntity(entity, flyBySound);
        });
    }

    @ApiStatus.Internal
    private static void receiveCooldownChangePacket() {
        ClientPlayNetworking.registerGlobalReceiver(CooldownChangePacket.PACKET_TYPE, (packet, ctx) -> {
            class_746 player = ctx.player();
            class_2960 cooldownGroup = packet.cooldownGroup();
            int additional = packet.additional();
            player.method_7357().frozenLib$changeCooldown(cooldownGroup, additional);
        });
    }

    @ApiStatus.Internal
    private static void receiveForcedCooldownPacket() {
        ClientPlayNetworking.registerGlobalReceiver(ForcedCooldownPacket.PACKET_TYPE, (packet, ctx) -> {
            class_746 player = ctx.player();
            class_2960 cooldownGroup = packet.cooldownGroup();
            int startTime = packet.startTime();
            int endTime = packet.endTime();
            player.method_7357().field_8024.put(cooldownGroup, new class_1796.class_1797(startTime, endTime));
        });
    }

    @ApiStatus.Internal
    private static void receiveCooldownTickCountPacket() {
        ClientPlayNetworking.registerGlobalReceiver(CooldownTickCountPacket.PACKET_TYPE, (packet, ctx) -> {
            class_746 player = ctx.player();
            if (player != null) {
                player.method_7357().field_8025 = packet.count();
            }
        });
    }

    @ApiStatus.Internal
    private static void receiveScreenShakePacket() {
        ClientPlayNetworking.registerGlobalReceiver(ScreenShakePacket.PACKET_TYPE, (packet, ctx) -> {
            float intensity = packet.intensity();
            int duration = packet.duration();
            int fallOffStart = packet.falloffStart();
            class_243 pos = packet.pos();
            float maxDistance = packet.maxDistance();
            int ticks = packet.ticks();
            class_638 level = ctx.client().field_1687;
            ScreenShaker.addShake(level, intensity, duration, fallOffStart, pos, maxDistance, ticks);
        });
    }

    @ApiStatus.Internal
    private static void receiveScreenShakeFromEntityPacket() {
        ClientPlayNetworking.registerGlobalReceiver(EntityScreenShakePacket.PACKET_TYPE, (packet, ctx) -> {
            int id = packet.entityId();
            float intensity = packet.intensity();
            int duration = packet.duration();
            int fallOffStart = packet.falloffStart();
            float maxDistance = packet.maxDistance();
            int ticks = packet.ticks();
            class_638 level = ctx.client().field_1687;
            class_1297 entity = level.method_8469(id);
            if (entity != null) {
                ScreenShaker.addShake(entity, intensity, duration, fallOffStart, maxDistance, ticks);
            }
        });
    }

    @ApiStatus.Internal
    private static void receiveRemoveScreenShakePacket() {
        ClientPlayNetworking.registerGlobalReceiver(RemoveScreenShakePacket.PACKET_TYPE, (packet, ctx) -> ScreenShaker.SCREEN_SHAKES.removeIf(clientScreenShake -> !(clientScreenShake instanceof ScreenShaker.ClientEntityScreenShake)));
    }

    @ApiStatus.Internal
    private static void receiveRemoveScreenShakeFromEntityPacket() {
        ClientPlayNetworking.registerGlobalReceiver(RemoveEntityScreenShakePacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = ctx.client().field_1687;
            int id = packet.entityId();
            class_1297 entity = level.method_8469(id);
            if (entity != null) {
                ScreenShaker.SCREEN_SHAKES.removeIf(clientScreenShake -> {
                    ScreenShaker.ClientEntityScreenShake entityScreenShake;
                    return clientScreenShake instanceof ScreenShaker.ClientEntityScreenShake && (entityScreenShake = (ScreenShaker.ClientEntityScreenShake)clientScreenShake).getEntity() == entity;
                });
            }
        });
    }

    @ApiStatus.Internal
    private static void receiveIconPacket() {
        ClientPlayNetworking.registerGlobalReceiver(SpottingIconPacket.PACKET_TYPE, (packet, ctx) -> {
            int id = packet.entityId();
            class_2960 texture = packet.texture();
            float startFade = packet.startFade();
            float endFade = packet.endFade();
            class_2960 predicate = packet.restrictionID();
            class_638 level = ctx.client().field_1687;
            class_1297 entity = level.method_8469(id);
            if (entity instanceof EntitySpottingIconInterface) {
                EntitySpottingIconInterface livingEntity = (EntitySpottingIconInterface)entity;
                livingEntity.getSpottingIconManager().setIcon(texture, startFade, endFade, predicate);
            }
        });
    }

    @ApiStatus.Internal
    private static void receiveIconRemovePacket() {
        ClientPlayNetworking.registerGlobalReceiver(SpottingIconRemovePacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = ctx.client().field_1687;
            int id = packet.entityId();
            class_1297 entity = level.method_8469(id);
            if (entity instanceof EntitySpottingIconInterface) {
                EntitySpottingIconInterface livingEntity = (EntitySpottingIconInterface)entity;
                livingEntity.getSpottingIconManager().icon = null;
            }
        });
    }

    @ApiStatus.Internal
    private static void receiveWindSyncPacket() {
        ClientPlayNetworking.registerGlobalReceiver(WindSyncPacket.PACKET_TYPE, (packet, ctx) -> {
            ClientWindManager.time = packet.windTime();
            ClientWindManager.setSeed(packet.seed());
            ClientWindManager.overrideWind = packet.override();
            ClientWindManager.commandWind = packet.commandWind();
            ClientWindManager.hasInitialized = true;
        });
    }

    @ApiStatus.Internal
    private static void receiveWindDisturbancePacket() {
        ClientPlayNetworking.registerGlobalReceiver(WindDisturbancePacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 level = ctx.client().field_1687;
            if (level == null) {
                return;
            }
            long posOrID = packet.posOrID();
            Optional<WindDisturbanceLogic> disturbanceLogic = WindDisturbanceLogic.getWindDisturbanceLogic(packet.id());
            if (disturbanceLogic.isEmpty()) {
                return;
            }
            WindDisturbanceLogic.SourceType sourceType = packet.sourceType();
            Optional<Object> source = Optional.empty();
            if (sourceType == WindDisturbanceLogic.SourceType.ENTITY) {
                source = Optional.ofNullable(level.method_8469((int)posOrID));
            } else if (sourceType == WindDisturbanceLogic.SourceType.BLOCK_ENTITY) {
                source = Optional.ofNullable(level.method_8321(class_2338.method_10092((long)posOrID)));
            } else if (sourceType == WindDisturbanceLogic.SourceType.BLOCK) {
                source = Optional.of(level.method_8320(class_2338.method_10092((long)posOrID)).method_26204());
            }
            ClientWindManager.addWindDisturbance(new WindDisturbance(source, packet.origin(), packet.affectedArea(), disturbanceLogic.get()));
        });
    }

    @ApiStatus.Internal
    private static void receiveStructureStatusPacket() {
        ClientPlayNetworking.registerGlobalReceiver(PlayerStructureStatusPacket.PACKET_TYPE, (packet, ctx) -> ClientStructureStatuses.setStructureStatuses(packet.statuses()));
    }

    private static void receiveFileTransferPacket() {
        ClientPlayNetworking.registerGlobalReceiver(FileTransferPacket.PACKET_TYPE, (packet, ctx) -> {
            if (!FrozenLibConfig.FILE_TRANSFER_CLIENT) {
                return;
            }
            if (packet.request()) {
                String fileName;
                String requestPath = packet.transferPath();
                if (!FileTransferFilter.isRequestAcceptable(requestPath, fileName = packet.fileName(), null)) {
                    return;
                }
                Path requestedPath = ctx.client().field_1697.toPath().resolve(requestPath);
                File file = requestedPath.resolve(fileName).toFile();
                File localFile = requestedPath.resolve(".local").resolve(fileName).toFile();
                File sendingFile = file.exists() ? file : localFile;
                try {
                    for (FileTransferPacket fileTransferPacket : FileTransferPacket.create(requestPath, sendingFile)) {
                        ClientPlayNetworking.send((class_8710)fileTransferPacket);
                    }
                }
                catch (IOException ignored) {
                    FrozenLibConstants.LOGGER.error("Unable to create and send transfer packet for file {}!", (Object)packet.fileName());
                }
            } else {
                String fileName;
                String destPath = packet.transferPath();
                if (!FileTransferFilter.isTransferAcceptable(destPath, fileName = packet.fileName(), null)) {
                    return;
                }
                try {
                    class_2960 identifier;
                    Path path = ctx.client().field_1697.toPath().resolve(destPath).resolve(fileName);
                    if (FileTransferRebuilder.onReceiveFileTransferPacket(path, packet.snippet(), packet.totalPacketCount(), true) && (identifier = ServerTextureDownloader.WAITING_TEXTURES.get(ServerTextureDownloader.makePathFromRootAndDest(packet.transferPath(), packet.fileName()))) != null) {
                        ServerTextureDownloader.downloadAndRegisterServerTexture(identifier, packet.transferPath(), packet.fileName());
                    }
                }
                catch (IOException ignored) {
                    FrozenLibConstants.LOGGER.error("Unable to save transferred file {} on client!", (Object)fileName);
                }
            }
        });
    }

    private static void receiveCapePacket() {
        ClientPlayNetworking.registerGlobalReceiver(CapeCustomizePacket.PACKET_TYPE, (packet, ctx) -> {
            UUID uuid = packet.getPlayerUUID();
            if (packet.isEnabled()) {
                ClientCapeData.setCapeForUUID(uuid, packet.getCapeId());
            } else {
                ClientCapeData.removeCapeForUUID(uuid);
            }
        });
    }

    private static void receiveCapeRepoPacket() {
        ClientPlayNetworking.registerGlobalReceiver(LoadCapeRepoPacket.PACKET_TYPE, (packet, ctx) -> CapeUtil.registerCapesFromURL(packet.capeRepo()));
    }

    private static void receiveWindDebugPacket() {
        ClientPlayNetworking.registerGlobalReceiver(WindAccessPacket.PACKET_TYPE, (packet, ctx) -> {
            if (!FrozenLibConstants.DEBUG_WIND) {
                return;
            }
            ClientWindManager.Debug.addAccessedPosition(packet.accessPos());
        });
    }

    public static boolean notConnected() {
        class_310 minecraft = class_310.method_1551();
        class_634 listener = minecraft.method_1562();
        if (listener == null) {
            return true;
        }
        class_746 player = class_310.method_1551().field_1724;
        return player == null;
    }

    public static boolean connectedToLan() {
        if (FrozenClientNetworking.notConnected()) {
            return false;
        }
        class_642 serverData = class_310.method_1551().method_1558();
        if (serverData == null) {
            return false;
        }
        return serverData.method_2994();
    }
}

