/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.math.api;

import java.io.Serializable;

public abstract class Point3D
implements Cloneable {
    protected Point3D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract void setLocation(double var1, double var3, double var5);

    public void setLocation(Point3D p) {
        this.setLocation(p.getX(), p.getY(), p.getZ());
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 -= x2) * x1 + (y1 -= y2) * y1 + (z1 -= z2) * z1;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1 + (z1 -= z2) * z1);
    }

    public double distanceSq(double px, double py, double pz) {
        return (px -= this.getX()) * px + (py -= this.getY()) * py + (pz -= this.getZ()) * pz;
    }

    public double distanceSq(Point3D pt) {
        double px = pt.getX() - this.getX();
        double py = pt.getY() - this.getY();
        double pz = pt.getZ() - this.getZ();
        return px * px + py * py + pz * pz;
    }

    public double distance(double px, double py, double pz) {
        return Math.sqrt((px -= this.getX()) * px + (py -= this.getY()) * py + (pz -= this.getZ()) * pz);
    }

    public double distance(Point3D pt) {
        double px = pt.getX() - this.getX();
        double py = pt.getY() - this.getY();
        double pz = pt.getZ() - this.getZ();
        return Math.sqrt(px * px + py * py + pz * pz);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.getX());
        return (int)(bits ^= java.lang.Double.doubleToLongBits(this.getY()) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point3D) {
            Point3D p3d = (Point3D)obj;
            return this.getX() == p3d.getX() && this.getY() == p3d.getY() && this.getZ() == p3d.getZ();
        }
        return super.equals(obj);
    }

    public static class Double
    extends Point3D
    implements Serializable {
        public double x;
        public double y;
        public double z;

        public Double() {
        }

        public Double(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getZ() {
            return this.y;
        }

        @Override
        public void setLocation(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String toString() {
            return "Point3D.Double[" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }

    public static class Float
    extends Point3D
    implements Serializable {
        public float x;
        public float y;
        public float z;

        public Float() {
        }

        public Float(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setLocation(double x, double y, double z) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
        }

        public void setLocation(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String toString() {
            return "Point3D.Float[" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }
}

