/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.math.api;

import java.awt.geom.Point2D;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Obsolete(since="Minecraft 1.19")
public final class AnimationAPI {
    public static double relativeX(Point2D a, Point2D b, double x) {
        return (x - a.getX()) / (b.getX() - a.getX());
    }

    @Deprecated
    public static double rawSeed(double seed) {
        double f = Math.pow(Math.PI, 3.0);
        double linear = (seed + f) * f;
        double flat = Math.floor(linear);
        return linear - flat;
    }

    public static double seed(double seed) {
        return AnimationAPI.rawSeed(AnimationAPI.rawSeed(AnimationAPI.rawSeed(seed)));
    }

    public static double seed2D(Point2D seed2d, double seed) {
        return AnimationAPI.rawSeed(seed2d.getX()) * AnimationAPI.rawSeed(seed2d.getX()) * AnimationAPI.rawSeed(seed);
    }

    public static double legAnimation(double base, double range, double frequency, double limbAngle, double limbDistance, boolean inverted) {
        double baseRange = 1.4;
        double baseFrequency = 0.6662;
        double wave = Math.sin(limbAngle * (0.6662 * frequency)) * (1.4 * range) * limbDistance;
        if (inverted) {
            return base + wave;
        }
        return base - wave;
    }

    public static double legAnimation(double base, double range, double frequency, double limbAngle, double limbDistance) {
        return AnimationAPI.legAnimation(base, range, frequency, limbAngle, limbDistance, false);
    }

    public static double legAnimation(double base, double limbAngle, double limbDistance, boolean inverted) {
        return AnimationAPI.legAnimation(base, 1.0, 1.0, limbAngle, limbDistance, inverted);
    }

    public static double legAnimation(double base, double limbAngle, double limbDistance) {
        return AnimationAPI.legAnimation(base, limbAngle, limbDistance, false);
    }

    public static double sineEaseIn(Point2D a, Point2D b, double x) {
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 - Math.cos(Math.PI * (AnimationAPI.relativeX(a, b, x) / 2.0)));
    }

    public static double sineEaseOut(Point2D a, Point2D b, double x) {
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * Math.sin(Math.PI * (AnimationAPI.relativeX(a, b, x) / 2.0));
    }

    public static double sineEaseInOut(Point2D a, Point2D b, double x) {
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (0.5 - Math.cos(Math.PI * AnimationAPI.relativeX(a, b, x)) / 2.0);
    }

    public static double polyEaseIn(Point2D a, Point2D b, double x, double c) {
        if (c < 0.0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * Math.pow(AnimationAPI.relativeX(a, b, x), c);
    }

    public static double polyEaseOut(Point2D a, Point2D b, double x, double c) {
        if (c < 0.0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 - Math.pow(-(AnimationAPI.relativeX(a, b, x) - 1.0), c));
    }

    public static double polyEaseInOut(Point2D a, Point2D b, double x, double c) {
        if (c < 0.0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        if (x < (b.getX() - a.getX()) / 2.0) {
            return b.getY() * (Math.pow(2.0, c - 1.0) * Math.pow(AnimationAPI.relativeX(a, b, x), c));
        }
        return b.getY() * (1.0 - Math.pow(2.0 - 2.0 * AnimationAPI.relativeX(a, b, x), c) / 2.0);
    }

    public static double quadraticEaseIn(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseIn(a, b, x, 2.0);
    }

    public static double quadraticEaseOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseOut(a, b, x, 2.0);
    }

    public static double quadraticEaseInOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseInOut(a, b, x, 2.0);
    }

    public static double cubicEaseIn(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseIn(a, b, x, 3.0);
    }

    public static double cubicEaseOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseOut(a, b, x, 3.0);
    }

    public static double cubicEaseInOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseInOut(a, b, x, 3.0);
    }

    public static double quarticEaseIn(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseIn(a, b, x, 4.0);
    }

    public static double quarticEaseOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseOut(a, b, x, 4.0);
    }

    public static double quarticEaseInOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseInOut(a, b, x, 4.0);
    }

    public static double quinticEaseIn(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseIn(a, b, x, 5.0);
    }

    public static double quinticEaseOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseOut(a, b, x, 5.0);
    }

    public static double quinticEaseInOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.polyEaseInOut(a, b, x, 5.0);
    }

    public static double expoEaseIn(Point2D a, Point2D b, double x) {
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * Math.pow(2.0, 10.0 * AnimationAPI.relativeX(a, b, x) - 10.0);
    }

    public static double expoEaseOut(Point2D a, Point2D b, double x) {
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 - Math.pow(2.0, -10.0 * AnimationAPI.relativeX(a, b, x)));
    }

    public static double expoEaseInOut(Point2D a, Point2D b, double x) {
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        if (x < (b.getX() - a.getX()) / 2.0) {
            return b.getY() * Math.pow(2.0, 20.0 * AnimationAPI.relativeX(a, b, x) - 10.0) / 2.0;
        }
        return b.getY() * (2.0 - Math.pow(2.0, 10.0 - 20.0 * AnimationAPI.relativeX(a, b, x))) / 2.0;
    }

    public static double circEaseIn(Point2D a, Point2D b, double x, int roundness) {
        if (roundness < 0) {
            System.out.println("Animation API error - roundness must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 - Math.pow(1.0 - Math.pow(AnimationAPI.relativeX(a, b, x), roundness), 1 / roundness));
    }

    public static double circEaseOut(Point2D a, Point2D b, double x, int roundness) {
        if (roundness < 0) {
            System.out.println("Animation API error - roundness must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * Math.pow(1.0 - Math.pow(AnimationAPI.relativeX(a, b, x) - 1.0, roundness), 1 / roundness);
    }

    public static double circEaseInOut(Point2D a, Point2D b, double x, int roundness) {
        if (roundness < 0) {
            System.out.println("Animation API error - roundness must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        if (x < (b.getX() - a.getX()) / 2.0) {
            return b.getY() * (1.0 - Math.pow(1.0 - Math.pow(2.0 * AnimationAPI.relativeX(a, b, x), roundness), 1 / roundness)) / 2.0;
        }
        return b.getY() * (Math.pow(1.0 - Math.pow(-2.0 * AnimationAPI.relativeX(a, b, x) + 2.0, roundness), 1 / roundness) + 1.0) / 2.0;
    }

    public static double circEaseIn(Point2D a, Point2D b, double x) {
        return AnimationAPI.circEaseIn(a, b, x, 2);
    }

    public static double circEaseOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.circEaseOut(a, b, x, 2);
    }

    public static double circEaseInOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.circEaseInOut(a, b, x, 2);
    }

    public static double elasticEaseIn(Point2D a, Point2D b, double x, int c) {
        if (c < 0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (Math.cos(Math.PI * 2 * (double)c * AnimationAPI.relativeX(a, b, x)) * AnimationAPI.relativeX(a, b, x));
    }

    public static double elasticEaseOut(Point2D a, Point2D b, double x, int c) {
        if (c < 0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 - Math.cos(Math.PI * 2 * (double)c * AnimationAPI.relativeX(a, b, x)) * (1.0 - AnimationAPI.relativeX(a, b, x)));
    }

    public static double elasticEaseInOut(Point2D a, Point2D b, double x, int c) {
        if (c < 0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (AnimationAPI.relativeX(a, b, x) + Math.sin(Math.PI * 2 * (double)c * AnimationAPI.relativeX(a, b, x)) * Math.sin(Math.PI * AnimationAPI.relativeX(a, b, x)));
    }

    public static double elasticEaseIn(Point2D a, Point2D b, double x) {
        int c = (int)(b.getX() - a.getX());
        return AnimationAPI.elasticEaseIn(a, b, x, c);
    }

    public static double elasticEaseOut(Point2D a, Point2D b, double x) {
        int c = (int)(b.getX() - a.getX());
        return AnimationAPI.elasticEaseOut(a, b, x, c);
    }

    public static double elasticEaseInOut(Point2D a, Point2D b, double x) {
        int c = (int)(b.getX() - a.getX());
        return AnimationAPI.elasticEaseInOut(a, b, x, c);
    }

    public static double bounceEaseIn(Point2D a, Point2D b, double x, int c) {
        if (c < 0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * Math.abs(Math.cos(Math.PI * 2 * (double)c * AnimationAPI.relativeX(a, b, x)) * AnimationAPI.relativeX(a, b, x));
    }

    public static double bounceEaseOut(Point2D a, Point2D b, double x, int c) {
        if (c < 0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 - Math.abs(Math.cos(Math.PI * 2 * (double)c * AnimationAPI.relativeX(a, b, x)) * (1.0 - AnimationAPI.relativeX(a, b, x))));
    }

    public static double bounceEaseInOut(Point2D a, Point2D b, double x, int c) {
        if (c < 0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (AnimationAPI.relativeX(a, b, x) + Math.abs(Math.sin(Math.PI * 2 * (double)c * AnimationAPI.relativeX(a, b, x)) * Math.sin(Math.PI * AnimationAPI.relativeX(a, b, x))));
    }

    public static double bounceEaseIn(Point2D a, Point2D b, double x) {
        int c = (int)(b.getX() - a.getX());
        return AnimationAPI.elasticEaseIn(a, b, x, c);
    }

    public static double bounceEaseOut(Point2D a, Point2D b, double x) {
        int c = (int)(b.getX() - a.getX());
        return AnimationAPI.elasticEaseOut(a, b, x, c);
    }

    public static double bounceEaseInOut(Point2D a, Point2D b, double x) {
        int c = (int)(b.getX() - a.getX());
        return AnimationAPI.elasticEaseInOut(a, b, x, c);
    }

    public static double backEaseIn(Point2D a, Point2D b, double x, double c1) {
        double c2 = c1 + 1.0;
        if (c1 < 0.0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (c2 * Math.pow(AnimationAPI.relativeX(a, b, x), 3.0) - c1 * Math.pow(AnimationAPI.relativeX(a, b, x) - 1.0, 2.0));
    }

    public static double backEaseOut(Point2D a, Point2D b, double x, double c1) {
        double c2 = c1 + 1.0;
        if (c1 < 0.0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        return b.getY() * (1.0 + c2 * Math.pow(AnimationAPI.relativeX(a, b, x) - 1.0, 3.0) + c1 * Math.pow(AnimationAPI.relativeX(a, b, x) - 1.0, 2.0));
    }

    public static double backEaseInOut(Point2D a, Point2D b, double x, double c1) {
        double c3 = c1 * (double)1.525f;
        if (c1 < 0.0) {
            System.out.println("Animation API error - c must be >= 0");
            return Math.random();
        }
        if (x < a.getX()) {
            return 0.0;
        }
        if (x > b.getX()) {
            return b.getY();
        }
        if (x < (b.getX() - a.getX()) / 2.0) {
            return b.getY() * (Math.pow(2.0 * AnimationAPI.relativeX(a, b, x), 2.0) * ((c3 + 1.0) * 2.0 * AnimationAPI.relativeX(a, b, x) - c3)) / 2.0;
        }
        return b.getY() * (Math.pow(2.0 * AnimationAPI.relativeX(a, b, x) - 2.0, 2.0) * ((c3 + 1.0) * (2.0 * AnimationAPI.relativeX(a, b, x) - 2.0) + c3) + 2.0) / 2.0;
    }

    public static double backEaseIn(Point2D a, Point2D b, double x) {
        return AnimationAPI.backEaseIn(a, b, x, 1.70158f);
    }

    public static double backEaseOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.backEaseOut(a, b, x, 1.70158f);
    }

    public static double backEaseInOut(Point2D a, Point2D b, double x) {
        return AnimationAPI.backEaseInOut(a, b, x, 1.70158f);
    }

    public static double line(Point2D a, Point2D b, double x) {
        return AnimationAPI.relativeX(a, b, x) * (b.getY() - a.getY()) + a.getY();
    }

    public static double flat(Point2D a, Point2D b, double x) {
        return Math.floor(AnimationAPI.relativeX(a, b, x)) * (b.getY() - a.getY()) + a.getY();
    }

    public static double flat2(Point2D a, Point2D b, double x) {
        return 2.0 * Math.floor(AnimationAPI.relativeX(a, b, x) / 2.0) * (b.getY() - a.getY()) + a.getY();
    }

    public static double inverse(Point2D a, Point2D b, double x) {
        return AnimationAPI.flat(a, b, x) + b.getY() - AnimationAPI.line(a, b, x);
    }

    public static double boomerang(Point2D a, Point2D b, double x) {
        return AnimationAPI.line(a, b, x) - AnimationAPI.flat2(a, b, x) + a.getY() < b.getY() ? AnimationAPI.line(a, b, x) - AnimationAPI.flat2(a, b, x) + a.getY() : AnimationAPI.inverse(a, b, x);
    }

    public static double loop(Point2D a, Point2D b, double x) {
        return AnimationAPI.line(a, b, x) - AnimationAPI.flat(a, b, x) + a.getY();
    }

    @Generated
    private AnimationAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

