/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.math.api;

import lombok.Generated;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class AdvancedMath {
    @Contract(value=" -> new")
    public static class_5819 random() {
        return class_5819.method_43047();
    }

    public static float range(float min, float max, float number) {
        return number * max + min;
    }

    public static double randomPosNeg() {
        class_5819 random = AdvancedMath.random();
        return random.method_43058() * (random.method_43056() ? 1.0 : -1.0);
    }

    public static boolean squareBetween(int x, int z, int between1, int between2) {
        boolean cond1 = x > between1 && x < between2;
        boolean cond2 = z > between1 && z < between2;
        return cond1 && cond2;
    }

    public static double cutCos(double value, double offset, boolean inverse) {
        double equation = Math.cos(value);
        if (!inverse) {
            return Math.max(equation, offset);
        }
        return Math.max(-equation, offset);
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Factorial of negative numbers is undefined");
        }
        int result = 1;
        for (int i = 2; i <= n; ++i) {
            result *= i;
        }
        return result;
    }

    public static int permutations(int n, int r) {
        if (n < 0 || r < 0 || r > n) {
            throw new IllegalArgumentException("Invalid input: n must be non-negative, r must be non-negative and not greater than n");
        }
        int result = 1;
        for (int i = n; i > n - r; --i) {
            result *= i;
        }
        return result;
    }

    public static int combinations(int n, int r) {
        if (n < 0 || r < 0 || r > n) {
            throw new IllegalArgumentException("Invalid input: n must be non-negative, r must be non-negative and not greater than n");
        }
        int numerator = 1;
        for (int i = n; i > n - r; --i) {
            numerator *= i;
        }
        int denominator = 1;
        for (int i = r; i > 0; --i) {
            denominator *= i;
        }
        return numerator / denominator;
    }

    public static double @Nullable [] solveQuadraticEquation(double a, double b, double c) {
        if (a == 0.0) {
            throw new IllegalArgumentException("a cannot be zero");
        }
        double discriminant = b * b - 4.0 * a * c;
        if (discriminant < 0.0) {
            return null;
        }
        if (discriminant == 0.0) {
            double root = -b / (2.0 * a);
            return new double[]{root};
        }
        double root1 = (-b + Math.sqrt(discriminant)) / (2.0 * a);
        double root2 = (-b - Math.sqrt(discriminant)) / (2.0 * a);
        return new double[]{root1, root2};
    }

    public static int greatestCommonDivisor(int a, int b) {
        if (a == 0 || b == 0) {
            return Math.abs(a + b);
        }
        while (b != 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return Math.abs(a);
    }

    public static class_2350 randomDir(class_2350.class_2351 axis) {
        boolean random = AdvancedMath.random().method_43056();
        switch (axis) {
            case field_11048: {
                return random ? class_2350.field_11034 : class_2350.field_11039;
            }
            case field_11052: {
                return random ? class_2350.field_11036 : class_2350.field_11033;
            }
        }
        return random ? class_2350.field_11043 : class_2350.field_11035;
    }

    public static double distanceBetween(class_2338 center, class_2338 currentPos, boolean includeY) {
        double xSquared = class_3532.method_34954((int)(center.method_10263() - currentPos.method_10263()));
        double ySquared = includeY ? (double)class_3532.method_34954((int)(center.method_10264() - currentPos.method_10264())) : 0.0;
        double zSquared = class_3532.method_34954((int)(center.method_10260() - currentPos.method_10260()));
        return Math.sqrt(xSquared + ySquared + zSquared);
    }

    public static class_243 rotateAboutXZ(class_243 original, double distanceFrom, double angle) {
        double calcAngle = angle * (Math.PI / 180);
        class_243 offsetVec = original.method_1031(distanceFrom, 0.0, distanceFrom);
        double originX = original.field_1352;
        double originZ = original.field_1350;
        double distancedX = offsetVec.field_1352;
        double distancedZ = offsetVec.field_1350;
        double x = originX + (distancedX - originX) * Math.cos(calcAngle) - (distancedZ - originZ) * Math.sin(calcAngle);
        double z = originZ + (distancedX - originX) * Math.sin(calcAngle) + (distancedZ - originZ) * Math.cos(calcAngle);
        return new class_243(x, original.field_1351, z);
    }

    public static class_243 rotateAboutX(class_243 original, double distanceFrom, double angle) {
        double calcAngle = angle * (Math.PI / 180);
        class_243 offsetVec = original.method_1031(distanceFrom, 0.0, 0.0);
        double originX = original.field_1352;
        double originZ = original.field_1350;
        double distancedX = offsetVec.field_1352;
        double distancedZ = offsetVec.field_1350;
        double x = originX + (distancedX - originX) * Math.cos(calcAngle) - (distancedZ - originZ) * Math.sin(calcAngle);
        double z = originZ + (distancedX - originX) * Math.sin(calcAngle) + (distancedZ - originZ) * Math.cos(calcAngle);
        return new class_243(x, original.field_1351, z);
    }

    @Contract(pure=true)
    public static double getAngleFromOriginXZ(class_243 pos) {
        double angleRad = Math.atan2(pos.field_1352, pos.field_1350);
        double degrees = angleRad * 57.2957763671875;
        return (360.0 + (double)Math.round(degrees)) % 360.0;
    }

    public static double getAngleBetweenXZ(class_243 posA, class_243 posB) {
        double angle = Math.atan2(posA.field_1352 - posB.field_1352, posA.field_1350 - posB.field_1350);
        return (360.0 + angle * 57.2957763671875) % 360.0;
    }

    @Generated
    private AdvancedMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

