/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.loot.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import net.frozenblock.lib.loot.impl.MutableLootItem;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class MutableLootPool {
    public ArrayList<class_79> entries = new ArrayList();
    public ArrayList<class_5341> conditions = new ArrayList();
    public ArrayList<class_117> functions = new ArrayList();
    public class_5658 rolls;
    public class_5658 bonusRolls;

    public MutableLootPool(class_55 lootPool) {
        this.entries.addAll(lootPool.field_953);
        this.conditions.addAll(lootPool.field_954);
        this.functions.addAll(lootPool.field_956);
        this.rolls = lootPool.field_957;
        this.bonusRolls = lootPool.field_958;
    }

    public class_55 build() {
        class_55.class_56 builder = class_55.method_347();
        this.entries.forEach(arg_0 -> ((ImmutableList.Builder)builder.field_960).add(arg_0));
        this.conditions.forEach(arg_0 -> ((ImmutableList.Builder)builder.field_963).add(arg_0));
        this.functions.forEach(arg_0 -> ((ImmutableList.Builder)builder.field_961).add(arg_0));
        builder.method_352(this.rolls);
        builder.method_35509(this.bonusRolls);
        return builder.method_355();
    }

    public MutableLootPool add(class_1935 item, int weight, class_117.class_118 builder) {
        this.entries.add(class_77.method_411((class_1935)item).method_437(weight).method_438(builder).method_419());
        return this;
    }

    public MutableLootPool addAll(int weight, class_117.class_118 builder, class_1935 ... items) {
        for (class_1935 item : items) {
            this.entries.add(class_77.method_411((class_1935)item).method_437(weight).method_438(builder).method_419());
        }
        return this;
    }

    public MutableLootPool remove(class_1935 item) {
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            if (!item.equals(lootItem.field_987.comp_349())) continue;
            this.entries.remove(entryContainer);
            return this;
        }
        return this;
    }

    public MutableLootPool remove(class_1935 ... items) {
        ArrayList<class_79> toRemove = new ArrayList<class_79>();
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            for (class_1935 item : items) {
                if (!item.equals(lootItem.field_987.comp_349())) continue;
                toRemove.add(entryContainer);
            }
        }
        for (class_79 entryContainer : toRemove) {
            this.entries.remove(entryContainer);
        }
        return this;
    }

    public MutableLootPool remove(class_6862<class_1792> tag) {
        ArrayList<class_79> toRemove = new ArrayList<class_79>();
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            if (!((class_1792)lootItem.field_987.comp_349()).method_40131().method_40220(tag)) continue;
            toRemove.add(entryContainer);
        }
        for (class_79 entryContainer : toRemove) {
            this.entries.remove(entryContainer);
        }
        return this;
    }

    public MutableLootPool remove(Predicate<class_1792> predicate) {
        ArrayList<class_79> toRemove = new ArrayList<class_79>();
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            if (!predicate.test((class_1792)lootItem.field_987.comp_349())) continue;
            toRemove.add(entryContainer);
        }
        for (class_79 entryContainer : toRemove) {
            this.entries.remove(entryContainer);
        }
        return this;
    }

    public MutableLootPool replace(class_1935 original, class_1935 replacement) {
        for (int i = 0; i < this.entries.size(); ++i) {
            class_79 entryContainer = this.entries.get(i);
            if (!(entryContainer instanceof class_77)) {
                return this;
            }
            class_77 lootItem = (class_77)entryContainer;
            if (!original.equals(lootItem.field_987.comp_349())) continue;
            MutableLootItem mutableLootItem = new MutableLootItem(lootItem);
            mutableLootItem.setItem(replacement);
            this.entries.set(i, (class_79)mutableLootItem.build());
        }
        return this;
    }

    public boolean hasItem(class_1792 item) {
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            if (!item.equals(lootItem.field_987.comp_349())) continue;
            return true;
        }
        return false;
    }

    public boolean hasItem(Predicate<class_1792> predicate) {
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            if (!predicate.test((class_1792)lootItem.field_987.comp_349())) continue;
            return true;
        }
        return false;
    }

    public boolean hasItem(class_6862<class_1792> itemTagKey) {
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            if (!((class_1792)lootItem.field_987.comp_349()).method_40131().method_40220(itemTagKey)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyItems(class_1792 ... items) {
        for (class_79 entryContainer : this.entries) {
            if (!(entryContainer instanceof class_77)) continue;
            class_77 lootItem = (class_77)entryContainer;
            for (class_1792 item : items) {
                if (!item.equals(lootItem.field_987.comp_349())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAllItems(class_1792 ... items) {
        HashMap<class_1792, Boolean> foundMap = new HashMap<class_1792, Boolean>();
        for (class_1792 item : items) {
            if (foundMap.getOrDefault(item, false).booleanValue()) continue;
            foundMap.put(item, false);
            for (class_79 entryContainer : this.entries) {
                if (!(entryContainer instanceof class_77)) continue;
                class_77 lootItem = (class_77)entryContainer;
                if (!item.equals(lootItem.field_987.comp_349())) continue;
                foundMap.put(item, true);
            }
        }
        return !foundMap.containsValue(false);
    }
}

