/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.gravity.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.lib.gravity.api.GravityAPI;
import net.frozenblock.lib.gravity.api.GravityFunction;
import net.frozenblock.lib.gravity.api.SerializableGravityFunction;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public record GravityBelt<T extends GravityFunction>(double minY, double maxY, boolean renderBottom, boolean renderTop, T function) {
    public GravityBelt(double minY, double maxY, T function) {
        this(minY, maxY, false, false, function);
    }

    public boolean affectsPosition(double y) {
        return y >= this.minY && y < this.maxY;
    }

    public class_243 getGravity(@Nullable class_1297 entity, double y) {
        if (this.affectsPosition(y)) {
            return this.function.get(entity, y, this.minY, this.maxY);
        }
        return GravityAPI.DEFAULT_GRAVITY;
    }

    public static <T extends SerializableGravityFunction<T>> Codec<GravityBelt<T>> codec(Codec<T> gravityFunction) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("minY").forGetter(GravityBelt::minY), (App)Codec.DOUBLE.fieldOf("maxY").forGetter(GravityBelt::maxY), (App)gravityFunction.fieldOf("gravityFunction").forGetter(GravityBelt::function)).apply((Applicative)instance, GravityBelt::new));
    }

    @Nullable
    public static <T extends SerializableGravityFunction<T>> Codec<GravityBelt<T>> codec(T gravityFunction) {
        Codec<T> codec = gravityFunction.codec();
        if (codec == null) {
            return null;
        }
        return GravityBelt.codec(codec);
    }
}

