/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class ConfigCommand {
    private ConfigCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"frozenlib_config").then(class_2170.method_9247((String)"reload").then(class_2170.method_9244((String)"modId", (ArgumentType)StringArgumentType.string()).executes(context -> ConfigCommand.reloadConfigs((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"modId"))))));
    }

    private static int reloadConfigs(class_2168 source, String modId) {
        Collection<Config<?>> configs = ConfigRegistry.getConfigsForMod(modId);
        for (Config<?> config : configs) {
            config.load();
        }
        for (class_3222 player : PlayerLookup.all((MinecraftServer)source.method_9211())) {
            ConfigSyncPacket.sendS2C(player, configs);
        }
        if (configs.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.frozenlib_config.reload.single", (Object[])new Object[]{modId}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.frozenlib_config.reload.multiple", (Object[])new Object[]{configs.size(), modId}), true);
        }
        return configs.size();
    }
}

