/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonLiteral;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import org.jetbrains.annotations.Nullable;

public class XjsOps
implements DynamicOps<JsonValue> {
    public static final XjsOps INSTANCE = new XjsOps(false);
    public static final XjsOps COMPRESSED = new XjsOps(true);
    private static final JsonValue EMPTY = JsonLiteral.jsonNull();
    private final boolean compressed;

    private XjsOps(boolean compressed) {
        this.compressed = compressed;
    }

    public JsonValue empty() {
        return EMPTY;
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonValue input) {
        if (input == null || input.isNull()) {
            return (U)outOps.empty();
        }
        if (input.isObject()) {
            return (U)this.convertMap(outOps, input);
        }
        if (input.isArray()) {
            return (U)this.convertList(outOps, input);
        }
        if (input.isString()) {
            return (U)outOps.createString(input.asString());
        }
        if (input.isBoolean()) {
            return (U)outOps.createBoolean(input.asBoolean());
        }
        if (input.isNumber()) {
            return this.toNumber(outOps, input.asDouble());
        }
        return null;
    }

    private <U> U toNumber(DynamicOps<U> outOps, double number) {
        if ((double)((byte)number) == number) {
            return (U)outOps.createByte((byte)number);
        }
        if ((double)((short)number) == number) {
            return (U)outOps.createShort((short)number);
        }
        if ((double)((int)number) == number) {
            return (U)outOps.createInt((int)number);
        }
        if ((double)((float)number) == number) {
            return (U)outOps.createFloat((float)number);
        }
        return (U)outOps.createDouble(number);
    }

    public DataResult<Number> getNumberValue(JsonValue input) {
        if (input == null || input.isNull()) {
            return DataResult.error(() -> "Not a number: null");
        }
        if (input.isNumber()) {
            return DataResult.success((Object)input.asDouble());
        }
        if (input.isBoolean()) {
            return DataResult.success((Object)(input.asBoolean() ? 1 : 0));
        }
        if (this.compressed && input.isString()) {
            try {
                return DataResult.success((Object)Integer.parseInt(input.asString()));
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Not a number: " + String.valueOf(e) + " " + String.valueOf(input));
            }
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    public JsonValue createNumeric(Number i) {
        return Json.value(i.doubleValue());
    }

    public DataResult<Boolean> getBooleanValue(JsonValue input) {
        if (input == null || input.isNull()) {
            return DataResult.error(() -> "Not a boolean: null");
        }
        if (input.isBoolean()) {
            return DataResult.success((Object)input.asBoolean());
        }
        if (input.isNumber()) {
            return DataResult.success((Object)(input.asDouble() != 0.0 ? 1 : 0));
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public JsonValue createBoolean(boolean value) {
        return Json.value(value);
    }

    public DataResult<String> getStringValue(JsonValue input) {
        if (input == null || input.isNull()) {
            return DataResult.error(() -> "Not a string: null");
        }
        if (input.isString()) {
            return DataResult.success((Object)input.asString());
        }
        if (this.compressed && input.isNumber()) {
            return DataResult.success((Object)String.valueOf(input.asDouble()));
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public JsonValue createString(String value) {
        return Json.value(value);
    }

    public DataResult<JsonValue> mergeToList(JsonValue list, JsonValue value) {
        if (list == null || list.isNull()) {
            return DataResult.success((Object)new JsonArray().add(value));
        }
        if (list.isArray()) {
            return DataResult.success((Object)new JsonArray().addAll(list.asArray()).add(value));
        }
        return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
    }

    public DataResult<JsonValue> mergeToList(JsonValue list, List<JsonValue> values) {
        if (list == null || list.isNull()) {
            JsonArray result = new JsonArray();
            values.forEach(result::add);
            return DataResult.success((Object)result);
        }
        if (list.isArray()) {
            JsonArray result = (JsonArray)list.asArray().shallowCopy();
            values.forEach(result::add);
            return DataResult.success((Object)result);
        }
        return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
    }

    public DataResult<JsonValue> mergeToMap(JsonValue map, JsonValue key, JsonValue value) {
        if (map != null && !map.isObject() && !map.isNull()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key.isString() || this.compressed && XjsOps.isPrimitiveLike(key))) {
            String msg = "key is not a string: " + String.valueOf(key);
            return map != null ? DataResult.error(() -> msg, (Object)map) : DataResult.error(() -> msg);
        }
        if (map == null || map.isNull()) {
            return DataResult.success((Object)new JsonObject().add(XjsOps.asPrimitiveString(key), value));
        }
        return DataResult.success((Object)new JsonObject().addAll(map.asObject()).add(XjsOps.asPrimitiveString(key), value));
    }

    public DataResult<JsonValue> mergeToMap(JsonValue map, MapLike<JsonValue> values) {
        if (map != null && !map.isObject() && !map.isNull()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        JsonObject output = new JsonObject();
        if (map != null && map.isObject()) {
            output.addAll(map.asObject());
        }
        ArrayList missed = new ArrayList();
        values.entries().forEach(entry -> {
            JsonValue key = (JsonValue)entry.getFirst();
            if (key.isString() || this.compressed && XjsOps.isPrimitiveLike(key)) {
                output.add(XjsOps.asPrimitiveString(key), (JsonValue)entry.getSecond());
            } else {
                missed.add(key);
            }
        });
        if (!missed.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf(missed), (Object)output);
        }
        return DataResult.success((Object)output);
    }

    public DataResult<Stream<Pair<JsonValue, JsonValue>>> getMapValues(JsonValue input) {
        if (input == null || !input.isObject()) {
            return DataResult.error(() -> "Not an XJS object: " + String.valueOf(input));
        }
        Stream.Builder<Pair> builder = Stream.builder();
        for (JsonObject.Member member : input.asObject()) {
            JsonValue value = member.getValue();
            builder.add(Pair.of((Object)Json.value(member.getKey()), (Object)(value.isNull() ? null : value)));
        }
        return DataResult.success(builder.build());
    }

    public DataResult<Consumer<BiConsumer<JsonValue, JsonValue>>> getMapEntries(JsonValue input) {
        if (input == null || !input.isObject()) {
            return DataResult.error(() -> "Not an XJS object: " + String.valueOf(input));
        }
        return DataResult.success(c -> {
            for (JsonObject.Member member : input.asObject()) {
                JsonValue value = member.getValue();
                c.accept(Json.value(member.getKey()), value.isNull() ? null : value);
            }
        });
    }

    public DataResult<MapLike<JsonValue>> getMap(JsonValue input) {
        if (input == null || !input.isObject()) {
            return DataResult.error(() -> "Not an XJS object: " + String.valueOf(input));
        }
        return DataResult.success((Object)new XJSMapLike(input.asObject()));
    }

    public JsonValue createMap(Stream<Pair<JsonValue, JsonValue>> map) {
        JsonObject result = new JsonObject();
        map.forEach(p -> {
            JsonValue v = (JsonValue)p.getSecond();
            result.add(((JsonValue)p.getFirst()).asString(), v != null ? v : EMPTY);
        });
        return result;
    }

    public DataResult<Stream<JsonValue>> getStream(JsonValue input) {
        if (input == null || !input.isArray()) {
            return DataResult.error(() -> "Not an XJS array: " + String.valueOf(input));
        }
        Stream.Builder<JsonValue> builder = Stream.builder();
        for (JsonValue value : input.asArray()) {
            builder.add(value.isNull() ? null : value);
        }
        return DataResult.success(builder.build());
    }

    public DataResult<Consumer<Consumer<JsonValue>>> getList(JsonValue input) {
        if (input == null || !input.isArray()) {
            return DataResult.error(() -> "Not an XJS array: + " + String.valueOf(input));
        }
        return DataResult.success(c -> {
            for (JsonValue value : input.asArray()) {
                c.accept(value.isNull() ? null : value);
            }
        });
    }

    public JsonValue createList(Stream<JsonValue> input) {
        JsonArray result = new JsonArray();
        input.forEach(v -> result.add(v != null ? v : EMPTY));
        return result;
    }

    public JsonValue remove(JsonValue input, String key) {
        if (input == null || !input.isObject()) {
            return input;
        }
        JsonObject result = new JsonObject();
        for (JsonObject.Member member : input.asObject()) {
            if (member.getKey().equals(key)) continue;
            result.add(member.getKey(), member.getValue());
        }
        return result;
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    public String toString() {
        return "XJS";
    }

    private static boolean isPrimitiveLike(JsonValue value) {
        return value.isBoolean() || value.isString() || value.isNumber();
    }

    private static String asPrimitiveString(JsonValue value) {
        return value.isNumber() ? String.valueOf(value.asDouble()) : value.asString();
    }

    private record XJSMapLike(JsonObject object) implements MapLike<JsonValue>
    {
        @Nullable
        public JsonValue get(JsonValue key) {
            JsonValue value = this.object.get(key.asString());
            return value != null && value.isNull() ? null : value;
        }

        @Nullable
        public JsonValue get(String key) {
            JsonValue value = this.object.get(key);
            return value != null && value.isNull() ? null : value;
        }

        public Stream<Pair<JsonValue, JsonValue>> entries() {
            Stream.Builder<Pair> builder = Stream.builder();
            for (JsonObject.Member member : this.object) {
                JsonValue value = member.getValue();
                builder.add(Pair.of((Object)Json.value(member.getKey()), (Object)(value.isNull() ? null : value)));
            }
            return builder.build();
        }

        @Override
        public String toString() {
            return "XJSMapLike[" + String.valueOf(this.object) + "]";
        }
    }
}

