/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import lombok.Generated;

public final class UnsafeUtils {
    public static <V> V constructUnsafely(Class<V> cls) {
        try {
            Constructor<V> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException var2) {
            throw new RuntimeException(var2);
        }
    }

    public static <V> V getUnsafely(Field field, Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return (V)field.get(obj);
        }
        catch (ReflectiveOperationException var3) {
            throw new RuntimeException(var3);
        }
    }

    public static <V> V getUnsafely(Field field, Object obj, V defaultValue) {
        V ret = UnsafeUtils.getUnsafely(field, obj);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static void setUnsafely(Field field, Object obj, Object newValue) {
        if (obj == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(obj, newValue);
        }
        catch (ReflectiveOperationException var4) {
            throw new RuntimeException(var4);
        }
    }

    @Generated
    private UnsafeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

