/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.json;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.config.api.entry.TypedEntry;
import net.frozenblock.lib.config.api.entry.TypedEntryType;
import net.frozenblock.lib.config.api.instance.json.JanksonOps;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonElement;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.DeserializationException;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.DeserializerFunction;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.Marshaller;
import org.jetbrains.annotations.Nullable;

public class JanksonTypedEntrySerializer
implements BiFunction<TypedEntry, Marshaller, JsonElement>,
DeserializerFunction<JsonElement, TypedEntry> {
    private final String modId;

    public JanksonTypedEntrySerializer(String modId) {
        this.modId = modId;
    }

    @Override
    public JsonElement apply(TypedEntry src, Marshaller marshaller) {
        Optional optional;
        DataResult encoded;
        Codec codec;
        TypedEntryType type;
        if (src != null && (type = src.type()) != null && Objects.equals(type.modId(), this.modId) && (codec = type.codec()) != null && (encoded = codec.encodeStart((DynamicOps)JanksonOps.INSTANCE, src.value())) != null && !encoded.error().isPresent() && (optional = encoded.result()).isPresent()) {
            return (JsonElement)optional.get();
        }
        throw new JsonParseException("Failed to serialize typed entry " + String.valueOf(src));
    }

    @Override
    public TypedEntry apply(JsonElement json, Marshaller m) throws DeserializationException {
        TypedEntry modEntry = this.getFromRegistry(json, ConfigRegistry.getTypedEntryTypesForMod(this.modId));
        if (modEntry != null) {
            return modEntry;
        }
        throw new DeserializationException("Failed to deserialize typed entry " + String.valueOf(json));
    }

    @Nullable
    private <T> TypedEntry<T> getFromRegistry(JsonElement json, Collection<TypedEntryType<?>> registry) throws ClassCastException {
        for (TypedEntryType<?> entryType : registry) {
            TypedEntryType<?> newType = entryType;
            TypedEntry<?> entry = this.getFromType(json, newType);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private <T> TypedEntry<T> getFromType(JsonElement json, TypedEntryType<T> entryType) throws ClassCastException {
        if (entryType.modId().equals(this.modId)) {
            return null;
        }
        Codec<T> codec = entryType.codec();
        DataResult result = codec.decode((DynamicOps)JanksonOps.INSTANCE, (Object)json);
        if (result.error().isPresent()) {
            return null;
        }
        Optional optional = result.result();
        if (optional.isEmpty()) {
            return null;
        }
        Pair pair = (Pair)optional.get();
        Object first = pair.getFirst();
        TypedEntry<Object> entry = TypedEntry.create(entryType, first);
        FrozenLibLogUtils.log("Built typed entry " + String.valueOf(entry), FrozenLibLogUtils.UNSTABLE_LOGGING);
        return entry;
    }
}

