/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.cape.impl.networking;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.impl.Cape;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class CapeCustomizePacket
implements class_8710 {
    private static final class_2960 DUMMY = FrozenLibConstants.id("dummy");
    public static final class_8710.class_9154<CapeCustomizePacket> PACKET_TYPE = new class_8710.class_9154(FrozenLibConstants.id("cape_packet"));
    public static final class_9139<class_2540, CapeCustomizePacket> CODEC = class_9139.method_56438(CapeCustomizePacket::write, CapeCustomizePacket::new);
    private final UUID playerUUID;
    private final boolean enabled;
    private class_2960 capeId = null;

    private CapeCustomizePacket(UUID uuid, boolean enabled) {
        this.playerUUID = uuid;
        this.enabled = enabled;
    }

    private CapeCustomizePacket(UUID uuid, boolean enabled, class_2960 capeId) {
        this(uuid, enabled);
        this.capeId = capeId;
    }

    public CapeCustomizePacket(class_2540 buf) {
        this(buf.method_10790(), buf.readBoolean());
        if (this.enabled) {
            this.capeId = buf.method_10810();
        }
    }

    public void write(class_2540 buf) {
        buf.method_10797(this.playerUUID);
        buf.method_52964(this.enabled);
        if (this.enabled) {
            buf.method_10812(this.capeId);
        }
    }

    public static CapeCustomizePacket createDisablePacket(UUID uuid) {
        return new CapeCustomizePacket(uuid, false);
    }

    public static CapeCustomizePacket createPacket(UUID uuid, @Nullable class_2960 capeId) {
        return new CapeCustomizePacket(uuid, !CapeCustomizePacket.shouldDisable(CapeUtil.getCape(capeId).orElse(null)), capeId);
    }

    @Contract(value="_, _ -> new")
    public static CapeCustomizePacket createPacket(UUID uuid, Cape cape) {
        return new CapeCustomizePacket(uuid, !CapeCustomizePacket.shouldDisable(cape), cape.id());
    }

    public static void sendCapeToAll(MinecraftServer server, UUID uuid, @Nullable class_2960 capeId) {
        CapeCustomizePacket capePacket = CapeCustomizePacket.createPacket(uuid, capeId);
        PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)capePacket));
    }

    public static boolean shouldDisable(Cape cape) {
        return cape == null || CapeCustomizePacket.shouldDisable(cape.id()) || cape.texture() == null;
    }

    public static boolean shouldDisable(class_2960 capeId) {
        return capeId == null || capeId.equals((Object)DUMMY);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public class_2960 getCapeId() {
        return this.capeId;
    }

    public class_8710.class_9154<?> method_56479() {
        return PACKET_TYPE;
    }
}

