/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.client.api.tick;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class BlockAnimateTicks {
    @ApiStatus.Internal
    private static final List<Pair<Predicate<class_2680>, InjectedAnimateTick>> ANIMATE_TICKS = new ArrayList<Pair<Predicate<class_2680>, InjectedAnimateTick>>();

    public static void addForBlockState(class_2680 state, InjectedAnimateTick animateTick) {
        BlockAnimateTicks.add(blockState -> blockState == state, animateTick);
    }

    public static void addForBlock(class_2248 block, InjectedAnimateTick animateTick) {
        BlockAnimateTicks.add(blockState -> blockState.method_27852(block), animateTick);
    }

    public static void addForBlockTag(class_6862<class_2248> tagKey, InjectedAnimateTick animateTick) {
        BlockAnimateTicks.add(blockState -> blockState.method_26164(tagKey), animateTick);
    }

    public static void addForBlockClass(Class<? extends class_2248> blockClass, InjectedAnimateTick animateTick) {
        BlockAnimateTicks.add(blockState -> blockState.method_26204().getClass().isInstance(blockClass), animateTick);
    }

    public static void addForExactBlockClass(Class<? extends class_2248> blockClass, InjectedAnimateTick animateTick) {
        BlockAnimateTicks.add(blockState -> blockState.method_26204().getClass().equals(blockClass), animateTick);
    }

    public static void add(Predicate<class_2680> predicate, InjectedAnimateTick animateTick) {
        ANIMATE_TICKS.add((Pair<Predicate<class_2680>, InjectedAnimateTick>)Pair.of(predicate, (Object)animateTick));
    }

    @ApiStatus.Internal
    public static void onAnimateTick(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        ANIMATE_TICKS.forEach(pair -> {
            if (((Predicate)pair.getFirst()).test(state)) {
                ((InjectedAnimateTick)pair.getSecond()).animateTick(state, level, pos, random);
            }
        });
    }

    @FunctionalInterface
    public static interface InjectedAnimateTick {
        public void animateTick(class_2680 var1, class_1937 var2, class_2338 var3, class_5819 var4);
    }
}

