/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.api.shape;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Unmodifiable;

public final class FrozenShapes {
    private static final class_265 UP_PLANE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 DOWN_PLANE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_265 WEST_PLANE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_PLANE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 NORTH_PLANE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 SOUTH_PLANE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final Map<class_2350, class_265> PLANE_BY_DIRECTION = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), shapes -> {
        shapes.put(class_2350.field_11043, NORTH_PLANE);
        shapes.put(class_2350.field_11034, EAST_PLANE);
        shapes.put(class_2350.field_11035, SOUTH_PLANE);
        shapes.put(class_2350.field_11039, WEST_PLANE);
        shapes.put(class_2350.field_11036, UP_PLANE);
        shapes.put(class_2350.field_11033, DOWN_PLANE);
    });

    public static class_265 makePlaneFromDirection(class_2350 direction, float width) {
        double minX = direction.equals((Object)class_2350.field_11034) ? (double)(16.0f - width) : 0.0;
        double minY = direction.equals((Object)class_2350.field_11036) ? (double)(16.0f - width) : 0.0;
        double minZ = direction.equals((Object)class_2350.field_11035) ? (double)(16.0f - width) : 0.0;
        double maxX = direction.equals((Object)class_2350.field_11039) ? (double)(0.0f + width) : 16.0;
        double maxY = direction.equals((Object)class_2350.field_11033) ? (double)(0.0f + width) : 16.0;
        double maxZ = direction.equals((Object)class_2350.field_11043) ? (double)(0.0f + width) : 16.0;
        return class_2248.method_9541((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static @Unmodifiable ImmutableMap<class_2350, class_265> createPlanesForDirection(float width) {
        Object2ObjectLinkedOpenHashMap planes = new Object2ObjectLinkedOpenHashMap();
        for (class_2350 direction : class_2350.values()) {
            planes.put(direction, FrozenShapes.makePlaneFromDirection(direction, width));
        }
        return Maps.immutableEnumMap((Map)planes);
    }

    public static Optional<class_243> closestPointTo(class_2338 originalPos, class_265 blockShape, class_243 point) {
        if (blockShape.method_1110()) {
            return Optional.empty();
        }
        double x = originalPos.method_10263();
        double y = originalPos.method_10264();
        double z = originalPos.method_10260();
        class_243[] vec3s = new class_243[1];
        blockShape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double clampedX = class_3532.method_15350((double)point.method_10216(), (double)(minX + x), (double)(maxX + x));
            double clampedY = class_3532.method_15350((double)point.method_10214(), (double)(minY + y), (double)(maxY + y));
            double clampedZ = class_3532.method_15350((double)point.method_10215(), (double)(minZ + z), (double)(maxZ + z));
            if (vec3s[0] == null || point.method_1028(clampedX, clampedY, clampedZ) < point.method_1025(vec3s[0])) {
                vec3s[0] = new class_243(clampedX, clampedY, clampedZ);
            }
        });
        return Optional.of(vec3s[0]);
    }

    @Generated
    private FrozenShapes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

