/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.api;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_10225;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5778;
import net.minecraft.class_5819;

public abstract class MultifaceClusterBlock
extends class_5778
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 UP = class_2741.field_12519;
    protected final class_265 northShape;
    protected final class_265 southShape;
    protected final class_265 eastShape;
    protected final class_265 westShape;
    protected final class_265 upShape;
    protected final class_265 downShape;
    private final Map<class_2350, class_265> shapeByDirection;
    private final Function<class_2680, class_265> shapesCache;

    public MultifaceClusterBlock(int height, int xzOffset, class_4970.class_2251 properties) {
        super(properties.method_50012(class_3619.field_15971));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.upShape = class_2248.method_9541((double)xzOffset, (double)0.0, (double)xzOffset, (double)(16.0 - (double)xzOffset), (double)height, (double)(16.0 - (double)xzOffset));
        this.downShape = class_2248.method_9541((double)xzOffset, (double)(16.0 - (double)height), (double)xzOffset, (double)(16.0 - (double)xzOffset), (double)16.0, (double)(16.0 - (double)xzOffset));
        this.northShape = class_2248.method_9541((double)xzOffset, (double)xzOffset, (double)(16.0 - (double)height), (double)(16.0 - (double)xzOffset), (double)(16.0 - (double)xzOffset), (double)16.0);
        this.southShape = class_2248.method_9541((double)xzOffset, (double)xzOffset, (double)0.0, (double)(16.0 - (double)xzOffset), (double)(16.0 - (double)xzOffset), (double)height);
        this.eastShape = class_2248.method_9541((double)0.0, (double)xzOffset, (double)xzOffset, (double)height, (double)(16.0 - (double)xzOffset), (double)(16.0 - (double)xzOffset));
        this.westShape = class_2248.method_9541((double)(16.0 - (double)height), (double)xzOffset, (double)xzOffset, (double)16.0, (double)(16.0 - (double)xzOffset), (double)(16.0 - (double)xzOffset));
        this.shapeByDirection = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), shapes -> {
            shapes.put(class_2350.field_11043, this.southShape);
            shapes.put(class_2350.field_11034, this.westShape);
            shapes.put(class_2350.field_11035, this.northShape);
            shapes.put(class_2350.field_11039, this.eastShape);
            shapes.put(class_2350.field_11036, this.downShape);
            shapes.put(class_2350.field_11033, this.upShape);
        });
        this.shapesCache = this.method_33615(this::calculateMultifaceShape);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return Objects.requireNonNull(this.shapesCache.apply(state));
    }

    public class_265 calculateMultifaceShape(class_2680 state) {
        class_265 shape = class_259.method_1073();
        for (class_2350 direction : field_28421) {
            if (!MultifaceClusterBlock.method_33366((class_2680)state, (class_2350)direction)) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)this.shapeByDirection.get(direction));
        }
        return shape.method_1110() ? class_259.method_1077() : shape;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 tickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return super.method_9559(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    protected boolean method_9579(class_2680 state) {
        return state.method_26227().method_15769();
    }
}

