/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.platform;

import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.client.FabricModData;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.exception.ModResourceNotFoundException;
import com.mrcrayfish.catalogue.platform.services.IPlatformHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1011;
import net.minecraft.class_11246;
import net.minecraft.class_332;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public List<IModData> getAllModData() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(FabricModData::new).collect(Collectors.toList());
    }

    @Override
    public File getModDirectory() {
        return FabricLoaderImpl.INSTANCE.getModsDirectory();
    }

    @Override
    public Path getConfigDirectory() {
        return FabricLoaderImpl.INSTANCE.getConfigDir();
    }

    @Override
    public class_1011 loadImageFromModResource(String modId, String resource) throws ModResourceNotFoundException {
        return FabricLoader.getInstance().getModContainer(modId).flatMap(c -> c.findPath(resource)).map(path -> {
            class_1011 class_10112;
            block8: {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                try {
                    class_10112 = class_1011.method_4309((InputStream)is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Constants.LOG.error("Failed to load image resource '{}' from mod {}", new Object[]{resource, modId, e});
                        return null;
                    }
                }
                is.close();
            }
            return class_10112;
        }).orElseThrow(ModResourceNotFoundException::new);
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public class_11246 getGuiRenderState(class_332 graphics) {
        return graphics.field_59826;
    }
}

