/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen.widget;

import com.mrcrayfish.catalogue.client.screen.DropdownMenuHandler;
import com.mrcrayfish.catalogue.client.screen.layout.BorderedLinearLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8666;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class DropdownMenu
extends class_339 {
    private final DropdownMenuHandler handler;
    private final BorderedLinearLayout layout = (BorderedLinearLayout)BorderedLinearLayout.vertical().border(1).method_52735(1);
    private final List<class_339> items = new ArrayList<class_339>();
    private Alignment alignment = Alignment.BELOW_LEFT;
    @Nullable
    private DropdownMenu parent;
    @Nullable
    private DropdownMenu subMenu;

    private DropdownMenu(DropdownMenuHandler handler) {
        super(0, 0, 0, 0, class_5244.field_39003);
        this.handler = handler;
        this.field_22764 = false;
    }

    private void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void toggle(int mouseX, int mouseY) {
        this.toggle(new class_8030(mouseX, mouseY, 0, 0));
    }

    public void toggle(class_339 widget) {
        this.toggle(widget.method_48202());
    }

    public void toggle(class_8030 rect) {
        if (!this.field_22764) {
            this.show(rect);
        } else {
            this.hide();
        }
    }

    private void show(class_8030 rect) {
        this.updatePosition(rect);
        this.items.forEach(child -> {
            child.field_22764 = true;
        });
        this.field_22764 = true;
        if (this.parent == null) {
            this.handler.setMenu(this);
        }
    }

    public void hide() {
        this.items.forEach(child -> {
            child.field_22764 = false;
            if (child instanceof DropdownItem) {
                DropdownItem menu = (DropdownItem)((Object)child);
                menu.subMenu.hide();
            }
        });
        this.subMenu = null;
        this.field_22764 = false;
    }

    private void updatePosition(class_8030 rect) {
        this.layout.method_48222();
        this.field_22758 = this.layout.method_25368();
        this.field_22759 = this.layout.method_25364();
        this.alignment.aligner.accept(this, rect);
        this.layout.method_46421(this.method_46426());
        this.layout.method_46419(this.method_46427());
    }

    public void addItem(MenuItem item) {
        this.layout.method_52736((class_8021)item);
        this.items.add(item);
        item.field_22764 = false;
    }

    private void deepClose() {
        this.handler.setMenu(null);
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        graphics.method_51448().pushMatrix();
        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        graphics.method_25294(0, 0, window.method_4489(), window.method_4506(), 0x50000000);
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -1442840576);
        this.items.forEach(widget -> widget.method_25394(graphics, mouseX, mouseY, deltaTick));
        if (this.subMenu != null) {
            this.subMenu.method_25394(graphics, mouseX, mouseY, deltaTick);
        }
        graphics.method_51448().pushMatrix();
    }

    protected void method_47399(class_6382 output) {
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        AtomicBoolean clicked = new AtomicBoolean();
        this.layout.method_48206(widget -> {
            if (widget.method_25402(event, doubleClick)) {
                clicked.set(true);
            }
        });
        return clicked.get();
    }

    public void method_48206(Consumer<class_339> consumer) {
        this.layout.method_48206(consumer);
    }

    public static Builder builder(DropdownMenuHandler handler) {
        return new Builder(handler);
    }

    public static enum Alignment {
        ABOVE_LEFT((menu, rectangle) -> {
            menu.method_46421(rectangle.method_49620());
            menu.method_46419(rectangle.method_49618() - menu.method_25364());
        }),
        ABOVE_RIGHT((menu, rectangle) -> {
            menu.method_46421(rectangle.method_49621() - menu.method_25368());
            menu.method_46419(rectangle.method_49618() - menu.method_25364());
        }),
        BELOW_LEFT((menu, rectangle) -> {
            menu.method_46421(rectangle.method_49620() - 1);
            menu.method_46419(rectangle.method_49619());
        }),
        BELOW_RIGHT((menu, rectangle) -> {
            menu.method_46421(rectangle.method_49621() - menu.method_25368() + 1);
            menu.method_46419(rectangle.method_49619());
        }),
        END_TOP((menu, rectangle) -> {
            menu.method_46421(rectangle.method_49621());
            menu.method_46419(rectangle.method_49618() - 1);
        }),
        END_BOTTOM((menu, rectangle) -> {
            menu.method_46421(rectangle.method_49621());
            menu.method_46419(rectangle.method_49619() - menu.method_25364() + 1);
        });

        private final MenuAligner aligner;

        private Alignment(MenuAligner positioner) {
            this.aligner = positioner;
        }
    }

    private static interface MenuAligner {
        public void accept(DropdownMenu var1, class_8030 var2);
    }

    public static class MenuItem
    extends class_339 {
        protected static final class_8666 SPRITES = new class_8666(class_2960.method_60655((String)"catalogue", (String)"dropdown/item"), class_2960.method_60655((String)"catalogue", (String)"dropdown/item_highlighted"));
        protected final DropdownMenu parent;
        private final Runnable onClick;

        public MenuItem(DropdownMenu menu, class_2561 label, Runnable onClick) {
            super(0, 0, 100, 20, label);
            this.parent = menu;
            this.onClick = onClick;
        }

        protected boolean selected() {
            return false;
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
            graphics.method_52706(class_10799.field_56883, SPRITES.method_52729(this.field_22763, this.method_49606() || this.selected()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            class_327 font = class_310.method_1551().field_1772;
            int n = this.method_25364();
            Objects.requireNonNull(font);
            int offset = (n - 9) / 2 + 1;
            graphics.method_27535(class_310.method_1551().field_1772, this.method_25369(), this.method_46426() + offset, this.method_46427() + offset, -1);
        }

        public void method_25348(class_11909 event, boolean doubleClick) {
            this.onClick.run();
            this.parent.deepClose();
        }

        protected void method_47399(class_6382 output) {
            output.method_37034(class_6381.field_33788, this.method_25369());
        }

        protected int calculateWidth() {
            class_327 font = class_310.method_1551().field_1772;
            int n = this.method_25364();
            Objects.requireNonNull(font);
            int labelOffset = (n - 9) / 2 + 1;
            int labelWidth = font.method_27525((class_5348)this.method_25369());
            return labelOffset + labelWidth + labelOffset;
        }
    }

    public static class Builder {
        private final DropdownMenuHandler handler;
        private final DropdownMenu base;
        private final List<MenuItem> items = new ArrayList<MenuItem>();
        private int minItemWidth = 0;
        private int minItemHeight = 20;

        private Builder(DropdownMenuHandler handler) {
            this.handler = handler;
            this.base = new DropdownMenu(handler);
        }

        public Builder setMinItemSize(int width, int height) {
            this.minItemWidth = width;
            this.minItemHeight = height;
            return this;
        }

        public Builder setAlignment(Alignment alignment) {
            this.base.setAlignment(alignment);
            return this;
        }

        public Builder addItem(class_2561 label, Runnable onClick) {
            this.items.add(new MenuItem(this.base, label, onClick));
            return this;
        }

        public Builder addCheckbox(class_2561 label, MutableBoolean holder, Function<Boolean, Boolean> callback) {
            this.items.add(new CheckboxMenuItem(this.base, label, holder, callback));
            return this;
        }

        public Builder addMenu(class_2561 label, Builder builder) {
            DropdownMenu menu = builder.build();
            menu.parent = this.base;
            this.items.add(new DropdownItem(this.base, menu, label));
            return this;
        }

        public DropdownMenu build() {
            int maxWidth = this.items.stream().mapToInt(MenuItem::calculateWidth).max().orElse(100);
            this.items.forEach(widget -> {
                widget.method_55445(Math.max(maxWidth, this.minItemWidth), this.minItemHeight);
                this.base.addItem((MenuItem)((Object)widget));
            });
            return this.base;
        }
    }

    private static class DropdownItem
    extends MenuItem {
        private final DropdownMenu subMenu;

        public DropdownItem(DropdownMenu menu, DropdownMenu subMenu, class_2561 label) {
            super(menu, label, () -> {});
            this.subMenu = subMenu;
        }

        @Override
        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
            super.method_48579(graphics, mouseX, mouseY, deltaTick);
            class_327 font = class_310.method_1551().field_1772;
            int n = this.method_46427();
            int n2 = this.method_25364();
            Objects.requireNonNull(font);
            int top = n + (n2 - 9) / 2 + 1;
            graphics.method_25303(class_310.method_1551().field_1772, ">", this.method_46426() + this.method_25368() - 10, top, -1);
        }

        @Override
        public void method_25348(class_11909 event, boolean doubleClick) {
            if (this.parent.subMenu != null) {
                this.parent.subMenu.hide();
                if (this.parent.subMenu == this.subMenu) {
                    this.parent.subMenu = null;
                    return;
                }
            }
            this.parent.subMenu = this.subMenu;
            this.subMenu.show(this.method_48202());
        }

        public void method_48206(Consumer<class_339> consumer) {
            consumer.accept(this);
            this.subMenu.method_48206(consumer);
        }

        @Override
        protected boolean selected() {
            return this.parent.subMenu == this.subMenu;
        }

        @Override
        protected int calculateWidth() {
            class_327 font = class_310.method_1551().field_1772;
            int n = this.method_25364();
            Objects.requireNonNull(font);
            int labelOffset = (n - 9) / 2 + 1;
            int labelWidth = font.method_27525((class_5348)this.method_25369());
            int arrowWidth = font.method_1727(">");
            return labelOffset + labelWidth + labelOffset + arrowWidth + labelOffset;
        }
    }

    private static class CheckboxMenuItem
    extends MenuItem {
        private static final class_2960 TEXTURE = class_2960.method_60655((String)"catalogue", (String)"textures/gui/checkbox.png");
        private final MutableBoolean holder;
        private final Function<Boolean, Boolean> callback;

        public CheckboxMenuItem(DropdownMenu menu, class_2561 label, MutableBoolean holder, Function<Boolean, Boolean> callback) {
            super(menu, label, () -> {});
            this.holder = holder;
            this.callback = callback;
        }

        @Override
        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
            super.method_48579(graphics, mouseX, mouseY, deltaTick);
            int offset = (this.method_25364() - 14) / 2;
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426() + this.method_25368() - 14 - offset, this.method_46427() + offset, this.method_25367() ? 14.0f : 0.0f, this.holder.getValue() != false ? 14.0f : 0.0f, 14, 14, 64, 64);
        }

        @Override
        public void method_25348(class_11909 event, boolean doubleClick) {
            boolean newValue = this.holder.getValue() == false;
            this.holder.setValue(newValue);
            if (this.callback.apply(newValue).booleanValue()) {
                this.parent.deepClose();
            }
        }

        @Override
        protected int calculateWidth() {
            class_327 font = class_310.method_1551().field_1772;
            int n = this.method_25364();
            Objects.requireNonNull(font);
            int labelOffset = (n - 9) / 2 + 1;
            int labelWidth = font.method_27525((class_5348)this.method_25369());
            int checkboxOffset = (this.method_25364() - 14) / 2;
            return labelOffset + labelWidth + labelOffset + 14 + checkboxOffset;
        }
    }
}

