/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.Utils;
import com.mrcrayfish.catalogue.client.Branding;
import com.mrcrayfish.catalogue.client.ClientHelper;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.client.ImageInfo;
import com.mrcrayfish.catalogue.client.screen.BackgroundRenderState;
import com.mrcrayfish.catalogue.client.screen.DropdownMenuHandler;
import com.mrcrayfish.catalogue.client.screen.MinecraftModData;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import com.mrcrayfish.catalogue.client.screen.widget.DropdownMenu;
import com.mrcrayfish.catalogue.platform.ClientServices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11244;
import net.minecraft.class_11246;
import net.minecraft.class_1144;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_12137;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8020;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class CatalogueModListScreen
extends class_437
implements DropdownMenuHandler {
    private static final Favourites FAVOURITES = new Favourites();
    private static final Comparator<ModListEntry> SORT_ALPHABETICALLY = Comparator.comparing(o -> o.getData().getDisplayName());
    private static final Comparator<ModListEntry> SORT_ALPHABETICALLY_REVERSED = SORT_ALPHABETICALLY.reversed();
    private static final Comparator<ModListEntry> SORT_FAVOURITES_FIRST = Comparator.comparing(ModListEntry::getData, Comparator.comparing(data -> FAVOURITES.has(data.getModId()))).reversed().thenComparing(SORT_ALPHABETICALLY);
    private static final MutableObject<String> OPTION_QUERY = new MutableObject((Object)"");
    private static final MutableBoolean OPTION_HIDE_LIBRARIES = new MutableBoolean(true);
    private static final MutableBoolean OPTION_CONFIGS_ONLY = new MutableBoolean(false);
    private static final MutableBoolean OPTION_UPDATES_ONLY = new MutableBoolean(false);
    private static final MutableBoolean OPTION_FAVOURITES_ONLY = new MutableBoolean(false);
    private static final MutableObject<Comparator<ModListEntry>> OPTION_SORT = new MutableObject(SORT_ALPHABETICALLY);
    private static final class_2960 MISSING_BANNER = Utils.resource("textures/gui/missing_banner.png");
    private static final class_2960 MISSING_BACKGROUND = Utils.resource("textures/gui/missing_background.png");
    private static final ImageInfo MISSING_BANNER_INFO = new ImageInfo(MISSING_BANNER, 120, 120, () -> {});
    private static final Map<String, ImageInfo> BANNER_CACHE = new HashMap<String, ImageInfo>();
    private static final Map<String, ImageInfo> IMAGE_ICON_CACHE = new HashMap<String, ImageInfo>();
    private static final Map<String, class_1792> ITEM_ICON_CACHE = new HashMap<String, class_1792>();
    private static final Map<String, IModData> CACHED_MODS = new HashMap<String, IModData>();
    private static final Pattern MOD_ID_PATTERN = Pattern.compile("^[a-z][a-z0-9_]{1,63}$");
    private static final Supplier<Pair<Integer, Integer>> COUNTS = Suppliers.memoize(() -> {
        int[] counts = new int[2];
        CACHED_MODS.forEach((modId, data) -> {
            int n = data.isLibrary() ? 1 : 0;
            counts[n] = counts[n] + 1;
        });
        return Pair.of((Object)counts[0], (Object)counts[1]);
    });
    private static final Map<String, SearchFilter> SEARCH_FILTERS = ImmutableMap.builder().put((Object)"dependencies", (Object)new SearchFilter((query, data) -> {
        IModData target = CACHED_MODS.get(query.toLowerCase(Locale.ENGLISH));
        return target != null && target.getDependencies().contains(data.getModId());
    })).put((Object)"dependents", (Object)new SearchFilter((query, data) -> data.getDependencies().contains(query.toLowerCase(Locale.ENGLISH)))).build();
    private static final class_2583 SEARCH_FILTER_KEY = class_2583.field_24360.method_10977(class_124.field_1065);
    private static final class_2583 SEARCH_FILTER_VALUE = class_2583.field_24360.method_10977(class_124.field_1068);
    private static ImageInfo cachedBackground;
    private static boolean loaded;
    private final class_437 parentScreen;
    private class_4185 optionsButton;
    private class_342 searchTextField;
    private ModList modList;
    private IModData selectedModData;
    private class_4185 modFolderButton;
    private class_4185 configButton;
    private class_4185 websiteButton;
    private class_4185 issueButton;
    private StringList descriptionList;
    @Nullable
    private DropdownMenu menu;

    public CatalogueModListScreen(class_437 parent) {
        super(class_5244.field_39003);
        this.parentScreen = parent;
        if (!loaded) {
            ClientServices.PLATFORM.getAllModData().forEach(data -> CACHED_MODS.put(data.getModId(), (IModData)data));
            CACHED_MODS.put("minecraft", new MinecraftModData());
            BANNER_CACHE.put("minecraft", new ImageInfo(class_8020.field_41805, 1024, 256, () -> {}));
            FAVOURITES.load();
            loaded = true;
        }
    }

    @Override
    public void setMenu(@Nullable DropdownMenu menu) {
        if (this.menu != null && this.menu != menu) {
            this.menu.hide();
        }
        this.menu = menu;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    protected void method_25426() {
        super.method_25426();
        this.searchTextField = new class_342(this, this.field_22793, 10, 25, 150, 20, class_5244.field_39003){

            public int method_1859() {
                if (this.method_1882().startsWith("@")) {
                    return super.method_1859() - 16;
                }
                return super.method_1859();
            }
        };
        this.searchTextField.method_73210(this::formatQuery);
        this.searchTextField.method_1880(128);
        this.searchTextField.method_1852((String)OPTION_QUERY.getValue());
        this.searchTextField.method_1863(s -> {
            if (!((String)OPTION_QUERY.getValue()).equals(s)) {
                OPTION_QUERY.setValue(s);
                this.updateSearchFieldSuggestion((String)s);
                this.modList.filterAndUpdateList();
                this.updateSelectedModList();
            }
        });
        this.method_25429((class_364)this.searchTextField);
        this.modList = new ModList();
        this.modList.method_46421(10);
        this.method_25429((class_364)this.modList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, btn -> this.field_22787.method_1507(this.parentScreen)).method_46433(10, this.modList.method_55443() + 8).method_46437(127, 20).method_46431());
        this.modFolderButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(140, this.modList.method_55443() + 8, 0, 0, onPress -> class_156.method_668().method_672(ClientServices.PLATFORM.getModDirectory())));
        int padding = 10;
        int contentLeft = this.modList.method_55442() + 12 + padding;
        int contentWidth = this.field_22789 - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (class_2561)class_2561.method_43471((String)"catalogue.gui.config"), onPress -> {
            if (this.selectedModData != null) {
                this.selectedModData.openConfigScreen(this);
            }
        }));
        this.configButton.field_22764 = false;
        this.websiteButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (class_2561)class_2561.method_43471((String)"catalogue.gui.website"), onPress -> this.openLink(this.selectedModData.getHomepage())));
        this.websiteButton.field_22764 = false;
        this.issueButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (class_2561)class_2561.method_43471((String)"catalogue.gui.submit_bug"), onPress -> this.openLink(this.selectedModData.getIssueTracker())));
        this.issueButton.field_22764 = false;
        this.descriptionList = new StringList(contentWidth + padding * 2, 50, contentLeft - padding, 130);
        this.descriptionList.field_22764 = false;
        this.method_25429((class_364)this.descriptionList);
        DropdownMenu menu = DropdownMenu.builder(this).setMinItemSize(100, 16).setAlignment(DropdownMenu.Alignment.BELOW_RIGHT).addMenu((class_2561)class_2561.method_43471((String)"catalogue.gui.filters"), DropdownMenu.builder(this).setMinItemSize(60, 16).setAlignment(DropdownMenu.Alignment.END_TOP).addCheckbox((class_2561)class_2561.method_43471((String)"catalogue.gui.filters.configs_only"), OPTION_CONFIGS_ONLY, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        }).addCheckbox((class_2561)class_2561.method_43471((String)"catalogue.gui.filters.updates_only"), OPTION_UPDATES_ONLY, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        }).addCheckbox((class_2561)class_2561.method_43471((String)"catalogue.gui.filters.favourites"), OPTION_FAVOURITES_ONLY, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        })).addMenu((class_2561)class_2561.method_43471((String)"catalogue.gui.sort"), DropdownMenu.builder(this).setMinItemSize(60, 16).setAlignment(DropdownMenu.Alignment.END_TOP).addItem((class_2561)class_2561.method_43471((String)"catalogue.gui.sort.alphabetically"), () -> {
            OPTION_SORT.setValue(SORT_ALPHABETICALLY);
            this.modList.filterAndUpdateList();
        }).addItem((class_2561)class_2561.method_43471((String)"catalogue.gui.sort.alphabetically_reverse"), () -> {
            OPTION_SORT.setValue(SORT_ALPHABETICALLY_REVERSED);
            this.modList.filterAndUpdateList();
        }).addItem((class_2561)class_2561.method_43471((String)"catalogue.gui.sort.favourites_first"), () -> {
            OPTION_SORT.setValue(SORT_FAVOURITES_FIRST);
            this.modList.filterAndUpdateList();
        })).addCheckbox((class_2561)class_2561.method_43471((String)"catalogue.gui.hide_libraries"), OPTION_HIDE_LIBRARIES, newValue -> {
            this.modList.filterAndUpdateList();
            return false;
        }).build();
        this.optionsButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(this.modList.method_55442() - 16, 6, 40, 0, 16, 16, btn -> menu.toggle(btn.method_48202())));
        this.modList.filterAndUpdateList();
        if (this.selectedModData != null) {
            this.setSelectedModData(this.selectedModData);
            this.updateSelectedModList();
            ModListEntry entry = this.modList.getEntryFromInfo(this.selectedModData);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchFieldSuggestion(this.searchTextField.method_1882());
    }

    private void openLink(@Nullable String url) {
        if (url != null) {
            class_407.method_60866((class_437)this, (String)url, (boolean)false);
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(graphics, mouseX, mouseY, partialTick);
        this.drawModList(graphics, mouseX, mouseY, partialTick);
        this.drawModInfo(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        boolean inMenu = this.menu != null;
        super.method_25394(graphics, inMenu ? -1000 : mouseX, inMenu ? -1000 : mouseY, partialTicks);
        if (((String)OPTION_QUERY.getValue()).startsWith("@")) {
            int iconX = this.searchTextField.method_46426() + this.searchTextField.method_25368() - 15;
            int iconY = this.searchTextField.method_46427() + (this.searchTextField.method_25364() - 10) / 2;
            graphics.method_25290(class_10799.field_56883, CatalogueIconButton.TEXTURE, iconX, iconY, 20.0f, 10.0f, 10, 10, 64, 64);
            if (this.menu == null && ClientHelper.isMouseWithin(iconX, iconY, 10, 10, mouseX, mouseY)) {
                graphics.method_71276((class_2561)class_2561.method_43471((String)"catalogue.gui.advanced_search.info"), mouseX, mouseY);
            }
        }
        Optional<IModData> optional = Optional.ofNullable(CACHED_MODS.get("catalogue"));
        optional.ifPresent(this::loadAndCacheLogo);
        ImageInfo bannerInfo = BANNER_CACHE.get("catalogue");
        if (bannerInfo != null) {
            graphics.method_25302(class_10799.field_56883, bannerInfo.resource(), 10, 9, 0.0f, 0.0f, 10, 10, bannerInfo.width(), bannerInfo.height(), bannerInfo.width(), bannerInfo.height());
        }
        if (this.menu != null) {
            this.menu.method_25394(graphics, mouseX, mouseY, partialTicks);
        } else {
            if (ClientHelper.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
                this.setTooltip(graphics, (class_2561)class_2561.method_43471((String)"catalogue.gui.info"), mouseX, mouseY + 10);
            }
            if (this.optionsButton.method_25405((double)mouseX, (double)mouseY)) {
                this.setTooltip(graphics, (class_2561)class_2561.method_43471((String)"catalogue.gui.options"), mouseX, mouseY + 10);
            }
            if (this.modFolderButton.method_25405((double)mouseX, (double)mouseY)) {
                this.setTooltip(graphics, (class_2561)class_2561.method_43471((String)"catalogue.gui.open_mods_folder"), mouseX, mouseY);
            }
        }
    }

    public void method_25432() {
        FAVOURITES.save();
    }

    private void setTooltip(class_332 graphics, class_2561 message, int mouseX, int mouseY) {
        graphics.method_71274(this.field_22793.method_1728((class_5348)message, Math.min(200, this.field_22789)), mouseX, mouseY);
    }

    private void updateSelectedModList() {
        ModListEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModData);
        if (selectedEntry != null) {
            this.modList.method_25313((class_350.class_351)selectedEntry);
        }
    }

    private void updateSearchFieldSuggestion(String value) {
        if (value.isEmpty()) {
            this.searchTextField.method_1887(class_2561.method_43471((String)"catalogue.gui.search").method_10852((class_2561)class_2561.method_43470((String)"...")).getString());
        } else if (value.startsWith("@")) {
            int end = value.indexOf(":");
            if (end != -1) {
                String type = value.substring(1, end);
                Optional<String> optional = SEARCH_FILTERS.keySet().stream().filter(filter -> filter.startsWith(type.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(String::length));
                if (optional.isPresent()) {
                    int length = type.length();
                    this.searchTextField.method_1887(optional.get().substring(length));
                } else {
                    this.searchTextField.method_1887("");
                }
            } else {
                this.searchTextField.method_1887("");
            }
        } else {
            Optional<IModData> optional = CACHED_MODS.values().stream().filter(data -> data.getDisplayName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(IModData::getDisplayName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getDisplayName();
                this.searchTextField.method_1887(displayName.substring(length));
            } else {
                this.searchTextField.method_1887("");
            }
        }
    }

    private void drawModList(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.modList.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(graphics, mouseX, mouseY, partialTicks);
        class_5250 modsLabel = ClientServices.COMPONENT.createTitle().method_27692(class_124.field_1067).method_27692(class_124.field_1068);
        class_5250 countLabel = class_2561.method_43470((String)("(" + CACHED_MODS.size() + ")")).method_27692(class_124.field_1080);
        class_5250 title = class_2561.method_43473().method_10852((class_2561)modsLabel).method_27693(" ").method_10852((class_2561)countLabel);
        int titleWidth = this.field_22793.method_27525((class_5348)title);
        int titleLeft = this.modList.method_46426() + (this.modList.method_25368() - titleWidth) / 2;
        graphics.method_27535(this.field_22793, (class_2561)title, titleLeft, 10, -1);
        int countLabelWidth = this.field_22793.method_27525((class_5348)countLabel);
        Objects.requireNonNull(this.field_22793);
        if (ClientHelper.isMouseWithin(titleLeft + titleWidth - countLabelWidth, 10, countLabelWidth, 9, mouseX, mouseY)) {
            Pair<Integer, Integer> counts = COUNTS.get();
            List<class_5481> lines = List.of(class_2561.method_43469((String)"catalogue.gui.mod_count", (Object[])new Object[]{counts.getLeft()}).method_30937(), class_2561.method_43469((String)"catalogue.gui.library_count", (Object[])new Object[]{counts.getRight()}).method_30937());
            graphics.method_71274(lines, mouseX, mouseY + 10);
        }
    }

    private void drawModInfo(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int listRight = this.modList.method_55442();
        graphics.method_51742(listRight + 11, -1, this.field_22790, -9408400);
        graphics.method_25294(listRight + 12, 0, this.field_22789, this.field_22790, 0x66000000);
        this.descriptionList.method_25394(graphics, mouseX, mouseY, partialTicks);
        int contentLeft = listRight + 12 + 10;
        int contentWidth = this.field_22789 - contentLeft - 10;
        if (this.selectedModData != null) {
            String authors;
            String credits;
            this.drawBackground(graphics, this.field_22789 - contentLeft + 10, listRight + 12, 0);
            this.drawBanner(graphics, contentWidth, contentLeft, 10, this.field_22789 - (listRight + 12 + 10) - 10, 50);
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate((float)contentLeft, 70.0f);
            graphics.method_51448().scale(2.0f, 2.0f);
            graphics.method_25303(this.field_22793, this.selectedModData.getDisplayName(), 0, 0, -1);
            graphics.method_51448().popMatrix();
            class_5250 modId = class_2561.method_43470((String)("Mod ID: " + this.selectedModData.getModId())).method_27692(class_124.field_1063);
            int modIdWidth = this.field_22793.method_27525((class_5348)modId);
            graphics.method_27535(this.field_22793, (class_2561)modId, contentLeft + contentWidth - modIdWidth, 92, -1);
            this.drawStringWithLabel(graphics, "catalogue.gui.version", this.selectedModData.getVersion().toString(), contentLeft, 92, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            IModData.Update update = this.selectedModData.getUpdate();
            if (update != null && update.url() != null && !update.url().isBlank()) {
                class_5250 version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion());
                int versionWidth = this.field_22793.method_27525((class_5348)version);
                this.selectedModData.drawUpdateIcon(graphics, update, contentLeft + versionWidth + 5, 92);
                if (ClientHelper.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    class_5250 message = ClientServices.COMPONENT.createFormatted("catalogue.gui.update_available", update.url());
                    this.setTooltip(graphics, (class_2561)message, mouseX, mouseY);
                }
            }
            graphics.method_25296(listRight + 12, this.field_22790 - 50, this.field_22789, this.field_22790, 0, 0x66000000);
            int labelOffset = this.field_22790 - 18;
            String license = this.selectedModData.getLicense();
            if (!license.isBlank()) {
                this.drawStringWithLabel(graphics, "catalogue.gui.licenses", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
                labelOffset -= 15;
            }
            if ((credits = this.selectedModData.getCredits()) != null && !credits.isBlank()) {
                this.drawStringWithLabel(graphics, ClientServices.COMPONENT.getCreditsKey(), credits, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
                labelOffset -= 15;
            }
            if ((authors = this.selectedModData.getAuthors()) != null && !authors.isBlank()) {
                this.drawStringWithLabel(graphics, "catalogue.gui.authors", authors, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            }
        } else {
            class_5250 message = class_2561.method_43471((String)"catalogue.gui.no_selection").method_27692(class_124.field_1080);
            graphics.method_27534(this.field_22793, (class_2561)message, contentLeft + contentWidth / 2, this.field_22790 / 2 - 5, 0xFFFFFF);
        }
    }

    private void drawStringWithLabel(class_332 graphics, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, class_124 labelColor, class_124 contentColor) {
        class_5250 formatted = ClientServices.COMPONENT.createFormatted(format, text);
        String rawString = formatted.getString();
        String label = rawString.substring(0, rawString.indexOf(":") + 1);
        Object content = rawString.substring(rawString.indexOf(":") + 1);
        if (this.field_22793.method_27525((class_5348)formatted) > maxWidth) {
            content = this.field_22793.method_27523((String)content, maxWidth - this.field_22793.method_1727(label) - 7) + "...";
            class_5250 credits = class_2561.method_43470((String)label).method_27692(labelColor);
            credits.method_10852((class_2561)class_2561.method_43470((String)content).method_27692(contentColor));
            graphics.method_27535(this.field_22793, (class_2561)credits, x, y, -1);
            if (ClientHelper.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setTooltip(graphics, (class_2561)class_2561.method_43470((String)text), mouseX, mouseY);
            }
        } else {
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)label).method_27692(labelColor).method_10852((class_2561)class_2561.method_43470((String)content).method_27692(contentColor)), x, y, -1);
        }
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        IModData.Update update;
        class_5250 version;
        int versionWidth;
        int contentLeft;
        if (this.menu != null) {
            if (!this.menu.method_25402(event, doubleClick)) {
                this.setMenu(null);
            }
            return true;
        }
        if (ClientHelper.isMouseWithin(10, 9, 10, 10, (int)event.comp_4798(), (int)event.comp_4799()) && event.method_74245() == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        if (this.selectedModData != null && ClientHelper.isMouseWithin((contentLeft = this.modList.method_55442() + 12 + 10) + (versionWidth = this.field_22793.method_27525((class_5348)(version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion())))) + 5, 92, 8, 8, (int)event.comp_4798(), (int)event.comp_4799()) && (update = this.selectedModData.getUpdate()) != null && update.url() != null && !update.url().isBlank()) {
            this.openLink(update.url());
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 70 && event.method_74240()) {
            if (!this.searchTextField.method_25370()) {
                this.method_25395((class_364)this.searchTextField);
                this.searchTextField.method_1872(false);
                this.searchTextField.method_1884(0);
            }
            return true;
        }
        return super.method_25404(event);
    }

    private void setSelectedModData(IModData data) {
        this.selectedModData = data;
        this.loadAndCacheLogo(data);
        this.reloadBackground(data);
        this.configButton.field_22764 = true;
        this.websiteButton.field_22764 = true;
        this.issueButton.field_22764 = true;
        this.configButton.field_22763 = data.hasConfig();
        this.websiteButton.field_22763 = data.getHomepage() != null;
        this.issueButton.field_22763 = data.getIssueTracker() != null;
        int contentLeft = this.modList.method_55442() + 12 + 10;
        int contentWidth = this.field_22789 - contentLeft - 10;
        int labelCount = this.getFooterTextElementCount(data);
        this.descriptionList.method_25358(contentWidth);
        this.descriptionList.method_53533(this.field_22790 - 135 - labelCount * 15 - 9);
        this.descriptionList.method_46421(contentLeft);
        this.descriptionList.setTextFromInfo(data);
        this.descriptionList.method_44382(0.0);
    }

    private int getFooterTextElementCount(IModData data) {
        int count = 1;
        if (data.getCredits() != null && !data.getCredits().isBlank()) {
            ++count;
        }
        if (data.getAuthors() != null && !data.getAuthors().isBlank()) {
            ++count;
        }
        return count;
    }

    private void drawBackground(class_332 graphics, int contentWidth, int contentLeft, int contentTop) {
        if (this.selectedModData == null) {
            return;
        }
        class_2960 textureRef = cachedBackground != null ? cachedBackground.resource() : MISSING_BACKGROUND;
        class_11246 state = ClientServices.PLATFORM.getGuiRenderState(graphics);
        GpuTextureView gpuTexture = this.field_22787.method_1531().method_4619(textureRef).method_71659();
        class_11241 blit = new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTexture, (class_12137)RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR)), new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), contentLeft, contentTop, contentLeft + contentWidth, contentTop + 128, 0.0f, 1.0f, 0.0f, 1.0f, -1, null);
        state.method_70919((class_11244)new BackgroundRenderState(blit));
    }

    private void drawBanner(class_332 graphics, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModData != null) {
            ImageInfo info = this.getBanner(this.selectedModData.getModId());
            int displayWidth = info.width();
            int displayHeight = info.height();
            if (info.width() > maxWidth) {
                displayWidth = maxWidth;
                displayHeight = displayWidth * info.height() / info.width();
            }
            if (displayHeight > maxHeight) {
                displayHeight = maxHeight;
                displayWidth = displayHeight * info.width() / info.height();
            }
            x += (contentWidth - displayWidth) / 2;
            y += (maxHeight - displayHeight) / 2;
            if (info.resource() == class_8020.field_41805) {
                y += 8;
            }
            graphics.method_25302(class_10799.field_56883, info.resource(), x, y, 0.0f, 0.0f, displayWidth, displayHeight, info.width(), info.height(), info.width(), info.height());
        }
    }

    private ImageInfo getBanner(String modId) {
        ImageInfo bannerInfo = BANNER_CACHE.get(modId);
        if (bannerInfo != null) {
            return bannerInfo;
        }
        ImageInfo iconInfo = IMAGE_ICON_CACHE.get(modId);
        if (iconInfo != null) {
            int expandedWidth = iconInfo.width() * 10;
            int expandedHeight = iconInfo.height() * 10;
            return new ImageInfo(iconInfo.resource(), expandedWidth, expandedHeight, iconInfo.unregister());
        }
        return MISSING_BANNER_INFO;
    }

    private void loadAndCacheLogo(IModData data) {
        if (BANNER_CACHE.containsKey(data.getModId())) {
            return;
        }
        BANNER_CACHE.put(data.getModId(), null);
        Branding.BANNER.loadResource(data).ifPresent(info -> BANNER_CACHE.put(data.getModId(), (ImageInfo)info));
    }

    private void loadAndCacheIcon(IModData data) {
        if (IMAGE_ICON_CACHE.containsKey(data.getModId())) {
            return;
        }
        IMAGE_ICON_CACHE.put(data.getModId(), null);
        Branding.ICON.loadResource(data).ifPresentOrElse(info -> IMAGE_ICON_CACHE.put(data.getModId(), (ImageInfo)info), () -> {
            ImageInfo bannerInfo = BANNER_CACHE.get(data.getModId());
            if (bannerInfo != null) {
                if (bannerInfo.width() == bannerInfo.height()) {
                    IMAGE_ICON_CACHE.put(data.getModId(), bannerInfo);
                }
            } else {
                Branding.BANNER.loadResource(data).ifPresent(info -> {
                    if (info.width() == info.height()) {
                        IMAGE_ICON_CACHE.put(data.getModId(), (ImageInfo)info);
                        BANNER_CACHE.put(data.getModId(), (ImageInfo)info);
                    } else {
                        info.unregister().run();
                    }
                });
            }
        });
    }

    private void reloadBackground(IModData data) {
        Branding.BACKGROUND.loadResource(data).ifPresentOrElse(info -> {
            cachedBackground = info;
        }, () -> {
            if (cachedBackground != null) {
                cachedBackground.unregister().run();
                cachedBackground = null;
            }
        });
    }

    private static boolean performSearchFilter(String query, IModData data) {
        if (!query.startsWith("@")) {
            return false;
        }
        int end = query.indexOf(":");
        if (end == -1) {
            return false;
        }
        String type = query.substring(1, end).toLowerCase(Locale.ENGLISH);
        if (!SEARCH_FILTERS.containsKey(type)) {
            return false;
        }
        String value = query.substring(end + 1);
        return SEARCH_FILTERS.get(type).predicate().test(value, data);
    }

    private class_5481 formatQuery(String partial, int displayPos) {
        String query = (String)OPTION_QUERY.getValue();
        if (!query.startsWith("@")) {
            return class_5481.method_30747((String)partial, (class_2583)class_2583.field_24360);
        }
        int split = query.indexOf(":");
        if (split == -1) {
            return class_5481.method_30747((String)partial, (class_2583)SEARCH_FILTER_KEY);
        }
        if (displayPos > split) {
            return class_5481.method_30747((String)partial, (class_2583)SEARCH_FILTER_VALUE);
        }
        if (displayPos + partial.length() < split) {
            return class_5481.method_30747((String)partial, (class_2583)SEARCH_FILTER_KEY);
        }
        split = partial.indexOf(":");
        if (split == -1) {
            return class_5481.method_30747((String)partial, (class_2583)SEARCH_FILTER_KEY);
        }
        return class_5481.method_30742((class_5481)class_5481.method_30747((String)partial.substring(0, split + 1), (class_2583)SEARCH_FILTER_KEY), (class_5481)class_5481.method_30747((String)partial.substring(split + 1), (class_2583)SEARCH_FILTER_VALUE));
    }

    static {
        loaded = false;
    }

    private static class Favourites {
        private final Set<String> mods = new HashSet<String>();
        private boolean needsSave;
        private Path file;

        private Favourites() {
        }

        public void toggle(String modId) {
            if (!this.mods.remove(modId)) {
                this.mods.add(modId);
            }
            this.needsSave = true;
        }

        public boolean has(String modId) {
            return this.mods.contains(modId);
        }

        private void init() {
            try {
                Path configDir = ClientServices.PLATFORM.getConfigDirectory();
                Path file = configDir.resolve("catalogue_favourites.txt");
                if (!Files.exists(file, new LinkOption[0])) {
                    Files.createFile(file, new FileAttribute[0]);
                }
                this.file = file;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void load() {
            try {
                this.init();
                this.mods.clear();
                Predicate<String> modIdRegex = MOD_ID_PATTERN.asMatchPredicate();
                Files.readAllLines(this.file).forEach(s -> {
                    if (modIdRegex.test((String)s) && ClientServices.PLATFORM.isModLoaded((String)s)) {
                        this.mods.add((String)s);
                    }
                });
                this.needsSave = true;
                this.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void save() {
            if (!this.needsSave) {
                return;
            }
            try {
                this.needsSave = false;
                this.init();
                Files.write(this.file, this.mods, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ModList
    extends class_4280<ModListEntry> {
        private static final Predicate<IModData> SEARCH_PREDICATE = data -> {
            String query = (String)OPTION_QUERY.getValue();
            if (query.startsWith("@")) {
                return CatalogueModListScreen.performSearchFilter(query, data);
            }
            return data.getDisplayName().toLowerCase(Locale.ENGLISH).contains(query.toLowerCase(Locale.ENGLISH));
        };
        private static final Predicate<IModData> FILTER_PREDICATE = data -> {
            String query = (String)OPTION_QUERY.getValue();
            if (query.startsWith("@")) {
                return true;
            }
            if (OPTION_CONFIGS_ONLY.booleanValue() && !data.hasConfig()) {
                return false;
            }
            if (OPTION_UPDATES_ONLY.booleanValue() && data.getUpdate() == null) {
                return false;
            }
            if (OPTION_HIDE_LIBRARIES.booleanValue() && data.isLibrary()) {
                return false;
            }
            return !OPTION_FAVOURITES_ONLY.booleanValue() || FAVOURITES.has(data.getModId());
        };
        private boolean hideFavourites;

        public ModList() {
            super(CatalogueModListScreen.this.field_22787, 150, CatalogueModListScreen.this.field_22790 - 35 - 45, 45, 26);
        }

        protected int method_65507() {
            return this.method_46426() + this.field_22758 - 6;
        }

        public int method_25342() {
            return this.method_46426();
        }

        public int method_31383() {
            return this.method_25342() + this.method_25322();
        }

        public int method_25322() {
            return this.field_22758 - (this.method_44392() ? 6 : 0);
        }

        public void filterAndUpdateList() {
            List entries = CACHED_MODS.values().stream().filter(SEARCH_PREDICATE).filter(FILTER_PREDICATE).map(info -> new ModListEntry((IModData)info, this)).sorted((Comparator)OPTION_SORT.getValue()).collect(Collectors.toList());
            this.method_25314(entries);
            this.method_65506();
        }

        public Optional<class_364> method_19355(double mouseX, double mouseY) {
            if (mouseX > (double)(this.method_25342() + this.method_25322())) {
                return Optional.empty();
            }
            return super.method_19355(mouseX, mouseY);
        }

        @Nullable
        public ModListEntry getEntryFromInfo(IModData data) {
            return this.method_25396().stream().filter(entry -> entry.data == data).findFirst().orElse(null);
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_48579(graphics, mouseX, mouseY, partialTicks);
            if (this.method_25396().isEmpty()) {
                int left = this.method_46426() + this.method_25368() / 2;
                int n = this.method_46427();
                int n2 = this.method_25364();
                Objects.requireNonNull(CatalogueModListScreen.this.field_22793);
                int top = n + (n2 - 9) / 2;
                graphics.method_27534(CatalogueModListScreen.this.field_22793, (class_2561)class_2561.method_43471((String)"catalogue.gui.no_mods"), left, top, -1);
            }
        }

        protected void method_57713(class_332 graphics) {
        }

        protected void renderSelection(class_332 graphics, ModListEntry entry, int outlineColour) {
            graphics.method_25294(entry.method_46426(), entry.method_46427(), entry.method_46426() + entry.method_25368(), entry.method_46427() + entry.method_25364(), outlineColour);
            graphics.method_25294(entry.method_46426() + 1, entry.method_46427() + 1, entry.method_46426() + entry.method_25368() - 1, entry.method_46427() + entry.method_25364() - 1, -16777216);
        }

        public boolean method_25404(class_11908 event) {
            if (event.comp_4795() == 257 && this.method_25334() != null) {
                CatalogueModListScreen.this.setSelectedModData(((ModListEntry)this.method_25334()).data);
                class_1144 handler = class_310.method_1551().method_1483();
                handler.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            return super.method_25404(event);
        }

        protected boolean method_25351(class_11910 info) {
            return info.comp_4801() == 0 || info.comp_4801() == 1;
        }

        public void centerScrollOn(ModListEntry entry) {
            super.method_25324((class_350.class_351)entry);
        }

        public void method_25357(class_11909 event) {
            super.method_25357(event);
            this.hideFavourites = false;
        }

        public boolean method_65505(class_11909 event) {
            boolean scrolling;
            this.hideFavourites = scrolling = super.method_65505(event);
            return scrolling;
        }

        public boolean shouldHideFavourites() {
            return this.hideFavourites;
        }
    }

    private class StringList
    extends class_350<StringEntry> {
        private String description;

        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.field_22787, width, height, top, 10);
            this.description = "";
            this.method_46421(left);
            this.method_46419(top);
        }

        public void setTextFromInfo(IModData data) {
            this.description = data.getDescription();
            this.method_25339();
            this.field_22764 = true;
            if (data.getDescription().trim().isBlank()) {
                this.field_22764 = false;
                return;
            }
            CatalogueModListScreen.this.field_22793.method_27527().method_27498(data.getDescription().trim(), this.method_25322(), class_2583.field_24360).forEach(text -> this.method_25321((class_350.class_351)new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int method_65507() {
            return this.method_46426() + this.field_22758 - 7;
        }

        public int method_25342() {
            return this.method_46426() + 8;
        }

        public int method_25322() {
            return this.field_22758 - 16;
        }

        protected int method_44395() {
            return this.method_25340() * this.field_62109 + 8;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
            super.method_48579(graphics, mouseX, mouseY, partialTicks);
            graphics.method_44380();
        }

        protected void method_57715(class_332 graphics) {
            int x = this.method_46426();
            int y = this.method_46427();
            int width = this.method_25368();
            int height = this.method_25364();
            graphics.method_25294(x, y + 1, x + 1, y + height - 1, 0x77000000);
            graphics.method_25294(x + 1, y, x + width - 1, y + height, 0x77000000);
            graphics.method_25294(x + width - 1, y + 1, x + width, y + height - 1, 0x77000000);
        }

        protected void method_47399(class_6382 output) {
            output.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)this.description));
        }
    }

    private class ModListEntry
    extends class_4280.class_4281<ModListEntry> {
        private final IModData data;
        private final ModList list;
        private final PinnedButton button;
        private class_1799 icon;

        public ModListEntry(IModData data, ModList list) {
            this.data = data;
            this.list = list;
            this.button = new PinnedButton(data.getModId());
            this.icon = new class_1799((class_1935)this.getItemIcon());
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean inOptionsMenu = CatalogueModListScreen.this.menu != null;
            boolean drawFavouriteIcon = !inOptionsMenu && !this.list.shouldHideFavourites() && ClientHelper.isMouseWithin(this.method_46426() + this.method_25368() - this.method_25364() - 4, this.method_46427(), this.method_25364() + 4, this.method_25364(), mouseX, mouseY) || FAVOURITES.has(this.data.getModId());
            graphics.method_27535(CatalogueModListScreen.this.field_22793, this.getFormattedModName(drawFavouriteIcon), this.method_46426() + 24, this.method_46427() + 4, -1);
            graphics.method_27535(CatalogueModListScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.data.getVersion()).method_27692(class_124.field_1080), this.method_46426() + 24, this.method_46427() + 14, -1);
            this.drawIcon(graphics, this.method_46426(), this.method_46427());
            IModData.Update update = this.data.getUpdate();
            if (update != null) {
                int iconLeft = this.method_46427() + this.method_25368() - 8 - 9 + (drawFavouriteIcon ? -14 : 0);
                this.data.drawUpdateIcon(graphics, update, iconLeft, this.method_46427() + 7);
            }
            if (drawFavouriteIcon) {
                this.button.method_46421(this.method_46426() + this.method_25368() - this.button.method_25368() - 8);
                this.button.method_46419(this.method_46427() + (this.method_25364() - this.button.method_25364()) / 2 - 1);
                this.button.method_25394(graphics, mouseX, mouseY, partialTicks);
                if (!inOptionsMenu && this.button.method_25405(mouseX, mouseY)) {
                    class_5250 label = !FAVOURITES.has(this.data.getModId()) ? class_2561.method_43471((String)"catalogue.gui.favourite") : class_2561.method_43471((String)"catalogue.gui.remove_favourite");
                    CatalogueModListScreen.this.setTooltip(graphics, (class_2561)label, mouseX, mouseY);
                }
            }
        }

        private void drawIcon(class_332 graphics, int left, int top) {
            CatalogueModListScreen.this.loadAndCacheIcon(this.data);
            ImageInfo iconInfo = IMAGE_ICON_CACHE.get(this.data.getModId());
            if (iconInfo != null) {
                graphics.method_25302(class_10799.field_56883, iconInfo.resource(), left + 4, top + 5, 0.0f, 0.0f, 16, 16, iconInfo.width(), iconInfo.height(), iconInfo.width(), iconInfo.height());
                return;
            }
            try {
                graphics.method_51445(this.icon, left + 4, top + 5);
            }
            catch (Exception e) {
                Constants.LOG.debug("Failed to draw icon for mod '{}'", (Object)this.data.getModId());
                ITEM_ICON_CACHE.put(this.data.getModId(), class_1802.field_8270);
                this.icon = new class_1799((class_1935)class_1802.field_8270);
            }
        }

        private class_1792 getItemIcon() {
            class_1792 item2;
            class_2960 resource;
            if (ITEM_ICON_CACHE.containsKey(this.data.getModId())) {
                return ITEM_ICON_CACHE.get(this.data.getModId());
            }
            ITEM_ICON_CACHE.put(this.data.getModId(), class_1802.field_8270);
            if (this.data.getModId().equals("forge")) {
                class_1792 item3 = class_1802.field_8782;
                ITEM_ICON_CACHE.put("forge", item3);
                return item3;
            }
            String itemIcon = this.data.getItemIcon();
            if (itemIcon != null && !itemIcon.isEmpty() && (resource = class_2960.method_12829((String)itemIcon)) != null && (item2 = (class_1792)class_7923.field_41178.method_63535(resource)) != class_1802.field_8162) {
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            Optional<class_1792> optional = class_7923.field_41178.method_10220().filter(item -> item.method_40131().method_40237().method_29177().method_12836().equals(this.data.getModId())).findFirst();
            if (optional.isPresent() && (item2 = optional.get()) != class_1802.field_8162) {
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            return class_1802.field_8270;
        }

        private class_2561 getFormattedModName(boolean favouriteIconVisible) {
            Object name = this.data.getDisplayName();
            int paddingEnd = 4;
            int trimWidth = this.list.method_25322() - 24 - paddingEnd;
            IModData.Update update = this.data.getUpdate();
            if (update != null) {
                trimWidth -= 12;
            }
            if (favouriteIconVisible) {
                trimWidth -= 18;
            }
            if (CatalogueModListScreen.this.field_22793.method_1727((String)name) > trimWidth) {
                name = CatalogueModListScreen.this.field_22793.method_27523((String)name, trimWidth - 8).trim() + "...";
            }
            class_5250 title = class_2561.method_43470((String)name);
            if (this.data.isLibrary()) {
                title.method_27692(class_124.field_1063);
            }
            return title;
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.button.method_25402(event, doubleClick)) {
                return false;
            }
            if (event.method_74245() == 1) {
                DropdownMenu menu = DropdownMenu.builder(CatalogueModListScreen.this).setMinItemSize(0, 16).setAlignment(DropdownMenu.Alignment.BELOW_LEFT).addItem((class_2561)class_2561.method_43471((String)"catalogue.gui.show_dependencies"), () -> {
                    String filter = "@dependencies:" + this.data.getModId();
                    CatalogueModListScreen.this.searchTextField.method_1852(filter);
                }).addItem((class_2561)class_2561.method_43471((String)"catalogue.gui.show_dependents"), () -> {
                    String filter = "@dependents:" + this.data.getModId();
                    CatalogueModListScreen.this.searchTextField.method_1852(filter);
                }).build();
                menu.toggle((int)event.comp_4798(), (int)event.comp_4799());
                return false;
            }
            if (event.method_74245() == 0) {
                CatalogueModListScreen.this.setSelectedModData(this.data);
                this.list.method_25313((class_350.class_351)this);
                return true;
            }
            return false;
        }

        public IModData getData() {
            return this.data;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.data.getDisplayName());
        }

        private class PinnedButton
        extends class_4264 {
            private static final class_2960 TEXTURE = class_2960.method_60655((String)"catalogue", (String)"textures/gui/icons.png");
            private final String modId;

            public PinnedButton(String modId) {
                super(0, 0, 10, 10, class_5244.field_39003);
                this.modId = modId;
            }

            protected void method_75752(class_332 graphics, int mouseX, int mouseY, float partialTick) {
                int textureU = FAVOURITES.has(this.modId) ? 10 : 0;
                graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)textureU, 10.0f, 10, 10, 64, 64);
            }

            public void method_25306(class_11907 modifiers) {
                FAVOURITES.toggle(this.modId);
                ModListEntry.this.list.filterAndUpdateList();
            }

            protected void method_47399(class_6382 output) {
                this.method_37021(output);
            }
        }
    }

    private record SearchFilter(BiPredicate<String, IModData> predicate) {
    }

    private class StringEntry
    extends class_4280.class_4281<StringEntry> {
        private final String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.method_25303(CatalogueModListScreen.this.field_22793, this.line, this.method_46426(), this.method_46427(), -1);
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.line);
        }

        public void method_46419(int y) {
            super.method_46419(y + 4);
        }
    }
}

