/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final String DEFAULT_CONFIG = "# ----------- CATALOGUE CONFIG -----------\n# If properties are missing, delete this file\n# and load the game to regenerate the config.\n\n# [Title Menu Button Visibility]\n# The visibility of the Catalogue button on the title menu\n# Possible values: true, false\ntitle_menu_visible=true\n\n# [Title Menu Button Alignment]\n# The alignment of the Catalogue button relative to the target widget on the title menu\n# Possible values: left, right\ntitle_menu_align=left\n\n# [Title Menu Target]\n# The widget on the title screen to target the placement of the Catalogue button\n# Possible values: single_player, multiplayer, realms, language, options, quit_game, accessibility\ntitle_menu_target=realms\n\n# [Pause Menu Button Visibility]\n# The visibility of the Catalogue button on the pause menu\n# Possible values: true, false\npause_menu_visible=true\n\n# [Pause Menu Button Alignment]\n# The alignment of the Catalogue button relative to the target widget on the pause menu\n# Possible values: left, right\npause_menu_align=left\n\n# [Pause Menu Target]\n# The widget on the pause screen to target the placement of the Catalogue button\n# Possible values: single_player, multiplayer, realms, language, options, quit_game, accessibility\npause_menu_target=realms\n";
    private static Boolean titleMenuVisible = true;
    private static Align titleMenuAlign = Align.LEFT;
    private static TitleMenuTargets titleMenuTarget = TitleMenuTargets.REALMS;
    private static Boolean pauseMenuVisible = true;
    private static Align pauseMenuAlign = Align.LEFT;
    private static PauseMenuTargets pauseMenuTarget = PauseMenuTargets.OPTIONS;

    public static Boolean isTitleMenuVisible() {
        return titleMenuVisible;
    }

    public static Align getTitleMenuAlign() {
        return titleMenuAlign;
    }

    public static TitleMenuTargets getTitleMenuTarget() {
        return titleMenuTarget;
    }

    public static Boolean isPauseMenuVisible() {
        return pauseMenuVisible;
    }

    public static Align getPauseMenuAlign() {
        return pauseMenuAlign;
    }

    public static PauseMenuTargets getPauseMenuTarget() {
        return pauseMenuTarget;
    }

    public static void load(Path path) {
        File file = Config.getConfigFile(path);
        if (file != null) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                titleMenuVisible = Boolean.valueOf(properties.getProperty("title_menu_visible"));
                titleMenuAlign = Align.get(properties.getProperty("title_menu_align"));
                titleMenuTarget = TitleMenuTargets.get(properties.getProperty("title_menu_target"));
                pauseMenuVisible = Boolean.valueOf(properties.getProperty("pause_menu_visible"));
                pauseMenuAlign = Align.get(properties.getProperty("pause_menu_align"));
                pauseMenuTarget = PauseMenuTargets.get(properties.getProperty("pause_menu_target"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    private static File getConfigFile(Path path) {
        Path file = path.resolve("catalogue.properties");
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.writeString(file, (CharSequence)DEFAULT_CONFIG, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                return null;
            }
        }
        return file.toFile();
    }

    public static enum Align implements class_3542
    {
        LEFT("left"),
        RIGHT("right");

        public static final class_3542.class_7292<Align> CODEC;
        private final String name;

        private Align(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static Align get(String name) {
            return (Align)CODEC.method_47920(name, (Enum)LEFT);
        }

        static {
            CODEC = class_3542.method_28140(Align::values);
        }
    }

    public static enum TitleMenuTargets implements class_3542
    {
        SINGLE_PLAYER("single_player"),
        MULTIPLAYER("multiplayer"),
        REALMS("realms"),
        LANGUAGE("language"),
        OPTIONS("options"),
        QUIT_GAME("quit_game"),
        ACCESSIBILITY("accessibility");

        public static final class_3542.class_7292<TitleMenuTargets> CODEC;
        private final String name;

        private TitleMenuTargets(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static TitleMenuTargets get(String name) {
            return (TitleMenuTargets)CODEC.method_47920(name, (Enum)REALMS);
        }

        static {
            CODEC = class_3542.method_28140(TitleMenuTargets::values);
        }
    }

    public static enum PauseMenuTargets implements class_3542
    {
        RETURN_TO_GAME("return_to_game"),
        ADVANCEMENTS("advancements"),
        FEEDBACK("feedback"),
        OPTIONS("options"),
        STATISTICS("statistics"),
        REPORT_BUGS("report_bugs"),
        OPEN_TO_LAN("open_to_lan"),
        SAVE_AND_QUIT("save_and_quit");

        public static final class_3542.class_7292<PauseMenuTargets> CODEC;
        private final String name;

        private PauseMenuTargets(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public static PauseMenuTargets get(String name) {
            return (PauseMenuTargets)CODEC.method_47920(name, (Enum)OPTIONS);
        }

        static {
            CODEC = class_3542.method_28140(PauseMenuTargets::values);
        }
    }
}

