/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client;

import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.Utils;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.client.ImageInfo;
import com.mrcrayfish.catalogue.client.ImagePredicate;
import com.mrcrayfish.catalogue.exception.InvalidBrandingImageException;
import com.mrcrayfish.catalogue.exception.ModResourceNotFoundException;
import com.mrcrayfish.catalogue.platform.ClientServices;
import java.io.IOException;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record Branding(String prefix, int imageWidth, int imageHeight, BiPredicate<class_1011, Branding> predicate, Function<IModData, String> locator, boolean override) {
    public static final Branding ICON = new Branding("icon", 256, 256, ImagePredicate.SQUARE.and(ImagePredicate.LESS_THAN_OR_EQUAL), IModData::getImageIcon, false);
    public static final Branding BANNER = new Branding("banner", 1280, 256, ImagePredicate.LESS_THAN_OR_EQUAL, IModData::getBanner, false);
    public static final Branding BACKGROUND = new Branding("background", 512, 256, ImagePredicate.EQUAL, IModData::getBackground, true);

    public Optional<ImageInfo> loadResource(IModData data) {
        String resource = this.locator.apply(data);
        if (resource == null || resource.isBlank()) {
            return Optional.empty();
        }
        String modId = data.getModId();
        class_1011 image = null;
        try {
            image = ClientServices.PLATFORM.loadImageFromModResource(modId, resource);
            this.predicate.test(image, this);
            class_1043 texture = new class_1043(() -> this.prefix, image);
            class_2960 id = this.override ? Utils.resource(this.prefix) : Utils.resource("%s/%s".formatted(this.prefix, data.getModId()));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
            return Optional.of(new ImageInfo(id, image.method_4307(), image.method_4323(), () -> class_310.method_1551().method_1531().method_4615(id)));
        }
        catch (InvalidBrandingImageException e) {
            Constants.LOG.error("Invalid {} branding resource '{}' for mod '{}'", new Object[]{this.prefix, resource, modId, e});
        }
        catch (ModResourceNotFoundException e) {
            Constants.LOG.error("Unable to locate the {} branding resource '{}' for mod '{}'", new Object[]{this.prefix, resource, modId, e});
        }
        catch (IOException e) {
            Constants.LOG.error("An error occurred when loading the {} branding resource '{}' for mod '{}'", new Object[]{this.prefix, resource, modId, e});
        }
        if (image != null) {
            image.close();
        }
        return Optional.empty();
    }
}

