/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.client.Config;
import com.mrcrayfish.catalogue.client.screen.CatalogueModListScreen;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7919;

public class Catalogue
implements ClientModInitializer {
    private static Map<String, BiFunction<class_437, ModContainer, class_437>> providers;

    public void onInitializeClient() {
        Config.load(FabricLoaderImpl.INSTANCE.getConfigDir());
        providers = this.findConfigFactoryProviders();
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (Config.isTitleMenuVisible().booleanValue() && screen instanceof class_442) {
                int y;
                class_339 widget = this.findTitleTarget(screen);
                int x = widget != null ? widget.method_46426() : screen.field_22789 / 2 - 124;
                int n = y = widget != null ? widget.method_46427() : screen.field_22790 / 4 + 48 + 48;
                if (widget != null) {
                    x += Config.getTitleMenuAlign() == Config.Align.LEFT ? -24 : widget.method_25368() + 24;
                }
                CatalogueIconButton modButton = new CatalogueIconButton(x, y, 30, 0, button -> client.method_1507((class_437)new CatalogueModListScreen(screen)));
                modButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"catalogue.gui.mod_list")));
                Screens.getButtons((class_437)screen).add(modButton);
            } else if (Config.isPauseMenuVisible().booleanValue() && screen instanceof class_433) {
                int y;
                class_339 widget = this.findPauseTarget(screen);
                int x = widget != null ? widget.method_46426() : screen.field_22789 / 2 - 124;
                int n = y = widget != null ? widget.method_46427() : screen.field_22790 / 4 + 32 + 48;
                if (widget != null) {
                    x += Config.getPauseMenuAlign() == Config.Align.LEFT ? -24 : widget.method_25368() + 24;
                }
                CatalogueIconButton modButton = new CatalogueIconButton(x, y, 30, 0, button -> client.method_1507((class_437)new CatalogueModListScreen(screen)));
                modButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"catalogue.gui.mod_list")));
                Screens.getButtons((class_437)screen).add(modButton);
            }
        });
    }

    public static Map<String, BiFunction<class_437, ModContainer, class_437>> getConfigProviders() {
        return providers;
    }

    private Map<String, BiFunction<class_437, ModContainer, class_437>> findConfigFactoryProviders() {
        HashMap factories = new HashMap();
        HashMap providers = new HashMap();
        FabricLoader.getInstance().getAllMods().forEach(container -> this.getConfigFactoryClass((ModContainer)container).ifPresent(className -> {
            Optional.ofNullable(Catalogue.createConfigFactoryProvider(className)).ifPresent(map -> map.forEach(providers::putIfAbsent));
            this.createConfigFactory((String)className).ifPresent(function -> factories.put(container.getMetadata().getId(), function));
        }));
        providers.putAll(factories);
        return ImmutableMap.copyOf(providers);
    }

    private Optional<String> getConfigFactoryClass(ModContainer container) {
        ModMetadata metadata = container.getMetadata();
        CustomValue value = metadata.getCustomValue("catalogue");
        if (value == null || value.getType() != CustomValue.CvType.OBJECT) {
            return Optional.empty();
        }
        CustomValue.CvObject catalogueObj = value.getAsObject();
        CustomValue configFactoryValue = catalogueObj.get("configFactory");
        if (configFactoryValue == null || configFactoryValue.getType() != CustomValue.CvType.STRING) {
            return Optional.empty();
        }
        return Optional.of(configFactoryValue.getAsString());
    }

    private static Map<String, BiFunction<class_437, ModContainer, class_437>> createConfigFactoryProvider(String className) {
        try {
            Class<?> configFactoryClass = Class.forName(className);
            Method createConfigProviderMethod = configFactoryClass.getDeclaredMethod("createConfigProvider", new Class[0]);
            int mods = createConfigProviderMethod.getModifiers();
            if (!Modifier.isPublic(mods)) {
                Constants.LOG.error("createConfigProvider does not have public visibility in config provider: {}", (Object)className);
                return null;
            }
            if (!Modifier.isStatic(mods)) {
                Constants.LOG.error("createConfigProvider does not have static modifier in config provider: {}", (Object)className);
                return null;
            }
            if (createConfigProviderMethod.getReturnType() != Map.class) {
                Constants.LOG.error("createConfigProvider must return a Map<String, BiFunction<Screen, ModContainer, Screen>> in config provider: {}", (Object)className);
                return null;
            }
            return (Map)createConfigProviderMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Constants.LOG.error("Unable to locate config provider: " + className, (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Constants.LOG.error("Failed to load config provider: " + className, (Throwable)e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private Optional<BiFunction<class_437, ModContainer, class_437>> createConfigFactory(String className) {
        try {
            Class<?> configFactoryClass = Class.forName(className);
            Method createConfigScreenMethod = configFactoryClass.getDeclaredMethod("createConfigScreen", class_437.class, ModContainer.class);
            int mods = createConfigScreenMethod.getModifiers();
            if (!Modifier.isPublic(mods)) {
                Constants.LOG.error("createConfigScreen does not have public visibility in config provider: {}", (Object)className);
                return Optional.empty();
            }
            if (!Modifier.isStatic(mods)) {
                Constants.LOG.error("createConfigScreen does not have static modifier in config provider: {}", (Object)className);
                return Optional.empty();
            }
            return Optional.of((currentScreen, container) -> {
                try {
                    return (class_437)createConfigScreenMethod.invoke(null, currentScreen, container);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to create config screen from provider: " + className, e);
                }
            });
        }
        catch (ClassNotFoundException e) {
            Constants.LOG.error("Unable to locate config provider: " + className, (Throwable)e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private class_339 findTitleTarget(class_437 screen) {
        String targetLang = this.getTitleTargetLang(Config.getTitleMenuTarget());
        return this.findTarget(screen, targetLang);
    }

    private class_339 findPauseTarget(class_437 screen) {
        String targetLang = this.getPauseTargetLang(Config.getPauseMenuTarget());
        return this.findTarget(screen, targetLang);
    }

    private class_339 findTarget(class_437 screen, String langTarget) {
        return screen.method_25396().stream().filter(listener -> listener instanceof class_339).map(listener -> (class_339)listener).filter(listener -> {
            class_5250 component;
            class_7417 patt1$temp;
            class_4185 btn;
            class_2561 patt0$temp;
            if (listener instanceof class_4185 && (patt0$temp = (btn = (class_4185)listener).method_25369()) instanceof class_5250 && (patt1$temp = (component = (class_5250)patt0$temp).method_10851()) instanceof class_2588) {
                class_2588 contents = (class_2588)patt1$temp;
                return contents.method_11022().equals(langTarget);
            }
            return false;
        }).findFirst().orElse(null);
    }

    private String getTitleTargetLang(Config.TitleMenuTargets target) {
        return switch (target) {
            default -> throw new MatchException(null, null);
            case Config.TitleMenuTargets.SINGLE_PLAYER -> "menu.singleplayer";
            case Config.TitleMenuTargets.MULTIPLAYER -> "menu.multiplayer";
            case Config.TitleMenuTargets.REALMS -> "menu.online";
            case Config.TitleMenuTargets.LANGUAGE -> "options.language";
            case Config.TitleMenuTargets.OPTIONS -> "menu.options";
            case Config.TitleMenuTargets.QUIT_GAME -> "menu.quit";
            case Config.TitleMenuTargets.ACCESSIBILITY -> "options.accessibility";
        };
    }

    private String getPauseTargetLang(Config.PauseMenuTargets target) {
        return switch (target) {
            default -> throw new MatchException(null, null);
            case Config.PauseMenuTargets.RETURN_TO_GAME -> "menu.returnToGame";
            case Config.PauseMenuTargets.ADVANCEMENTS -> "gui.advancements";
            case Config.PauseMenuTargets.FEEDBACK -> "menu.sendFeedback";
            case Config.PauseMenuTargets.OPTIONS -> "menu.options";
            case Config.PauseMenuTargets.STATISTICS -> "gui.stats";
            case Config.PauseMenuTargets.REPORT_BUGS -> "menu.reportBugs";
            case Config.PauseMenuTargets.OPEN_TO_LAN -> "menu.shareToLan";
            case Config.PauseMenuTargets.SAVE_AND_QUIT -> "menu.returnToMenu";
        };
    }
}

