/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network;

import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ExecutionContext;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerPlayHelper {
    public static void sendMessageToOperators(class_2561 message, class_3222 player) {
        MinecraftServer server = player.method_51469().method_8503();
        Preconditions.checkNotNull((Object)server, (Object)"The server was null when broadcasting config changes. This should not be possible...");
        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
            if (!server.method_3760().method_14569(serverPlayer.method_72498())) continue;
            serverPlayer.method_64398(message);
        }
    }

    public static boolean canEditServerConfigs(class_3222 player) {
        ExecutionContext context = new ExecutionContext((class_1657)player);
        if (context.isClient()) {
            if (!context.isIntegratedServerOwnedByPlayer()) {
                Constants.LOG.warn("{} tried to request or update a server config, however is not the owner the integrated server", (Object)player.method_5477().getString());
                player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.unauthorized_request"));
                return false;
            }
            Constants.LOG.debug("{} was given access to edit server configs as they are the owner of the integrated server", (Object)player.method_5477().getString());
            return true;
        }
        if (context.isDedicatedServer()) {
            if (!Config.isDeveloperEnabled()) {
                Constants.LOG.warn("{} tried to request or update a server config, however developer mode is not enabled", (Object)player.method_5477().getString());
                player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.unauthorized_request"));
                ServerPlayHelper.sendMessageToOperators((class_2561)class_2561.method_43471((String)"configured.chat.authorized_player").method_27692(class_124.field_1061), player);
                return false;
            }
            if (!context.isPlayerAnOperator() || !context.isDeveloperPlayer()) {
                Constants.LOG.warn("{} tried to request or update a server config, however they are not a developer", (Object)player.method_5477().getString());
                player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"configured.multiplayer.disconnect.unauthorized_request"));
                ServerPlayHelper.sendMessageToOperators((class_2561)class_2561.method_43471((String)"configured.chat.authorized_player").method_27692(class_124.field_1061), player);
                return false;
            }
            return true;
        }
        return false;
    }
}

