/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen.list;

import com.google.common.collect.Streams;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.client.screen.list.EnumListType;
import com.mrcrayfish.configured.client.screen.list.IListConfigValue;
import com.mrcrayfish.configured.client.screen.list.IListType;
import com.mrcrayfish.configured.client.screen.list.ListType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class ListTypes {
    public static final IListType<?> UNKNOWN = new ListType<String>(Object::toString, o -> o, "configured.parser.not_a_value");
    public static final IListType<Boolean> BOOLEAN = new ListType<Boolean>(Object::toString, Boolean::valueOf, "configured.parser.not_a_boolean");
    public static final IListType<Integer> INTEGER = new ListType<Integer>(Object::toString, Ints::tryParse, "configured.parser.not_a_number");
    public static final IListType<Long> LONG = new ListType<Long>(Object::toString, Longs::tryParse, "configured.parser.not_a_number");
    public static final IListType<Double> DOUBLE = new ListType<Double>(Object::toString, Doubles::tryParse, "configured.parser.not_a_number");
    public static final IListType<String> STRING = new ListType<String>(Function.identity(), Function.identity(), "configured.parser.not_a_value");

    public static <T> IListType<T> getUnknown() {
        return UNKNOWN;
    }

    public static IListType getTypeUnsafe(IConfigValue holder) {
        if (holder.get() instanceof List) {
            return ListTypes.getType(holder);
        }
        return UNKNOWN;
    }

    public static <T> IListType<T> getType(IConfigValue<List<T>> holder) {
        IListConfigValue provider;
        IListType type;
        if (holder instanceof IListConfigValue && (type = (provider = (IListConfigValue)holder).getListType()) != null) {
            return type;
        }
        return ListTypes.fromHolder(holder);
    }

    private static <T> IListType<T> fromHolder(IConfigValue<List<T>> holder) {
        return ListTypes.getListValues(holder).map(ListTypes::fromObject).filter(t -> t != UNKNOWN).findAny().orElseGet(() -> ListTypes.fromElementValidator(holder));
    }

    private static <T> Stream<T> getListValues(IConfigValue<List<T>> holder) {
        return Streams.concat((Stream[])new Stream[]{holder.get().stream(), holder.getDefault().stream()}).filter(Objects::nonNull);
    }

    private static <T> IListType<T> fromObject(T o) {
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof Integer) {
            return INTEGER;
        }
        if (o instanceof Long) {
            return LONG;
        }
        if (o instanceof Double) {
            return DOUBLE;
        }
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof Enum) {
            Enum enumValue = (Enum)o;
            return new EnumListType(enumValue.getClass());
        }
        return UNKNOWN;
    }

    private static <T> IListType<T> fromElementValidator(IConfigValue<List<T>> spec) {
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList("s"))) {
            return STRING;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(true))) {
            return BOOLEAN;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(0.0))) {
            return DOUBLE;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(0L))) {
            return LONG;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(0))) {
            return INTEGER;
        }
        return UNKNOWN;
    }

    private static <T> boolean safeTryIsValid(IConfigValue<List<T>> spec, List<?> list) {
        try {
            return spec.isValid(list);
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }
}

