/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8573;
import org.apache.commons.io.file.PathUtils;

public class WorldSelectionScreen
extends ListMenuScreen {
    private static final class_5218 SERVER_CONFIG_FOLDER = Services.CONFIG.getServerConfigResource();
    private static final class_2960 MISSING_ICON = class_2960.method_60656((String)"textures/misc/unknown_server.png");
    private final IModConfig config;

    public WorldSelectionScreen(class_437 parent, IModConfig config, class_2561 title) {
        super(parent, (class_2561)class_2561.method_43469((String)"configured.gui.edit_world_config", (Object[])new Object[]{title.method_27662().method_27695(new class_124[]{class_124.field_1067, class_124.field_1065})}), 30);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        try {
            class_32 source = class_310.method_1551().method_1586();
            ArrayList levels = new ArrayList((Collection)source.method_43417(source.method_235()).join());
            if (levels.size() > 6) {
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((class_2561)class_2561.method_43471((String)"configured.gui.title.recently_played").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
                List<class_34> recent = levels.stream().sorted(Comparator.comparing(s -> -s.method_249())).limit(3L).toList();
                recent.forEach(summary -> entries.add(new WorldItem((class_34)summary)));
                levels.removeAll(recent);
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((class_2561)class_2561.method_43471((String)"configured.gui.title.other_worlds").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            }
            levels.stream().sorted(Comparator.comparing(class_34::method_252)).forEach(summary -> entries.add(new WorldItem((class_34)summary)));
        }
        catch (class_33 e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 - 75, this.field_22790 - 29, 150, 20, class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate((float)(this.field_22789 - 30), 15.0f);
        graphics.method_51448().scale(2.5f, 2.5f);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"?").method_27692(class_124.field_1067), 0, 0, -1);
        graphics.method_51448().popMatrix();
        if (ScreenUtil.isMouseWithin(this.field_22789 - 30, 15, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.server_config_info"), mouseX, mouseY);
        }
    }

    public void method_25419() {
        super.method_25419();
        this.entries.forEach(item -> {
            if (item instanceof WorldItem) {
                ((WorldItem)item).disposeIcon();
            }
        });
    }

    public class WorldItem
    extends ListMenuScreen.Item {
        private final class_2561 worldName;
        private final class_2561 folderName;
        private Path iconFile;
        private final class_4185 modifyButton;
        private final class_8573 icon;

        public WorldItem(class_34 summary) {
            super(summary.method_252());
            this.worldName = class_2561.method_43470((String)summary.method_252());
            this.folderName = class_2561.method_43470((String)summary.method_248()).method_27692(class_124.field_1063);
            this.icon = class_8573.method_52200((class_1060)class_310.method_1551().method_1531(), (String)summary.method_248());
            this.iconFile = summary.method_27020();
            this.validateIcon();
            this.loadWorldIcon();
            this.modifyButton = new IconButton(0, 0, 0, this.getIconV(), 60, this.getButtonLabel(), onPress -> this.loadWorldConfig(summary.method_248(), summary.method_252()));
        }

        private void validateIcon() {
            if (this.iconFile == null) {
                return;
            }
            try {
                BasicFileAttributes attributes = Files.readAttributes(this.iconFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (attributes.isSymbolicLink()) {
                    List list = class_310.method_1551().method_52702().method_52618(this.iconFile);
                    if (!list.isEmpty()) {
                        this.iconFile = null;
                        return;
                    }
                    attributes = Files.readAttributes(this.iconFile, BasicFileAttributes.class, new LinkOption[0]);
                }
                if (!attributes.isRegularFile()) {
                    this.iconFile = null;
                }
            }
            catch (IOException e) {
                this.iconFile = null;
            }
        }

        private class_2561 getButtonLabel() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return class_2561.method_43471((String)"configured.gui.view");
            }
            return class_2561.method_43471((String)"configured.gui.select");
        }

        private int getIconV() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return 33;
            }
            return 22;
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.modifyButton);
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            if (this.modifyButton.method_25405((double)mouseX, (double)mouseY)) {
                graphics.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + 25, this.method_46427() + 25, -1);
            }
            graphics.method_25302(class_10799.field_56883, this.icon.method_52201(), this.method_46426(), this.method_46427(), 0.0f, 0.0f, 24, 24, 32, 32, 32, 32);
            graphics.method_27535(((WorldSelectionScreen)WorldSelectionScreen.this).field_22787.field_1772, this.worldName, this.method_46426() + 30, this.method_46427() + 3, -1);
            graphics.method_27535(((WorldSelectionScreen)WorldSelectionScreen.this).field_22787.field_1772, this.folderName, this.method_46426() + 30, this.method_46427() + 13, -1);
            this.modifyButton.method_46421(this.method_46426() + this.method_25368() - 61);
            this.modifyButton.method_46419(this.method_46427() + 2);
            this.modifyButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        private void loadWorldIcon() {
            if (this.iconFile == null || !Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                return;
            }
            try (InputStream is = Files.newInputStream(this.iconFile, new OpenOption[0]);
                 class_1011 image = class_1011.method_4309((InputStream)is);){
                if (image.method_4307() != 64 || image.method_4323() != 64) {
                    return;
                }
                this.icon.method_52199(image);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void disposeIcon() {
            this.icon.method_52198();
        }

        private void loadWorldConfig(String worldFileName, String worldName) {
            try (class_32.class_5143 storageAccess = class_310.method_1551().method_1586().method_27002(worldFileName);){
                ActionResult result;
                Path worldConfigPath = storageAccess.method_27010(SERVER_CONFIG_FOLDER).toAbsolutePath();
                PathUtils.createParentDirectories((Path)worldConfigPath, (FileAttribute[])new FileAttribute[0]);
                if (!Files.isDirectory(worldConfigPath, new LinkOption[0])) {
                    Files.createDirectory(worldConfigPath, new FileAttribute[0]);
                }
                if ((result = WorldSelectionScreen.this.config.loadWorldConfig(worldConfigPath)).asBoolean()) {
                    class_5250 configName = class_2561.method_43470((String)ModConfigSelectionScreen.createLabelFromModConfig(WorldSelectionScreen.this.config));
                    class_5250 newTitle = class_2561.method_43470((String)worldName).method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852((class_2561)configName);
                    WorldSelectionScreen.this.field_22787.method_1507((class_437)new ConfigScreen(WorldSelectionScreen.this.parent, (class_2561)newTitle, WorldSelectionScreen.this.config));
                    return;
                }
                class_2561 message = result.message().orElse((class_2561)class_2561.method_43471((String)"configured.gui.load_world_config_failed"));
                ConfirmationScreen.showError(WorldSelectionScreen.this.field_22787, WorldSelectionScreen.this, message);
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load world config", (Throwable)e);
                ConfirmationScreen.showError(WorldSelectionScreen.this.field_22787, WorldSelectionScreen.this, (class_2561)class_2561.method_43471((String)"configured.gui.load_world_config_exception"));
            }
        }
    }
}

