/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.api.ExecutionContext;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.ClientConfigHelper;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EntryBackground;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.RequestScreen;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class ModConfigSelectionScreen
extends ListMenuScreen {
    private final Map<ConfigType, Set<IModConfig>> configMap;

    public ModConfigSelectionScreen(class_437 parent, class_2561 title, Map<ConfigType, Set<IModConfig>> configMap) {
        super(parent, title, 30);
        this.configMap = configMap;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        Set<IModConfig> localConfigs = this.getLocalConfigs();
        if (!localConfigs.isEmpty()) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.client_configuration").getString()));
            ArrayList localEntries = new ArrayList();
            localConfigs.forEach(config -> localEntries.add(new FileItem(this, (IModConfig)config)));
            Collections.sort(localEntries);
            entries.addAll(localEntries);
        }
        class_746 player = class_310.method_1551().field_1724;
        ExecutionContext context = new ExecutionContext((class_1657)player);
        Set<IModConfig> remoteConfigs = this.getRemoteConfigs();
        if (!remoteConfigs.isEmpty() && (context.isMainMenu() || context.isConfiguredInstalledRemotely())) {
            if (context.isPlayingGame() && context.isPlayingOnRemoteServer()) {
                if (context.isPlayingOnLan() && !context.isIntegratedServerOwnedByPlayer()) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.server_configuration").getString()));
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((class_2561)class_2561.method_43471((String)"configured.gui.lan_server")));
                    return;
                }
                if (!context.isPlayerAnOperator()) {
                    return;
                }
                if (!context.isDeveloperPlayer()) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.server_configuration").getString()));
                    entries.add(new ListMenuScreen.MultiTextItem((class_2561)class_2561.method_43471((String)"configured.gui.no_developer_status"), (class_2561)class_2561.method_43469((String)"configured.gui.developer_details", (Object[])new Object[]{class_2561.method_43470((String)"configured.developer.toml").method_27692(class_124.field_1065).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))}).method_27692(class_124.field_1080).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"configured.gui.developer_file"))))));
                    return;
                }
            }
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.server_configuration").getString()));
            ArrayList remoteEntries = new ArrayList();
            remoteConfigs.forEach(config -> remoteEntries.add(new FileItem(this, (IModConfig)config)));
            Collections.sort(remoteEntries);
            entries.addAll(remoteEntries);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 - 75, this.field_22790 - 29, 150, 20, class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
    }

    private Set<IModConfig> getLocalConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> !((ConfigType)((Object)((Object)entry.getKey()))).isServer()).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    private Set<IModConfig> getRemoteConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> {
            ConfigType type = (ConfigType)((Object)((Object)entry.getKey()));
            return type.isServer() && type.getEnv().orElse(null) != Environment.DEDICATED_SERVER;
        }).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public static String createLabelFromModConfig(IModConfig config) {
        if (config.getTranslationKey() != null) {
            return class_1074.method_4662((String)config.getTranslationKey(), (Object[])new Object[0]);
        }
        String fileName = config.getFileName();
        if ((fileName = fileName.replace(config.getModId() + "-", "")).endsWith(".toml")) {
            fileName = fileName.substring(0, fileName.length() - ".toml".length());
        }
        fileName = FilenameUtils.getName((String)fileName);
        fileName = ConfigScreen.createLabel(fileName);
        return fileName;
    }

    public static boolean isRunningUnpublishedLan() {
        return class_310.method_1551().method_1576() != null && !class_310.method_1551().method_1576().method_3860();
    }

    public class FileItem
    extends ListMenuScreen.Item
    implements EntryBackground {
        protected final TooltipScreen screen;
        protected final IModConfig config;
        protected final class_2561 title;
        protected final class_2561 fileName;
        protected final class_2561 modifyTooltip;
        protected final class_4185 modifyButton;
        @Nullable
        protected final class_4185 restoreButton;

        public FileItem(TooltipScreen screen, IModConfig config) {
            super(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.screen = screen;
            this.config = config;
            this.title = this.createTrimmedFileName(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.fileName = this.createTrimmedFileName(config.getFileName()).method_27692(class_124.field_1063);
            this.modifyButton = this.createModifyButton(config);
            ActionResult result = config.canPlayerEdit((class_1657)class_310.method_1551().field_1724);
            this.modifyButton.field_22763 = result.asBoolean();
            this.modifyTooltip = result.message().orElse((class_2561)class_2561.method_43471((String)"configured.gui.no_permission"));
            this.restoreButton = this.createRestoreButton(config);
            this.updateRestoreDefaultButton();
        }

        private void showRestoreScreen() {
            ConfirmationScreen confirmScreen = new ConfirmationScreen(ModConfigSelectionScreen.this, (class_2561)class_2561.method_43471((String)"configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
                if (!result.booleanValue()) {
                    return true;
                }
                this.config.restoreDefaultsTask().ifPresent(Runnable::run);
                this.updateRestoreDefaultButton();
                return true;
            });
            confirmScreen.setPositiveText((class_2561)class_2561.method_43471((String)"configured.gui.restore").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
            confirmScreen.setNegativeText(class_5244.field_24335);
            class_310.method_1551().method_1507((class_437)confirmScreen);
        }

        private class_5250 createTrimmedFileName(String fileName) {
            class_5250 trimmedFileName = class_2561.method_43470((String)fileName);
            if (class_310.method_1551().field_1772.method_1727(fileName) > 150) {
                trimmedFileName = class_2561.method_43470((String)(class_310.method_1551().field_1772.method_27523(fileName, 140).trim() + "..."));
            }
            return trimmedFileName;
        }

        private class_4185 createModifyButton(IModConfig config) {
            int width = ConfigHelper.canRestoreConfig(config, (class_1657)class_310.method_1551().field_1724) ? 60 : 82;
            return new IconButton(0, 0, this.getModifyIconU(config), this.getModifyIconV(config), width, this.getModifyLabel(config), button -> {
                if (!button.method_37303() || !button.field_22764) {
                    return;
                }
                if (!config.canPlayerEdit((class_1657)class_310.method_1551().field_1724).asBoolean()) {
                    return;
                }
                if (config.getType() == ConfigType.DEDICATED_SERVER) {
                    return;
                }
                ExecutionContext context = new ExecutionContext((class_1657)class_310.method_1551().field_1724);
                if (context.isMainMenu()) {
                    if (config.getType().isWorld()) {
                        class_310.method_1551().method_1507((class_437)new WorldSelectionScreen((class_437)ModConfigSelectionScreen.this, config, this.title));
                        return;
                    }
                    if (config.getType().isServer()) {
                        class_5250 newTitle = ModConfigSelectionScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852(this.title);
                        class_310.method_1551().method_1507((class_437)new ConfigScreen((class_437)ModConfigSelectionScreen.this, (class_2561)newTitle, config));
                        return;
                    }
                }
                if (context.isPlayingOnRemoteServer() && context.isConfiguredInstalledRemotely() && config.requestFromServerTask().isPresent() && context.isPlayerAnOperator() && context.isDeveloperPlayer()) {
                    class_5250 newTitle = ModConfigSelectionScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852(this.title);
                    class_310.method_1551().method_1507((class_437)new RequestScreen((class_437)ModConfigSelectionScreen.this, (class_2561)newTitle, config));
                    return;
                }
                class_5250 newTitle = ModConfigSelectionScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852(this.title);
                class_310.method_1551().method_1507((class_437)new ConfigScreen((class_437)ModConfigSelectionScreen.this, (class_2561)newTitle, config));
            });
        }

        private int getModifyIconU(IModConfig config) {
            if (!ConfigHelper.isPlayingGame() && config.getType().isWorld()) {
                return 11;
            }
            return 0;
        }

        private int getModifyIconV(IModConfig config) {
            if (ConfigHelper.isPlayingGame() ? config.isReadOnly() : config.isReadOnly() && !config.getType().isWorld()) {
                return 33;
            }
            return 22;
        }

        private class_2561 getModifyLabel(IModConfig config) {
            if (ClientConfigHelper.isMainMenu() && config.getType().isWorld()) {
                return class_2561.method_43471((String)"configured.gui.select_world");
            }
            if (config.isReadOnly()) {
                return class_2561.method_43471((String)"configured.gui.view");
            }
            return class_2561.method_43471((String)"configured.gui.modify");
        }

        private class_4185 createRestoreButton(IModConfig config) {
            if (ConfigHelper.canRestoreConfig(config, (class_1657)class_310.method_1551().field_1724)) {
                IconButton restoreButton = new IconButton(0, 0, 0, 0, onPress -> this.showRestoreScreen());
                restoreButton.field_22763 = !config.isReadOnly() && config.isChanged();
                return restoreButton;
            }
            return null;
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            graphics.method_27535(class_310.method_1551().field_1772, this.title, this.method_46426() + 26, this.method_46427() + 6, -1);
            graphics.method_27535(class_310.method_1551().field_1772, this.fileName, this.method_46426() + 26, this.method_46427() + 16, -1);
            graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.method_46426() + 2, this.method_46427() + 4, (float)this.getIconU(), (float)this.getIconV(), 18, 22, 9, 11, 64, 64);
            if (this.config.isReadOnly()) {
                graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.method_46426() - 2, this.method_46427() + 19, 0.0f, 33.0f, 11, 11, 11, 11, 64, 64);
            }
            this.modifyButton.method_46421(this.method_46426() + this.method_25368() - 83);
            this.modifyButton.method_46419(this.method_46427() + 5);
            this.modifyButton.method_25394(graphics, mouseX, mouseY, partialTick);
            if (this.restoreButton != null) {
                this.restoreButton.method_46421(this.method_46426() + this.method_25368() - 21);
                this.restoreButton.method_46419(this.method_46427() + 5);
                this.restoreButton.method_25394(graphics, mouseX, mouseY, partialTick);
            }
            if (this.config.isReadOnly() && ScreenUtil.isMouseWithin(this.method_46426() - 2, this.method_46427() + 19, 11, 11, mouseX, mouseY)) {
                ModConfigSelectionScreen.this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.read_only_config"), mouseX, mouseY, TooltipScreen.TooltipStyle.HINT);
            }
            if (!this.modifyButton.field_22763 && this.modifyButton.method_25367()) {
                this.screen.setActiveTooltip(graphics, this.modifyTooltip, mouseX, mouseY, TooltipScreen.TooltipStyle.ERROR);
            }
        }

        private int getIconU() {
            return this.config.getType().ordinal() % 3 * 9 + 33;
        }

        private int getIconV() {
            return this.config.getType().ordinal() / 3 * 11;
        }

        @Override
        public List<? extends class_364> method_25396() {
            if (this.restoreButton != null) {
                return ImmutableList.of((Object)this.modifyButton, (Object)this.restoreButton);
            }
            return ImmutableList.of((Object)this.modifyButton);
        }

        private void updateRestoreDefaultButton() {
            if (this.config != null && this.restoreButton != null && ConfigHelper.canRestoreConfig(this.config, (class_1657)class_310.method_1551().field_1724)) {
                this.restoreButton.field_22763 = !this.config.isReadOnly() && this.config.isChanged();
            }
        }
    }
}

