/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.client.screen.EntryBackground;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public abstract class ListMenuScreen
extends TooltipScreen {
    public static final class_2960 CONFIGURED_LOGO = class_2960.method_60655((String)"configured", (String)"textures/gui/logo.png");
    protected final class_437 parent;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;

    protected ListMenuScreen(class_437 parent, class_2561 title, int itemHeight) {
        super(title);
        this.parent = parent;
        this.itemHeight = itemHeight;
    }

    protected abstract void constructEntries(List<Item> var1);

    protected void method_25426() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this, this.entries);
        this.method_25429((class_364)this.list);
        this.searchTextField = new FocusedEditBox(this.field_22793, this.field_22789 / 2 - 110, 22, 220, 20, (class_2561)class_2561.method_43471((String)"configured.gui.search"));
        this.searchTextField.setClearable(true);
        this.searchTextField.method_1863(s -> this.updateSearchResults());
        this.method_25429((class_364)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    protected void updateSearchResults() {
        String query = this.searchTextField.method_1882();
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, query, this.entries);
        this.list.method_25314(query.isEmpty() ? this.entries : this.getSearchResults(query));
        if (!query.isEmpty()) {
            this.list.method_44382(0.0);
        }
    }

    protected Collection<Item> getSearchResults(String s) {
        return this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    protected void updateTooltip(class_332 graphics, int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.info"), mouseX, mouseY);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.list.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 7, -1);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(class_10799.field_56883, CONFIGURED_LOGO, 10, 13, 0.0f, 0.0f, 23, 23, 32, 32);
        graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.field_22789 / 2 - 128, 26, 22.0f, 11.0f, 14, 14, 10, 10, 64, 64);
        this.updateTooltip(graphics, mouseX, mouseY);
    }

    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)event.comp_4798(), (int)event.comp_4799())) {
            class_2558.class_10608 clickEvent = new class_2558.class_10608(URI.create("https://www.curseforge.com/minecraft/mc-mods/configured"));
            ListMenuScreen.method_71847((class_2558)clickEvent, (class_310)this.field_22787, (class_437)this);
            return true;
        }
        if (this.activeTextField != null && !this.activeTextField.method_25405(event.comp_4798(), event.comp_4799())) {
            this.activeTextField.method_25365(false);
        }
        return super.method_25402(event, doubleClick);
    }

    protected class EntryList
    extends class_4265<Item> {
        public EntryList(ListMenuScreen this$0, List<Item> entries) {
            super(this$0.field_22787, this$0.field_22789, this$0.field_22790 - 36 - 50, 50, this$0.itemHeight);
            entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        protected int method_65507() {
            return this.field_22758 / 2 + 144;
        }

        public int method_25322() {
            return 260;
        }

        public void method_25314(Collection<Item> entries) {
            super.method_25314(entries);
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_48579(graphics, mouseX, mouseY, partialTicks);
        }

        protected void method_25311(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            List entries = this.method_25396();
            for (int i = 0; i < entries.size(); ++i) {
                Item entry = (Item)entries.get(i);
                if (entry.method_46427() + entry.method_25364() < this.method_46427() || entry.method_46427() > this.method_55443()) continue;
                if (i % 2 != 0 && entry instanceof EntryBackground) {
                    graphics.method_25294(entry.method_46426() - 3, entry.method_46427(), entry.method_46426() + entry.method_25368() + 3, entry.method_46427() + 1, 0x33000000);
                    graphics.method_25294(entry.method_46426() - 4, entry.method_46427() + 1, entry.method_46426() + entry.method_25368() + 4, entry.method_46427() + entry.method_25364() - 1, 0x33000000);
                    graphics.method_25294(entry.method_46426() - 3, entry.method_46427() + entry.method_25364() - 1, entry.method_46426() + entry.method_25368() + 3, entry.method_46427() + entry.method_25364(), 0x33000000);
                }
                this.method_44397(graphics, mouseX, mouseY, partialTick, (class_350.class_351)entry);
            }
        }
    }

    protected class FocusedEditBox
    extends class_342 {
        private boolean clearable;

        public FocusedEditBox(class_327 font, int x, int y, int width, int height, class_2561 label) {
            super(font, x, y, width, height, label);
            this.clearable = false;
        }

        public FocusedEditBox setClearable(boolean clearable) {
            this.clearable = clearable;
            return this;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.method_25365(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            super.method_48579(graphics, mouseX, mouseY, partialTick);
            if (this.clearable && !this.method_1882().isEmpty()) {
                boolean hovered = ScreenUtil.isMouseWithin(this.method_46426() + this.field_22758 - 15, this.method_46427() + 5, 9, 9, mouseX, mouseY);
                graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.method_46426() + this.field_22758 - 15, this.method_46427() + 5, hovered ? 9.0f : 0.0f, 55.0f, 9, 9, 9, 9, 64, 64);
            }
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.clearable && !this.method_1882().isEmpty() && event.method_74245() == 0 && ScreenUtil.isMouseWithin(this.method_46426() + this.field_22758 - 15, this.method_46427() + 5, 9, 9, (int)event.comp_4798(), (int)event.comp_4799())) {
                this.method_25354(ListMenuScreen.this.field_22787.method_1483());
                this.method_1852("");
                return true;
            }
            return super.method_25402(event, doubleClick);
        }
    }

    protected static interface IIgnoreSearch {
    }

    protected abstract class Item
    extends class_4265.class_4266<Item>
    implements ILabelProvider,
    Comparable<Item> {
        protected final class_2561 label;
        @Nullable
        protected List<class_5481> tooltip;

        public Item(class_2561 label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = class_2561.method_43470((String)label);
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            if (this.method_25405(mouseX, mouseY)) {
                ListMenuScreen.this.setActiveTooltip(graphics, this.tooltip, mouseX, mouseY);
            }
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, Item.this.label);
                }
            });
        }

        @Override
        public int compareTo(Item o) {
            return this.label.getString().compareTo(o.label.getString());
        }
    }

    public class MultiTextItem
    extends Item
    implements IIgnoreSearch {
        private final class_2561 bottomText;

        public MultiTextItem(class_2561 topText, class_2561 bottomText) {
            super(topText);
            this.bottomText = bottomText;
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            class_2583 style;
            class_2568 event;
            graphics.method_27534(((ListMenuScreen)ListMenuScreen.this).field_22787.field_1772, this.label, this.method_46426() + this.method_25368() / 2, this.method_46427(), -1);
            graphics.method_27534(((ListMenuScreen)ListMenuScreen.this).field_22787.field_1772, this.bottomText, this.method_46426() + this.method_25368() / 2, this.method_46427() + 12, -1);
            if (this.method_25405(mouseX, mouseY) && (event = (style = this.bottomText.method_10866()).method_10969()) instanceof class_2568.class_10613) {
                class_2561 value;
                class_2568.class_10613 class_106132 = (class_2568.class_10613)event;
                try {
                    class_2561 class_25612;
                    value = class_25612 = class_106132.comp_3510();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ListMenuScreen.this.setActiveTooltip(graphics, value, mouseX, mouseY, TooltipScreen.TooltipStyle.LINK);
            }
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(class_2561 title) {
            super(title);
        }

        public TitleItem(String title) {
            super((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            class_327 class_3272 = ((ListMenuScreen)ListMenuScreen.this).field_22787.field_1772;
            int n = this.method_46426() + this.method_25368() / 2;
            int n2 = this.method_46427();
            int n3 = this.method_25364();
            Objects.requireNonNull(ListMenuScreen.this.field_22793);
            graphics.method_27534(class_3272, this.label, n, n2 + (n3 - 9) / 2, -1);
        }
    }
}

