/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.EditingTracker;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ChangeEnumScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.list.IListType;
import com.mrcrayfish.configured.client.screen.list.ListTypes;
import com.mrcrayfish.configured.client.screen.widget.CheckBoxButton;
import com.mrcrayfish.configured.client.screen.widget.ConfiguredButton;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends ListMenuScreen
implements IEditing {
    public static final int TOOLTIP_WIDTH = 200;
    public static final Comparator<ListMenuScreen.Item> SORT_ALPHABETICALLY = (o1, o2) -> {
        if (o1 instanceof FolderItem && o2 instanceof FolderItem) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof FolderItem) && o2 instanceof FolderItem) {
            return 1;
        }
        if (o1 instanceof FolderItem) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    protected final IConfigEntry folderEntry;
    protected final IModConfig config;
    protected final Map<String, String> cachedTextMap = new HashMap<String, String>();
    protected class_4185 saveButton;
    protected class_4185 restoreButton;
    protected CheckBoxButton deepSearchCheckBox;

    private ConfigScreen(class_437 parent, class_2561 title, IModConfig config, IConfigEntry folderEntry) {
        super(parent, title, 24);
        this.config = config;
        this.folderEntry = folderEntry;
    }

    public ConfigScreen(class_437 parent, class_2561 title, IModConfig config) {
        super(parent, title, 24);
        this.config = config;
        this.folderEntry = config.createRootEntry();
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    public void method_25432() {
        this.cachedTextMap.clear();
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        ArrayList<ListMenuScreen.Item> configEntries = new ArrayList<ListMenuScreen.Item>();
        this.folderEntry.getChildren().forEach(entry -> {
            ListMenuScreen.Item item = this.createItemFromEntry((IConfigEntry)entry);
            if (item != null) {
                configEntries.add(item);
            }
        });
        configEntries.sort(SORT_ALPHABETICALLY);
        entries.addAll(configEntries);
    }

    @Nullable
    private ListMenuScreen.Item createItemFromEntry(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<Boolean> value = entry.getValue();
            if (value != null) {
                ConfigItem configItem;
                Object object;
                Object obj = object = value.get();
                int n = 0;
                block9: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Integer.class, Double.class, Long.class, Enum.class, String.class, List.class}, obj, n)) {
                        case 0: {
                            Boolean b = (Boolean)obj;
                            configItem = new BooleanItem(value);
                            break block9;
                        }
                        case 1: {
                            Integer i = (Integer)obj;
                            configItem = new IntegerItem(this, (IConfigValue<Integer>)value);
                            break block9;
                        }
                        case 2: {
                            Double v = (Double)obj;
                            configItem = new DoubleItem(this, (IConfigValue<Double>)value);
                            break block9;
                        }
                        case 3: {
                            Long l = (Long)obj;
                            configItem = new LongItem(this, (IConfigValue<Long>)value);
                            break block9;
                        }
                        case 4: {
                            Enum e = (Enum)obj;
                            configItem = new EnumItem((IConfigValue<Enum<?>>)value);
                            break block9;
                        }
                        case 5: {
                            String s = (String)obj;
                            configItem = new StringItem((IConfigValue<String>)value);
                            break block9;
                        }
                        case 6: {
                            List li = (List)obj;
                            if (ListTypes.getTypeUnsafe(value) == ListTypes.UNKNOWN) {
                                n = 7;
                                continue block9;
                            }
                            configItem = new ListItem((IConfigValue<List<?>>)value);
                            break block9;
                        }
                        default: {
                            Constants.LOG.warn("Unsupported config value '{}' from '{}'", (Object)value.getName(), (Object)this.config.getFileName());
                            configItem = null;
                            break block9;
                        }
                    }
                    break;
                }
                return configItem;
            }
            return null;
        }
        return new FolderItem(entry);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.folderEntry.isRoot()) {
            this.saveButton = (class_4185)this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 140, this.field_22790 - 29, 22, 0, 90, (class_2561)class_2561.method_43471((String)"configured.gui.save"), button -> {
                Runnable saveTask = () -> {
                    ActionResult saveResult = this.saveConfig();
                    if (!saveResult.asBoolean()) {
                        class_2561 message = saveResult.message().orElse((class_2561)class_2561.method_43471((String)"configured.gui.update_error.generic"));
                        ConfirmationScreen.showError(this.field_22787, this.parent, message);
                    } else if (ConfigHelper.getChangedValues(this.folderEntry).stream().anyMatch(IConfigValue::requiresGameRestart)) {
                        ConfirmationScreen.showInfo(this.field_22787, this.parent, (class_2561)class_2561.method_43471((String)"configured.gui.game_restart_needed"));
                    } else if (this.field_22787.field_1687 != null && ConfigHelper.getChangedValues(this.folderEntry).stream().anyMatch(IConfigValue::requiresWorldRestart)) {
                        ConfirmationScreen.showInfo(this.field_22787, this.parent, (class_2561)class_2561.method_43471((String)"configured.gui.world_restart_needed"));
                    } else {
                        this.field_22787.method_1507(this.parent);
                    }
                };
                ActionResult confirmationResult = this.config.showSaveConfirmation((class_1657)this.field_22787.field_1724);
                if (confirmationResult.asBoolean() && confirmationResult.message().isPresent()) {
                    this.field_22787.method_1507((class_437)this.createSaveConfirmationScreen(confirmationResult, saveTask));
                } else {
                    saveTask.run();
                }
            }));
            this.restoreButton = (class_4185)this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 45, this.field_22790 - 29, 0, 0, 90, (class_2561)class_2561.method_43471((String)"configured.gui.reset_all"), button -> {
                if (this.folderEntry.isRoot()) {
                    this.showRestoreScreen();
                }
            }));
            this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 + 50, this.field_22790 - 29, 90, 20, class_5244.field_24335, button -> {
                if (this.isChanged(this.folderEntry)) {
                    this.field_22787.method_1507((class_437)new ActiveConfirmationScreen(this, this.config, (class_2561)class_2561.method_43471((String)"configured.gui.unsaved_changes"), ConfirmationScreen.Icon.WARNING, result -> {
                        if (!result.booleanValue()) {
                            return true;
                        }
                        this.field_22787.method_1507(this.parent);
                        return false;
                    }));
                } else {
                    this.field_22787.method_1507(this.parent);
                }
            }));
            this.updateButtons();
        } else {
            this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 130, this.field_22790 - 29, 22, 44, 128, (class_2561)class_2561.method_43471((String)"configured.gui.home"), button -> {
                ConfigScreen target = this;
                while (target.parent instanceof ConfigScreen) {
                    target = (ConfigScreen)target.parent;
                }
                this.field_22787.method_1507((class_437)target);
            }));
            this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 + 2, this.field_22790 - 29, 128, 20, class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
        }
        this.deepSearchCheckBox = new CheckBoxButton(this.field_22789 / 2 + 115, 25, button -> this.updateSearchResults());
        this.method_37063((class_364)this.deepSearchCheckBox);
    }

    private ActiveConfirmationScreen createSaveConfirmationScreen(ActionResult confirmationResult, Runnable saveTask) {
        ActiveConfirmationScreen screen = new ActiveConfirmationScreen(this, this.config, confirmationResult.message().get(), ConfirmationScreen.Icon.INFO, result -> {
            if (result.booleanValue()) {
                saveTask.run();
                return false;
            }
            return true;
        });
        screen.setPositiveText((class_2561)class_2561.method_43471((String)"configured.gui.save"));
        screen.setNegativeText(class_5244.field_24339);
        return screen;
    }

    private ActionResult saveConfig() {
        if (!this.isChanged(this.folderEntry) || this.config == null) {
            return ActionResult.success();
        }
        ActionResult result = this.config.update(this.folderEntry);
        if (result.asBoolean()) {
            EditingTracker.instance().markChanged();
        }
        return result;
    }

    private void showRestoreScreen() {
        ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (class_2561)class_2561.method_43471((String)"configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
            if (!result.booleanValue()) {
                return true;
            }
            this.restoreDefaults(this.folderEntry);
            this.updateButtons();
            return true;
        });
        confirmScreen.setPositiveText((class_2561)class_2561.method_43471((String)"configured.gui.reset_all").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        confirmScreen.setNegativeText(class_5244.field_24335);
        class_310.method_1551().method_1507((class_437)confirmScreen);
    }

    private void restoreDefaults(IConfigEntry entry) {
        for (IConfigEntry child : entry.getChildren()) {
            if (child.isLeaf()) {
                IConfigValue<?> value = child.getValue();
                if (value == null) continue;
                value.restore();
                continue;
            }
            this.restoreDefaults(child);
        }
    }

    private void updateButtons() {
        if (this.folderEntry.isRoot()) {
            if (this.saveButton != null) {
                boolean bl = this.saveButton.field_22763 = !this.config.isReadOnly() && this.isChanged(this.folderEntry);
            }
            if (this.restoreButton != null) {
                this.restoreButton.field_22763 = !this.config.isReadOnly() && this.isModified(this.folderEntry);
            }
        }
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.config.isReadOnly()) {
            graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.field_22789 - 30, 14, 0.0f, 33.0f, 20, 20, 10, 10, 64, 64);
            if (ScreenUtil.isMouseWithin(this.field_22789 - 30, 14, 20, 20, mouseX, mouseY)) {
                this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.read_only_config"), mouseX, mouseY, TooltipScreen.TooltipStyle.HINT);
            }
        }
        if (this.deepSearchCheckBox.method_25405(mouseX, mouseY)) {
            this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.deep_search"), mouseX, mouseY);
        }
    }

    @Override
    protected Collection<ListMenuScreen.Item> getSearchResults(String s) {
        ArrayList<ListMenuScreen.Item> entries = this.entries;
        if (this.deepSearchCheckBox.isSelected()) {
            ArrayList<ListMenuScreen.Item> allEntries = new ArrayList<ListMenuScreen.Item>();
            ConfigHelper.gatherAllConfigEntries(this.folderEntry).forEach(entry -> {
                ListMenuScreen.Item item = this.createItemFromEntry((IConfigEntry)entry);
                if (item instanceof ConfigItem) {
                    allEntries.add(item);
                }
            });
            allEntries.sort(SORT_ALPHABETICALLY);
            entries = allEntries;
        }
        return entries.stream().filter(item -> {
            if (item instanceof ListMenuScreen.IIgnoreSearch) {
                return false;
            }
            if (item instanceof FolderItem && !Config.isIncludeFoldersInSearch()) {
                return false;
            }
            return item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH));
        }).collect(Collectors.toList());
    }

    private static String createLabelFromHolder(IConfigValue<?> holder) {
        if (holder.getTranslationKey() != null && class_1074.method_4663((String)holder.getTranslationKey())) {
            return class_2561.method_43471((String)holder.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(holder.getName());
    }

    public static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("[_\\-.]");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    private static List<class_5348> splitTooltip(class_5348 text) {
        return class_310.method_1551().field_1772.method_27527().method_27495(text, 200, class_2583.field_24360);
    }

    public boolean method_25422() {
        return this.config == null || this.config.getType() != ConfigType.WORLD;
    }

    public boolean isModified(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && !value.isDefault();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isModified(child)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && value.isChanged();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isChanged(child)) continue;
            return true;
        }
        return false;
    }

    public class BooleanItem
    extends ConfigItem<Boolean> {
        private final class_4185 button;

        public BooleanItem(IConfigValue<Boolean> holder) {
            super(holder);
            this.button = ScreenUtil.button(10, 5, 46, 20, class_5244.method_36134((boolean)holder.get()), button -> {
                holder.set((Boolean)holder.get() == false);
                button.method_25355(class_5244.method_36134((boolean)((Boolean)holder.get())));
                ConfigScreen.this.updateButtons();
            });
            this.button.field_22763 = !ConfigScreen.this.config.isReadOnly();
            this.eventListeners.add(this.button);
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            super.method_25343(graphics, mouseX, mouseY, hovered, partialTick);
            this.button.method_46421(this.method_46426() + this.method_25368() - 69);
            this.button.method_46419(this.method_46427());
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public void onResetValue() {
            this.button.method_25355(class_5244.method_36134((boolean)((Boolean)this.holder.get())));
        }
    }

    public class IntegerItem
    extends NumberItem<Integer> {
        public IntegerItem(ConfigScreen this$0, IConfigValue<Integer> holder) {
            super(holder, Integer::parseInt);
        }
    }

    public class DoubleItem
    extends NumberItem<Double> {
        public DoubleItem(ConfigScreen this$0, IConfigValue<Double> holder) {
            super(holder, Double::parseDouble);
        }
    }

    public class LongItem
    extends NumberItem<Long> {
        public LongItem(ConfigScreen this$0, IConfigValue<Long> holder) {
            super(holder, Long::parseLong);
        }
    }

    public class EnumItem
    extends ConfigItem<Enum<?>> {
        private final class_4185 button;

        public EnumItem(IConfigValue<Enum<?>> holder) {
            super(holder);
            class_5250 buttonText = ConfigScreen.this.config.isReadOnly() ? class_2561.method_43471((String)"configured.gui.view") : class_2561.method_43471((String)"configured.gui.change");
            this.button = ScreenUtil.button(10, 5, 46, 20, (class_2561)buttonText, button -> class_310.method_1551().method_1507((class_437)new ChangeEnumScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, (Enum)holder.get(), holder, e -> {
                holder.set((Enum<?>)e);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            super.method_25343(graphics, mouseX, mouseY, hovered, partialTick);
            this.button.method_46421(this.method_46426() + this.method_25368() - 69);
            this.button.method_46419(this.method_46427());
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    public class StringItem
    extends ConfigItem<String> {
        private final class_4185 button;

        public StringItem(IConfigValue<String> holder) {
            super(holder);
            class_5250 buttonText = ConfigScreen.this.config.isReadOnly() ? class_2561.method_43471((String)"configured.gui.view") : class_2561.method_43471((String)"configured.gui.edit");
            this.button = ScreenUtil.button(10, 5, 46, 20, (class_2561)buttonText, button -> class_310.method_1551().method_1507((class_437)new EditStringScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, (String)holder.get(), s -> holder.isValid((String)s) ? Pair.of((Object)true, (Object)class_5244.field_39003) : Pair.of((Object)false, (Object)holder.getValidationHint()), s -> {
                holder.set((String)s);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            super.method_25343(graphics, mouseX, mouseY, hovered, partialTick);
            this.button.method_46421(this.method_46426() + this.method_25368() - 69);
            this.button.method_46419(this.method_46427());
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    public class ListItem
    extends ConfigItem<List<?>> {
        private final class_4185 button;
        private final IListType<?> listType;

        public ListItem(IConfigValue<List<?>> holder) {
            super(holder);
            class_5250 buttonText = ConfigScreen.this.config.isReadOnly() ? class_2561.method_43471((String)"configured.gui.view") : class_2561.method_43471((String)"configured.gui.edit");
            this.button = ScreenUtil.button(10, 5, 46, 20, (class_2561)buttonText, button -> class_310.method_1551().method_1507(new EditListScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, holder)));
            this.listType = ListTypes.getType(holder);
            if (this.listType == ListTypes.getUnknown()) {
                this.button.field_22763 = false;
            }
            this.eventListeners.add(this.button);
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            super.method_25343(graphics, mouseX, mouseY, hovered, partialTick);
            this.button.method_46421(this.method_46426() + this.method_25368() - 69);
            this.button.method_46419(this.method_46427());
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
            if (this.listType == ListTypes.getUnknown() && this.button.method_49606()) {
                ConfigScreen.this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.unsupported_property"), mouseX, mouseY, TooltipScreen.TooltipStyle.ERROR);
            }
        }
    }

    public class FolderItem
    extends ListMenuScreen.Item {
        private final IconButton button;

        public FolderItem(IConfigEntry entry) {
            super((ListMenuScreen)ConfigScreen.this, FolderItem.createLabelForFolderEntry(entry));
            this.button = new IconButton(10, 5, 11, 33, 0, (class_2561)class_2561.method_43470((String)this.getLabel()).method_27692(class_124.field_1067).method_27692(class_124.field_1068), onPress -> {
                class_5250 newTitle = ConfigScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_27693(this.getLabel());
                ConfigScreen.this.field_22787.method_1507((class_437)new ConfigScreen(ConfigScreen.this, (class_2561)newTitle, ConfigScreen.this.config, entry));
            });
            if (entry.getTooltip() != null) {
                this.tooltip = class_2477.method_10517().method_30933(ConfigScreen.splitTooltip((class_5348)entry.getTooltip()));
            }
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.button));
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            super.method_25343(graphics, mouseX, mouseY, hovered, partialTick);
            this.button.method_46421(this.method_46426() - 1);
            this.button.method_46419(this.method_46427());
            this.button.method_25358(this.method_25368());
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        private static class_2561 createLabelForFolderEntry(IConfigEntry entry) {
            String key = entry.getTranslationKey();
            if (key != null && class_1074.method_4663((String)key)) {
                return class_2561.method_43471((String)key);
            }
            return class_2561.method_43470((String)ConfigScreen.createLabel(entry.getEntryName()));
        }
    }

    public abstract class ConfigItem<T>
    extends ListMenuScreen.Item {
        protected final IConfigValue<T> holder;
        protected final List<class_364> eventListeners;
        protected final ConfiguredButton resetButton;
        protected class_2561 validationHint;

        public ConfigItem(IConfigValue<T> holder) {
            super((ListMenuScreen)ConfigScreen.this, ConfigScreen.createLabelFromHolder(holder));
            this.eventListeners = new ArrayList<class_364>();
            this.holder = holder;
            this.tooltip = this.createToolTip(holder);
            int maxTooltipWidth = Math.max(ConfigScreen.this.field_22789 / 2 - 43, 170);
            this.resetButton = new IconButton(0, 0, 0, 0, onPress -> {
                this.holder.restore();
                this.onResetValue();
                ConfigScreen.this.updateButtons();
            });
            this.resetButton.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"configured.gui.reset")), btn -> btn.method_37303() && btn.method_25367());
            this.resetButton.field_22763 = !ConfigScreen.this.config.isReadOnly();
            this.eventListeners.add((class_364)this.resetButton);
        }

        protected void onResetValue() {
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.eventListeners;
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            boolean showValidationHint = this.validationHint != null;
            int trimLength = showValidationHint ? 100 : 80;
            class_124 labelStyle = this.holder.isChanged() ? Config.getChangedFormatting() : class_124.field_1070;
            graphics.method_27535(class_310.method_1551().field_1772, (class_2561)this.getTrimmedLabel(this.method_25368() - trimLength).method_27692(labelStyle), this.method_46426(), this.method_46427() + 6, -1);
            if (showValidationHint) {
                graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.method_46426() + this.method_25368() - 88, this.method_46427() + 3, 11.0f, 11.0f, 16, 16, 11, 11, 64, 64);
            }
            if (!ConfigScreen.this.config.isReadOnly() && (this.holder.requiresGameRestart() || this.holder.requiresWorldRestart())) {
                boolean gameRestart = this.holder.requiresGameRestart();
                graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.method_46426() - 18, this.method_46427() + 5, gameRestart ? 51.0f : 11.0f, 22.0f, 11, 11, 11, 11, 64, 64);
                if (ScreenUtil.isMouseWithin(this.method_46426() - 18, this.method_46427() + 5, 11, 11, mouseX, mouseY)) {
                    String translationKey = gameRestart ? "configured.gui.requires_game_restart" : "configured.gui.requires_world_restart";
                    TooltipScreen.TooltipStyle style = gameRestart ? TooltipScreen.TooltipStyle.HINT : TooltipScreen.TooltipStyle.SUCCESS;
                    ConfigScreen.this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)translationKey), mouseX, mouseY, style);
                }
            }
            if (this.method_25405(mouseX, mouseY)) {
                if (showValidationHint && ScreenUtil.isMouseWithin(this.method_46426() + this.method_25368() - 92, this.method_46427(), 23, 20, mouseX, mouseY)) {
                    ConfigScreen.this.setActiveTooltip(graphics, this.validationHint, mouseX, mouseY, TooltipScreen.TooltipStyle.ERROR);
                } else if (mouseX < ConfigScreen.this.list.method_25342() + ConfigScreen.this.list.method_25322() - 69) {
                    ConfigScreen.this.setActiveTooltip(graphics, this.tooltip, mouseX, mouseY);
                }
            }
            this.resetButton.field_22763 = !this.holder.isDefault() && !ConfigScreen.this.config.isReadOnly();
            this.resetButton.method_46421(this.method_46426() + this.method_25368() - 21);
            this.resetButton.method_46419(this.method_46427());
            this.resetButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        private class_5250 getTrimmedLabel(int maxWidth) {
            if (((ConfigScreen)ConfigScreen.this).field_22787.field_1772.method_27525((class_5348)this.label) > maxWidth) {
                return class_2561.method_43470((String)(((ConfigScreen)ConfigScreen.this).field_22787.field_1772.method_1714((class_5348)this.label, maxWidth).getString() + "..."));
            }
            return this.label.method_27661();
        }

        @Nullable
        private List<class_5481> createToolTip(IConfigValue<T> holder) {
            class_2561 comment = holder.getComment();
            if (comment != null) {
                int i;
                class_327 font = class_310.method_1551().field_1772;
                List lines = font.method_27527().method_27495((class_5348)comment, 200, class_2583.field_24360);
                String name = holder.getName();
                lines.add(0, class_2561.method_43470((String)name).method_27692(class_124.field_1054));
                int rangeIndex = -1;
                for (i = 0; i < lines.size(); ++i) {
                    String text = ((class_5348)lines.get(i)).getString();
                    if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                    rangeIndex = i;
                    break;
                }
                if (rangeIndex != -1) {
                    for (i = rangeIndex; i < lines.size(); ++i) {
                        lines.set(i, class_2561.method_43470((String)((class_5348)lines.get(i)).getString()).method_27692(class_124.field_1080));
                    }
                }
                return class_2477.method_10517().method_30933(lines);
            }
            return null;
        }

        public void setValidationHint(class_2561 text) {
            this.validationHint = text;
        }
    }

    public abstract class NumberItem<T extends Number>
    extends ConfigItem<T> {
        private final ListMenuScreen.FocusedEditBox textField;
        private long lastTick;

        public NumberItem(IConfigValue<T> holder, Function<String, Number> parser) {
            super(holder);
            String text = ConfigScreen.this.cachedTextMap.getOrDefault(holder.getName(), ((Number)holder.get()).toString());
            this.textField = new ListMenuScreen.FocusedEditBox(ConfigScreen.this, ConfigScreen.this.field_22793, 0, 0, 44, 18, this.label);
            this.textField.method_1863(s -> {
                ConfigScreen.this.cachedTextMap.put(holder.getName(), (String)s);
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (holder.isValid(n)) {
                        this.textField.method_1868(-2039584);
                        holder.set(n);
                        ConfigScreen.this.updateButtons();
                        this.setValidationHint(null);
                    } else {
                        this.textField.method_1868(-65536);
                        this.setValidationHint(holder.getValidationHint());
                    }
                }
                catch (Exception ignored) {
                    this.textField.method_1868(-65536);
                    this.setValidationHint((class_2561)class_2561.method_43471((String)"configured.validator.not_a_number"));
                }
            });
            this.textField.method_1852(text);
            this.textField.method_1888(!ConfigScreen.this.config.isReadOnly());
            this.eventListeners.add(this.textField);
        }

        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            super.method_25343(graphics, mouseX, mouseY, hovered, partialTick);
            long time = class_156.method_658();
            if (time - this.lastTick >= 50L) {
                this.lastTick = time;
            }
            this.textField.method_46421(this.method_46426() + this.method_25368() - 68);
            this.textField.method_46419(this.method_46427() + 1);
            this.textField.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public void onResetValue() {
            this.textField.method_1852(((Number)this.holder.get()).toString());
        }
    }
}

