/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IAllowedEnums;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class ChangeEnumScreen
extends TooltipScreen
implements IEditing {
    private final class_437 parent;
    private final IModConfig config;
    private final Consumer<Enum<?>> onSave;
    private final IConfigValue<Enum<?>> holder;
    private Enum<?> selectedValue;
    private EnumList list;
    private List<Entry> entries;
    private class_342 searchTextField;

    protected ChangeEnumScreen(class_437 parent, IModConfig config, class_2561 title, Enum<?> value, IConfigValue<Enum<?>> holder, Consumer<Enum<?>> onSave) {
        super(title);
        this.parent = parent;
        this.config = config;
        this.onSave = onSave;
        this.holder = holder;
        this.selectedValue = value;
    }

    protected void method_25426() {
        this.constructEntries();
        this.list = new EnumList(this.entries);
        this.list.method_25313((class_350.class_351)((Entry)this.list.method_25396().stream().filter(entry -> entry.getEnumValue() == this.selectedValue).findFirst().orElse(null)));
        this.method_25429((class_364)this.list);
        this.searchTextField = new class_342(this.field_22793, this.field_22789 / 2 - 110, 22, 220, 20, (class_2561)class_2561.method_43471((String)"configured.gui.search"));
        this.searchTextField.method_1863(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.method_25314(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(entry -> entry.getFormattedLabel().getString().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.method_44382(0.0);
            }
        });
        this.method_25429((class_364)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
        int buttonWidth = 128;
        int spacing = 2;
        if (!this.config.isReadOnly()) {
            this.method_37063((class_364)new IconButton(this.field_22789 / 2 - buttonWidth - spacing, this.field_22790 - 29, 0, 44, buttonWidth, (class_2561)class_2561.method_43471((String)"configured.gui.apply"), button -> {
                if (this.list.method_25334() != null) {
                    this.onSave.accept(((Entry)this.list.method_25334()).enumValue);
                }
                this.field_22787.method_1507(this.parent);
            }));
        }
        int cancelOffset = this.config.isReadOnly() ? -(buttonWidth / 2) : spacing;
        class_2561 cancelLabel = this.config.isReadOnly() ? class_5244.field_24339 : class_5244.field_24335;
        this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 + cancelOffset, this.field_22790 - 29, buttonWidth, 20, cancelLabel, button -> this.field_22787.method_1507(this.parent)));
    }

    private void constructEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (this.holder instanceof IAllowedEnums) {
            ((IAllowedEnums)((Object)this.holder)).getAllowedValues().forEach(e -> entries.add(new Entry((Enum)e)));
        } else {
            Enum<?> value = this.selectedValue;
            if (value != null) {
                ?[] enums;
                for (Object e2 : enums = value.getDeclaringClass().getEnumConstants()) {
                    entries.add(new Entry((Enum)e2));
                }
            }
        }
        entries.sort(Comparator.comparing(entry -> entry.getFormattedLabel().getString()));
        this.entries = ImmutableList.copyOf(entries);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.list.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25302(class_10799.field_56883, IconButton.ICONS, this.field_22789 / 2 - 128, 26, 22.0f, 11.0f, 14, 14, 10, 10, 64, 64);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 7, -1);
        graphics.method_25290(class_10799.field_56883, ListMenuScreen.CONFIGURED_LOGO, 10, 13, 0.0f, 0.0f, 23, 23, 32, 32);
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(graphics, (class_2561)class_2561.method_43471((String)"configured.gui.info"), mouseX, mouseY);
        }
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    public class EnumList
    extends class_350<Entry> {
        public EnumList(List<Entry> entries) {
            super(ChangeEnumScreen.this.field_22787, ChangeEnumScreen.this.field_22789, ChangeEnumScreen.this.field_22790 - 36 - 50, 50, 20);
            entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        public void method_25314(Collection<Entry> entries) {
            super.method_25314(entries);
        }

        protected void method_47399(class_6382 output) {
            if (this.method_25334() != null) {
                output.method_37034(class_6381.field_33788, ((Entry)this.method_25334()).label);
            }
        }

        public boolean method_25405(double mouseX, double mouseY) {
            if (ChangeEnumScreen.this.config.isReadOnly()) {
                return false;
            }
            return super.method_25405(mouseX, mouseY);
        }
    }

    public class Entry
    extends class_4280.class_4281<Entry>
    implements ILabelProvider {
        private final Enum<?> enumValue;
        private final class_2561 label;

        public Entry(Enum<?> enumValue) {
            this.enumValue = enumValue;
            this.label = class_2561.method_43470((String)ConfigScreen.createLabel(enumValue.name().toLowerCase(Locale.ENGLISH)));
        }

        public Enum<?> getEnumValue() {
            return this.enumValue;
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public class_2561 getFormattedLabel() {
            return this.label;
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            class_5250 label = class_2561.method_43470((String)this.label.getString()).method_27692(ChangeEnumScreen.this.list.method_25334() == this ? class_124.field_1054 : class_124.field_1068);
            graphics.method_27535(((ChangeEnumScreen)ChangeEnumScreen.this).field_22787.field_1772, (class_2561)label, this.method_46426() + 5, this.method_46427() + 6, -1);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            ChangeEnumScreen.this.list.method_25313((class_350.class_351)this);
            ChangeEnumScreen.this.selectedValue = this.enumValue;
            return true;
        }

        public class_2561 method_37006() {
            return this.label;
        }
    }
}

