/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;

public class InventoryHelper {
    public static void mergeItemsOrSpawnIntoLevel(class_2371<class_1799> source, class_2371<class_1799> target, class_1937 level, class_243 pos) {
        for (int i = 0; i < source.size(); ++i) {
            class_1799 stack = (class_1799)source.get(i);
            if (i < target.size()) {
                target.set(i, (Object)stack.method_7972());
                continue;
            }
            InventoryHelper.spawnStack(stack, level, pos);
        }
    }

    public static void mergeInventoryOrSpawnIntoLevel(class_1263 source, class_1263 target, class_1937 level, class_243 pos) {
        for (int i = 0; i < source.method_5439(); ++i) {
            class_1799 stack = source.method_5438(i);
            if (i < target.method_5439() && target.method_5437(i, stack)) {
                target.method_5447(i, stack.method_7972());
                continue;
            }
            InventoryHelper.spawnStack(stack, level, pos);
        }
    }

    public static void spawnStack(class_1799 stack, class_1937 level, class_243 pos) {
        if (!level.method_8608()) {
            class_1542 entity = new class_1542(level, pos.field_1352, pos.field_1351, pos.field_1350, stack.method_51164());
            entity.method_6988();
            level.method_8649((class_1297)entity);
        }
    }

    public static Stream<class_1799> streamFor(class_1263 container) {
        return IntStream.range(0, container.method_5439()).mapToObj(arg_0 -> ((class_1263)container).method_5438(arg_0));
    }

    public static boolean hasRemovableItemAndCount(class_1792 item, int count, List<class_1263> containers) {
        int found = 0;
        for (class_1263 container : containers) {
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 stack = container.method_5438(i);
                if (stack.method_7960() || !stack.method_31574(item) || !container.method_49104(container, i, stack) || (found += stack.method_7947()) < count) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<Runnable> createRemoveItemJob(class_1792 item, int count, List<class_1263> containers) {
        if (item == class_1802.field_8162 || count < 0 || containers.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Runnable> transactions = new ArrayList<Runnable>();
        block0: for (class_1263 container : containers) {
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 stack = container.method_5438(i);
                if (stack.method_7960() || !stack.method_31574(item) || !container.method_49104(container, i, stack)) continue;
                int shrink = Math.min(stack.method_7947(), count);
                count -= shrink;
                transactions.add(() -> {
                    stack.method_7934(shrink);
                    container.method_5431();
                });
                if (shrink == 0) break block0;
            }
        }
        if (count == 0) {
            return Optional.of(() -> transactions.forEach(Runnable::run));
        }
        return Optional.empty();
    }
}

