/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.packs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_7699;
import net.minecraft.class_8824;
import net.minecraft.class_9224;

public record AddonMetadata(class_2561 name, class_2561 description, class_2561 author, class_3281 assetsCompatibility, class_3281 dataCompatibility, class_3264 type) {
    public static final String FILE_NAME = "backpacked_addon.mcmeta";

    public class_3288.class_7679 toVanilla() {
        class_3281 compatibility = switch (this.type) {
            default -> throw new MatchException(null, null);
            case class_3264.field_14188 -> this.assetsCompatibility;
            case class_3264.field_14190 -> this.dataCompatibility;
        };
        return new class_3288.class_7679(this.description, compatibility, class_7699.method_45397(), List.of());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Optional<AddonMetadata>> readAddonMetadata(class_9224 info, class_3288.class_7680 resourcesSupplier, class_3264 type) {
        try (class_3262 resources = resourcesSupplier.method_52424(info);){
            Optional<Optional<AddonMetadataSection>> result = AddonMetadata.readAddonMetadata(info, resources);
            if (result.isEmpty()) {
                Optional<Optional<AddonMetadata>> optional = Optional.empty();
                return optional;
            }
            Optional<AddonMetadataSection> value = result.get();
            if (value.isEmpty()) {
                Constants.LOG.error("Failed to read metadata for Backpacked addon '{}'. Skipping resource", (Object)info.comp_2329());
                Optional<Optional<AddonMetadata>> optional = Optional.of(Optional.empty());
                return optional;
            }
            AddonMetadataSection section = value.get();
            if (section.addonFormat() > 1) {
                Constants.LOG.error("Skipping Backpacked addon '{}' as it was designed for a newer version of Backpacked. Expected addon_format {} or lower, found {}", new Object[]{info.comp_2329(), 1, section.addonFormat});
                Optional<Optional<AddonMetadata>> optional = Optional.of(Optional.empty());
                return optional;
            }
            class_3281 assetsCompatibility = AddonMetadata.readPackCompatibility(section, class_3264.field_14188);
            class_3281 dataCompatibility = AddonMetadata.readPackCompatibility(section, class_3264.field_14190);
            Optional<Optional<AddonMetadata>> optional = Optional.of(Optional.of(new AddonMetadata(section.name, section.description, section.author, assetsCompatibility, dataCompatibility, type)));
            return optional;
        }
        catch (Exception exception) {
            Constants.LOG.warn("Failed to read addon {} metadata", (Object)info.comp_2329(), (Object)exception);
            return Optional.of(Optional.empty());
        }
    }

    private static Optional<Optional<AddonMetadataSection>> readAddonMetadata(class_9224 info, class_3262 resources) throws IOException {
        class_7367 supplier = resources.method_14410(new String[]{FILE_NAME});
        if (supplier != null) {
            try (InputStream is = (InputStream)supplier.get();){
                if (is != null) {
                    Optional<Optional<AddonMetadataSection>> optional = Optional.of(Optional.ofNullable((AddonMetadataSection)class_3255.method_14392(AddonMetadataSection.TYPE, (InputStream)is, (class_9224)info)));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    private static class_3281 readPackCompatibility(AddonMetadataSection section, class_3264 type) {
        int packFormat;
        class_11555 currentFormat = class_155.method_16673().method_70592(type);
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case field_14188: {
                int n = section.assetsFormat();
                break;
            }
            case field_14190: {
                int n = packFormat = section.dataFormat();
            }
        }
        if (packFormat > currentFormat.comp_4416()) {
            return class_3281.field_14220;
        }
        if (packFormat < currentFormat.comp_4417()) {
            return class_3281.field_14223;
        }
        return class_3281.field_14224;
    }

    private record AddonMetadataSection(class_2561 name, class_2561 description, class_2561 author, int addonFormat, int assetsFormat, int dataFormat) {
        public static final Codec<AddonMetadataSection> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_8824.field_46597.fieldOf("name").forGetter(AddonMetadataSection::name), (App)class_8824.field_46597.fieldOf("description").forGetter(AddonMetadataSection::description), (App)class_8824.field_46597.fieldOf("author").forGetter(AddonMetadataSection::author), (App)Codec.INT.fieldOf("addon_format").forGetter(AddonMetadataSection::addonFormat), (App)Codec.INT.fieldOf("assets_format").forGetter(AddonMetadataSection::assetsFormat), (App)Codec.INT.fieldOf("data_format").forGetter(AddonMetadataSection::dataFormat)).apply((Applicative)builder, AddonMetadataSection::new));
        public static final class_7677<AddonMetadataSection> TYPE = new class_7677("backpacked_addon", CODEC);
    }
}

