/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.CreativeCategorySort;
import com.mrcrayfish.backpacked.common.ItemSorting;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.SavedAugments;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModRegistries;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.SyncUnlockableSlots;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageChangeAugment;
import com.mrcrayfish.backpacked.network.message.MessageCheckShelfKey;
import com.mrcrayfish.backpacked.network.message.MessageNavigateBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessagePickpocketBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRenameBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestManagement;
import com.mrcrayfish.backpacked.network.message.MessageResponseShelfKey;
import com.mrcrayfish.backpacked.network.message.MessageSetAugmentState;
import com.mrcrayfish.backpacked.network.message.MessageSortBackpack;
import com.mrcrayfish.backpacked.network.message.MessageSyncAugmentChange;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockAugmentBay;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockSlot;
import com.mrcrayfish.backpacked.network.message.MessageUnlockAugmentBay;
import com.mrcrayfish.backpacked.network.message.MessageUnlockSlot;
import com.mrcrayfish.backpacked.network.message.MessageUpdateAugment;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.network.PlayMessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3544;
import net.minecraft.class_3989;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, PlayMessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        class_1799 stack = BackpackHelper.getBackpackStack(player, message.backpackIndex());
        if (stack.method_7960()) {
            return;
        }
        CosmeticProperties properties = message.properties();
        Optional<class_2960> cosmeticOptional = properties.cosmetic();
        if (cosmeticOptional.isPresent()) {
            class_2960 cosmetic = cosmeticOptional.get();
            Backpack backpack = BackpackManager.instance().getBackpack(cosmetic);
            if (backpack == null) {
                return;
            }
            if (BackpackHelper.isCosmeticDisabled(backpack.getId())) {
                return;
            }
            if (!backpack.isUnlocked(player) && !((Boolean)Config.BACKPACK.cosmetics.unlockAllCosmetics.get()).booleanValue()) {
                return;
            }
        }
        stack.method_57379((class_9331)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)properties);
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, PlayMessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 opener = (class_3222)player;
        int backpackIndex = message.backpackIndex();
        if (backpackIndex == -1) {
            backpackIndex = BackpackHelper.getSelectedBackpackIndex((class_1657)opener);
        }
        BackpackItem.openBackpack(opener, opener, backpackIndex);
    }

    public static void handlePickpocketBackpack(MessagePickpocketBackpack message, PlayMessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 opener = (class_3222)player;
        class_1297 entity = opener.method_51469().method_8469(message.entityId());
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 target = (class_1309)entity;
        if (!((Boolean)Config.PICKPOCKETING.enabled.get()).booleanValue() && target instanceof class_3222) {
            return;
        }
        if (!PickpocketUtil.canSeeBackpack(target, (class_1657)opener)) {
            return;
        }
        if (target instanceof class_3222) {
            class_3222 targetPlayer = (class_3222)target;
            int backpackIndex = BackpackHelper.firstAvailableBackpackIndex((class_1657)targetPlayer);
            if (BackpackItem.openBackpack(targetPlayer, opener, backpackIndex)) {
                targetPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.backpacked.player_opened"), true);
                player.method_73183().method_43128((class_1297)player, targetPlayer.method_23317(), targetPlayer.method_23318() + 1.0, targetPlayer.method_23321(), (class_3414)class_3417.field_14581.comp_349(), class_3419.field_15248, 0.75f, 1.0f);
            }
        } else if (target instanceof class_3989) {
            class_3989 trader = (class_3989)target;
            WanderingTraderEvents.openBackpack(trader, opener);
        }
    }

    public static void handleNavigateBackpack(MessageNavigateBackpack message, PlayMessageContext context) {
        class_1297 class_12972;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 opener = (class_3222)player;
        class_1703 class_17032 = opener.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu)) {
            return;
        }
        BackpackContainerMenu menu = (BackpackContainerMenu)class_17032;
        int ownerId = menu.getOwnerId();
        if (ownerId < 0 || !((class_12972 = opener.method_51469().method_8469(ownerId)) instanceof class_3222)) {
            return;
        }
        class_3222 target = (class_3222)class_12972;
        int backpackIndex = menu.getBackpackIndex();
        if (backpackIndex < 0 || backpackIndex >= (Integer)Config.BACKPACK.equipable.maxEquipable.get()) {
            return;
        }
        if (!Objects.equals(opener, target) && !PickpocketUtil.canSeeBackpack((class_1309)target, (class_1657)opener)) {
            opener.method_7346();
            return;
        }
        backpackIndex = BackpackHelper.navigateBackpackIndex((class_1657)target, backpackIndex, message.navigate());
        if (menu.getBackpackIndex() == backpackIndex) {
            return;
        }
        BackpackItem.openBackpack(target, opener, backpackIndex);
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, PlayMessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (((Boolean)Config.BACKPACK.cosmetics.disableCustomisation.get()).booleanValue()) {
            return;
        }
        class_1799 stack = BackpackHelper.getBackpackStack((class_1657)serverPlayer, message.backpackIndex());
        if (stack.method_7960()) {
            return;
        }
        boolean showCosmeticWarning = BackpackHelper.getFirstBackpackStack((class_1657)serverPlayer) != stack;
        HashMap<class_2960, class_2561> labelMap = new HashMap<class_2960, class_2561>();
        HashMap<class_2960, Double> completionMap = new HashMap<class_2960, Double>();
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> {
            for (Backpack backpack : BackpackManager.instance().getBackpacks()) {
                if (BackpackHelper.isCosmeticDisabled(backpack.getId()) || unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> {
                    labelMap.put(backpack.getId(), progressTracker.getDisplayComponent());
                    completionMap.put(backpack.getId(), progressTracker.getCompletionProgress());
                });
            }
        });
        CosmeticProperties properties = (CosmeticProperties)stack.method_58695((class_9331)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT);
        serverPlayer.method_7346();
        Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageOpenCustomisation(message.backpackIndex(), labelMap, properties, showCosmeticWarning, completionMap));
    }

    public static void handleRequestManagement(MessageRequestManagement message, PlayMessageContext context) {
        context.getPlayer().ifPresent(player -> {
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof BackpackContainerMenu) {
                BackpackContainerMenu menu = (BackpackContainerMenu)patt0$temp;
                menu.openManagement((class_3222)player);
            } else {
                BackpackItem.openBackpackManagement((class_3222)player, true);
            }
        });
    }

    public static void handleUnlockSlot(MessageUnlockSlot message, PlayMessageContext context) {
        context.getPlayer().ifPresent(player -> {
            if (!(player instanceof class_3222)) {
                return;
            }
            class_1703 menu = player.field_7512;
            if (menu == null || !menu.method_7597(player)) {
                return;
            }
            for (int slotIndex : message.slotIndexes()) {
                if (slotIndex >= 0 && slotIndex < menu.field_7761.size()) continue;
                throw new IllegalArgumentException("Invalid slot index: " + slotIndex);
            }
            ArrayList<UnlockableSlot> changed = new ArrayList<UnlockableSlot>();
            for (int slotIndex : message.slotIndexes()) {
                UnlockableSlot slot2;
                class_1735 patt0$temp = menu.method_7611(slotIndex);
                if (!(patt0$temp instanceof UnlockableSlot) || !(slot2 = (UnlockableSlot)patt0$temp).unlock((class_1657)player)) continue;
                changed.add(slot2);
            }
            if (changed.isEmpty()) {
                return;
            }
            changed.stream().map(slot -> slot.field_7871).distinct().forEach(class_1263::method_5431);
            if (menu instanceof SyncUnlockableSlots) {
                ((SyncUnlockableSlots)menu).handleSyncSlots((class_3222)player, changed);
            } else {
                List<Integer> slotIndexes = changed.stream().map(slot -> slot.field_7874).toList();
                Network.PLAY.sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncUnlockSlot(slotIndexes));
            }
        });
    }

    public static void handleChangeAugment(MessageChangeAugment message, PlayMessageContext context) {
        Augment<?> currentAugment;
        BackpackContainerMenu menu;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)class_17032).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        class_1799 stack = BackpackHelper.getBackpackStack((class_1657)serverPlayer, backpackIndex);
        if (stack.method_7960()) {
            return;
        }
        AugmentType type = (AugmentType)ModRegistries.AUGMENT_TYPES.getValue(message.augmentTypeId());
        if (type == null) {
            throw new IllegalArgumentException("Player sent an invalid augment type");
        }
        if (Config.getDisabledAugments().contains(type.id())) {
            return;
        }
        Augments currentAugments = Augments.get(stack);
        SavedAugments savedAugments = SavedAugments.get(stack);
        if (!type.isEmpty() && currentAugments.has(type)) {
            return;
        }
        Augment<?> updatedAugment = savedAugments.getSavedOrCreateDefault(type);
        if (updatedAugment.equals(currentAugment = currentAugments.getAugment(message.position()))) {
            return;
        }
        if (currentAugment.type() != updatedAugment.type()) {
            savedAugments = savedAugments.add(currentAugment);
        }
        savedAugments = savedAugments.remove(updatedAugment);
        currentAugments = currentAugments.setAugment(message.position(), updatedAugment);
        SavedAugments.set(stack, savedAugments);
        Augments.set(stack, currentAugments);
        menu.setAugments(currentAugments);
        Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageSyncAugmentChange(message.position(), updatedAugment));
    }

    public static void handleSetAugmentState(MessageSetAugmentState message, PlayMessageContext context) {
        BackpackContainerMenu menu;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)class_17032).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        class_1799 stack = BackpackHelper.getBackpackStack((class_1657)serverPlayer, backpackIndex);
        if (stack.method_7960()) {
            return;
        }
        Augments.set(stack, Augments.get(stack).setState(message.position(), message.state()));
    }

    public static void handleUpdateAugment(MessageUpdateAugment message, PlayMessageContext context) {
        BackpackContainerMenu menu;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)class_17032).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        class_1799 stack = BackpackHelper.getBackpackStack((class_1657)serverPlayer, backpackIndex);
        if (stack.method_7960()) {
            return;
        }
        Augments currentAugments = Augments.get(stack);
        Augment<?> currentAugment = currentAugments.getAugment(message.position());
        Augment<?> updatedAugment = message.augment();
        if (currentAugment.type() != updatedAugment.type()) {
            return;
        }
        if (Objects.equals(currentAugment, updatedAugment = updatedAugment.onUpdate(serverPlayer, currentAugment))) {
            return;
        }
        currentAugments = currentAugments.setAugment(message.position(), updatedAugment);
        Augments.set(stack, currentAugments);
        menu.setAugments(currentAugments);
        Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageSyncAugmentChange(message.position(), updatedAugment));
    }

    public static void handleRenameBackpack(MessageRenameBackpack message, PlayMessageContext context) {
        BackpackContainerMenu menu;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)class_17032).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        class_1799 stack = BackpackHelper.getBackpackStack((class_1657)serverPlayer, backpackIndex);
        if (stack.method_7960()) {
            return;
        }
        String value = class_3544.method_57180((String)message.value());
        if (value.length() <= 50) {
            if (class_3544.method_57181((String)value)) {
                stack.method_57381(class_9334.field_49631);
            } else {
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)value));
            }
            BackpackItem.openBackpack(serverPlayer, serverPlayer, backpackIndex);
        }
    }

    public static void handleSortBackpack(MessageSortBackpack message, PlayMessageContext context) {
        class_1799 stack;
        int i;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu)) {
            return;
        }
        BackpackContainerMenu menu = (BackpackContainerMenu)class_17032;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1263 container = menu.getBackpackInventory();
        for (i = 0; i < container.method_5439(); ++i) {
            stack = container.method_5438(i);
            if (stack.method_7960() || !container.method_49104(container, i, stack) || !container.method_5437(i, stack)) continue;
            stacks.add(stack);
            container.method_5447(i, class_1799.field_8037);
        }
        for (i = 0; i < stacks.size(); ++i) {
            stack = (class_1799)stacks.get(i);
            if (stack.method_7960() || stack.method_7947() >= stack.method_7914()) continue;
            for (int j = i + 1; j < stacks.size(); ++j) {
                class_1799 other = (class_1799)stacks.get(j);
                if (!class_1799.method_31577((class_1799)stack, (class_1799)other)) continue;
                int grow = Math.min(stack.method_7914() - stack.method_7947(), other.method_7947());
                stack.method_7933(grow);
                other.method_7934(grow);
            }
        }
        stacks.removeIf(class_1799::method_7960);
        ItemSorting sorting = message.sorting();
        if (sorting == ItemSorting.CREATIVE_CATEGORY) {
            CreativeCategorySort.buildSortIndex(player.method_73183().method_30349());
        }
        switch (sorting) {
            case SHUFFLE: {
                stacks.sort(sorting.comparator());
                break;
            }
            case ALPHABETICAL: {
                stacks.sort(sorting.comparator().thenComparing(ItemSorting.MOST_DAMAGED.comparator().reversed()));
                break;
            }
            case MOST_DAMAGED: {
                stacks.sort(sorting.comparator().thenComparing(ItemSorting.ALPHABETICAL.comparator()));
                break;
            }
            default: {
                stacks.sort(sorting.comparator().thenComparing(ItemSorting.ALPHABETICAL.comparator()).thenComparing(ItemSorting.MOST_DAMAGED.comparator().reversed()));
            }
        }
        block8: for (class_1799 stack2 : stacks) {
            for (int i2 = 0; i2 < container.method_5439(); ++i2) {
                if (!container.method_5438(i2).method_7960() || !container.method_5437(i2, stack2)) continue;
                container.method_5447(i2, stack2);
                continue block8;
            }
        }
        container.method_5431();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleMessageCheckShelfKey(MessageCheckShelfKey message, PlayMessageContext context) {
        Optional<ShelfKey> shelfKey;
        BackpackContainerMenu menu;
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)class_17032).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        if (menu.getBackpackIndex() != backpackIndex) {
            return;
        }
        if (!menu.getBackpackInventory().method_5443((class_1657)serverPlayer)) {
            return;
        }
        class_1799 stack = BackpackHelper.getBackpackStack((class_1657)serverPlayer, backpackIndex);
        if (stack.method_7960()) {
            return;
        }
        Augments.Position position = message.position();
        Augments augments = Augments.get(stack);
        Augment<?> augment = augments.getAugment(position);
        if (!(augment instanceof RecallAugment)) return;
        RecallAugment recallAugment = (RecallAugment)augment;
        try {
            Optional<ShelfKey> optional;
            shelfKey = optional = recallAugment.shelfKey();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        shelfKey.ifPresentOrElse(key -> {
            boolean valid = false;
            class_3218 keyLevel = serverPlayer.method_51469().method_8503().method_3847(key.level());
            if (keyLevel != null) {
                Recall recall = ((Recall.Access)keyLevel).backpacked$getRecall();
                valid = recall.isShelfAtBlockPos(keyLevel, class_2338.method_10092((long)key.position()));
            }
            Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageResponseShelfKey(backpackIndex, position, valid));
        }, () -> Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageResponseShelfKey(backpackIndex, position, false)));
    }

    public static void handleUnlockAugmentBay(MessageUnlockAugmentBay message, PlayMessageContext context) {
        class_1657 player = context.getPlayer().orElse(null);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof BackpackContainerMenu)) {
            return;
        }
        BackpackContainerMenu menu = (BackpackContainerMenu)class_17032;
        if (!menu.method_7597((class_1657)serverPlayer) || !menu.isOwner()) {
            return;
        }
        Augments.Position position = message.position();
        if (menu.getAugmentBayController().isSlotUnlocked(position.ordinal())) {
            return;
        }
        if (!menu.getAugmentBayController().handleUnlockSlot(serverPlayer, position.ordinal())) {
            return;
        }
        Network.PLAY.sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncUnlockAugmentBay(position));
    }
}

