/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.common;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.event.BackpackedInteractAccess;
import com.mrcrayfish.backpacked.event.entity.InteractedWithEntity;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerMixin
implements BackpackedInventoryAccess {
    @Unique
    public BackpackInventory[] backpacked$Inventory = null;

    @Unique
    private BackpackInventory[] backpacked$Inventory() {
        if (this.backpacked$Inventory == null) {
            this.backpacked$Inventory = new BackpackInventory[ManagementInventory.getMaxEquipable()];
        }
        if (this.backpacked$Inventory.length != ManagementInventory.getMaxEquipable()) {
            BackpackInventory[] old = this.backpacked$Inventory;
            this.backpacked$Inventory = new BackpackInventory[ManagementInventory.getMaxEquipable()];
            System.arraycopy(old, 0, this.backpacked$Inventory, 0, Math.min(old.length, this.backpacked$Inventory.length));
        }
        return this.backpacked$Inventory;
    }

    @Override
    public int backpacked$GetBackpackInventoryCount() {
        return this.backpacked$Inventory().length;
    }

    @Override
    @Nullable
    public BackpackInventory backpacked$GetBackpackInventory(int index) {
        BackpackInventory[] inventories = this.backpacked$Inventory();
        if (index < 0 || index >= inventories.length) {
            return null;
        }
        class_1657 player = (class_1657)this;
        class_1799 stack = BackpackHelper.getBackpackStack(player, index);
        if (stack.method_7960()) {
            inventories[index] = null;
            return null;
        }
        BackpackItem item = (BackpackItem)stack.method_7909();
        BackpackInventory inventory = inventories[index];
        if (inventory == null || !inventory.getBackpackStack().equals(stack) || inventory.getState().isInvalid()) {
            inventories[index] = inventory = new BackpackInventory(index, item.getColumnCount(), item.getRowCount(), player, stack);
        }
        return inventory;
    }

    @Override
    public Stream<BackpackInventory> backpacked$streamNonNullBackpackInventories() {
        Stream.Builder<BackpackInventory> builder = Stream.builder();
        for (int i = 0; i < this.backpacked$GetBackpackInventoryCount(); ++i) {
            BackpackInventory inventory = this.backpacked$GetBackpackInventory(i);
            if (inventory == null) continue;
            builder.add(inventory);
        }
        return builder.build();
    }

    @Inject(method={"method_5773"}, at={@At(value="HEAD")})
    public void backpacked$TickHead(CallbackInfo ci) {
        BackpackInventory[] inventories;
        for (BackpackInventory inventory : inventories = this.backpacked$Inventory()) {
            if (inventory == null) continue;
            inventory.tick();
        }
    }

    @Inject(method={"method_5652"}, at={@At(value="HEAD")})
    public void backpacked$AddAdditionalSaveData(class_11372 output, CallbackInfo ci) {
        BackpackInventory[] inventories;
        for (BackpackInventory inventory : inventories = this.backpacked$Inventory()) {
            if (inventory == null) continue;
            inventory.saveItemsToStack();
        }
    }

    @Inject(method={"method_7287"}, at={@At(value="HEAD")})
    public void backpacked$InteractHead(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = (class_1657)this;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            BackpackedInteractAccess access = (BackpackedInteractAccess)serverPlayer;
            List<class_2960> capturedIds = access.getBackpacked$CapturedInteractIds();
            capturedIds.clear();
            class_1799 stack = serverPlayer.method_5998(hand);
            ((InteractedWithEntity.Capture)BackpackedEvents.INTERACTED_WITH_ENTITY_CAPTURE.post()).handle(serverPlayer, stack, entity, capturedIds::add);
        }
    }
}

