/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackManagementMenu;
import com.mrcrayfish.backpacked.inventory.container.data.ManagementContainerData;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageShowEquipHint;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.menu.IMenuData;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_747;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends class_1792 {
    public static final class_2561 BACKPACK_TRANSLATION = class_2561.method_43471((String)"container.backpack");
    public static final class_2561 BACKPACK_MANAGEMENT_TRANSLATION = class_2561.method_43471((String)"container.backpack_management");
    public static final class_2561 NO_MORE_BACKPACK_SLOTS_TRANSLATION = class_2561.method_43471((String)"backpacked.gui.no_more_backpack_slots");

    public BackpackItem(class_1792.class_1793 properties) {
        super(properties.method_57349((class_9331)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT).method_57349((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)new UnlockableSlots(0)).method_57349((class_9331)ModDataComponents.UNLOCKABLE_AUGMENT_BAYS.get(), (Object)new UnlockableSlots(0)).method_57349((class_9331)ModDataComponents.AUGMENTS.get(), (Object)Augments.EMPTY));
    }

    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!level.method_8608()) {
            if (BackpackHelper.equipBackpack(player, stack)) {
                Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageShowEquipHint());
                level.method_47967(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)class_3417.field_14581.comp_349(), player.method_5634(), 1.0f, 1.0f, player.method_59922().method_43055());
                return class_1269.field_5812;
            }
            player.method_7353(NO_MORE_BACKPACK_SLOTS_TRANSLATION, true);
        }
        return class_1269.field_5812;
    }

    public int getColumnCount() {
        return (Integer)Config.BACKPACK.inventory.size.columns.get();
    }

    public int getRowCount() {
        return (Integer)Config.BACKPACK.inventory.size.rows.get();
    }

    public int getMaxAugmentBays(class_1799 stack) {
        return 3;
    }

    public boolean method_31568() {
        return false;
    }

    public static boolean openBackpack(class_3222 ownerPlayer, class_3222 openingPlayer, int backpackIndex) {
        BackpackInventory inventory = ((BackpackedInventoryAccess)ownerPlayer).backpacked$GetBackpackInventory(backpackIndex);
        if (inventory != null) {
            class_1799 backpack = inventory.getBackpackStack();
            class_1792 class_17922 = backpack.method_7909();
            if (!(class_17922 instanceof BackpackItem)) {
                return false;
            }
            BackpackItem item = (BackpackItem)class_17922;
            if (Objects.equals(ownerPlayer, openingPlayer)) {
                ModSyncedDataKeys.SELECTED_BACKPACK.setValue((class_1297)ownerPlayer, (Object)backpackIndex);
            }
            class_2561 title = backpack.method_57826(class_9334.field_49631) ? backpack.method_7964() : BACKPACK_TRANSLATION;
            int cols = item.getColumnCount();
            int rows = item.getRowCount();
            boolean owner = ownerPlayer.equals((Object)openingPlayer);
            UnlockableSlots slots = item.getUnlockableSlots(backpack);
            Pagination pagination = BackpackHelper.createPaginationInfo((class_1657)ownerPlayer, backpackIndex);
            Augments augments = Augments.get(backpack);
            UnlockableSlots bays = item.getUnlockableAugmentBays(backpack);
            Services.BACKPACK.openBackpackScreen(openingPlayer, inventory, ownerPlayer.method_5628(), backpackIndex, cols, rows, owner, slots, pagination, augments, title, bays);
            return true;
        }
        if (Objects.equals(ownerPlayer, openingPlayer)) {
            BackpackItem.openBackpackManagement(ownerPlayer, false);
        }
        return false;
    }

    public static void openBackpackManagement(class_3222 player, boolean showInventoryButton) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots((class_1657)player);
        FrameworkAPI.openMenuWithData((class_3222)player, (class_3908)new class_747((id, playerInventory, entity) -> {
            class_3919 data = new class_3919(1);
            data.method_17391(0, BackpackHelper.getFirstBackpackStack((class_1657)player).method_7960() ? 0 : 1);
            return new BackpackManagementMenu(id, player.method_31548(), new ManagementInventory(player), (class_3913)data, slots, showInventoryButton);
        }, BACKPACK_MANAGEMENT_TRANSLATION), (IMenuData)new ManagementContainerData(slots, showInventoryButton));
    }

    @Nullable
    public UnlockableSlots getUnlockableSlots(class_1799 stack) {
        int initialUnlocked;
        UnlockableSlots before;
        if (!stack.method_31574((class_1792)this)) {
            return null;
        }
        if (((Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get()).booleanValue()) {
            return UnlockableSlots.ALL;
        }
        UnlockableSlots slots = (UnlockableSlots)stack.method_58694((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get());
        if (slots == null) {
            slots = new UnlockableSlots(this.getColumnCount() * this.getRowCount());
            stack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
            return slots;
        }
        int maxSlots = this.getColumnCount() * this.getRowCount();
        if (slots.getMaxSlots() != maxSlots) {
            slots = slots.setMaxSlots(maxSlots);
            stack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
        }
        if ((before = slots) != (slots = BackpackHelper.unlockInitialSlots(slots, initialUnlocked = ((Integer)Config.BACKPACK.inventory.slots.initialUnlockedSlots.get()).intValue()))) {
            stack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
        }
        return slots;
    }

    @Nullable
    public UnlockableSlots getUnlockableAugmentBays(class_1799 stack) {
        if (!stack.method_31574((class_1792)this)) {
            return null;
        }
        if (((Boolean)Config.BACKPACK.augmentBays.unlockAllAugmentBays.get()).booleanValue()) {
            return UnlockableSlots.ALL;
        }
        UnlockableSlots slots = (UnlockableSlots)stack.method_58694((class_9331)ModDataComponents.UNLOCKABLE_AUGMENT_BAYS.get());
        if (slots == null) {
            slots = new UnlockableSlots(this.getMaxAugmentBays(stack));
            stack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_AUGMENT_BAYS.get(), (Object)slots);
            return slots;
        }
        int maxBays = this.getMaxAugmentBays(stack);
        if (slots.getMaxSlots() != maxBays) {
            slots = slots.setMaxSlots(maxBays);
            stack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_AUGMENT_BAYS.get(), (Object)slots);
        }
        if (((Boolean)Config.BACKPACK.augmentBays.unlockFirstAugmentBay.get()).booleanValue() && !slots.isUnlocked(0)) {
            slots = slots.unlockSlot(0);
            stack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_AUGMENT_BAYS.get(), (Object)slots);
        }
        return slots;
    }
}

